/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.sharedui.utils;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.merlyn.sharedui.utils.SystemOs;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u001a\u0006\u0010\r\u001a\u00020\u0001\u001a\u0006\u0010\u000e\u001a\u00020\u0001\u001a\u0006\u0010\u000f\u001a\u00020\u0001\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u001b\u0010\b\u001a\u00020\u00018FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"osName", "", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "targetOs", "Lorg/merlyn/sharedui/utils/SystemOs;", "getTargetOs", "()Lorg/merlyn/sharedui/utils/SystemOs;", "processName", "getProcessName", "()Ljava/lang/String;", "processName$delegate", "Lkotlin/Lazy;", "getCmdPath", "getPowerShellPath", "getDriverInstallationLogsPath", "sharedui"})
@SourceDebugExtension(value={"SMAP\nSystemUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystemUtils.kt\norg/merlyn/sharedui/utils/SystemUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1#2:43\n*E\n"})
public final class SystemUtilsKt {
    private static final String osName;
    @NotNull
    private static final SystemOs targetOs;
    @NotNull
    private static final Lazy processName$delegate;

    @NotNull
    public static final SystemOs getTargetOs() {
        return targetOs;
    }

    @NotNull
    public static final String getProcessName() {
        Lazy lazy = processName$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public static final String getCmdPath() {
        Object object;
        block6: {
            block5: {
                String string;
                object = System.getenv("ComSpec");
                if (object == null) break block5;
                String it = string = object;
                boolean bl = false;
                object = StringsKt.contains$default((CharSequence)it, (CharSequence)"cmd.exe", (boolean)false, (int)2, null) ? string : null;
                if (object != null) break block6;
            }
            String string = System.getenv("SystemRoot");
            if (string != null) {
                String it = string;
                boolean bl = false;
                object = it + "\\system32\\cmd.exe";
            } else {
                object = "c:\\windows\\system32\\cmd.exe";
            }
        }
        return object;
    }

    @NotNull
    public static final String getPowerShellPath() {
        Object object;
        block3: {
            block2: {
                object = System.getenv("SystemRoot");
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = it + "\\system32\\WindowsPowerShell\\v1.0\\powershell.exe";
                object = string;
                if (string != null) break block3;
            }
            object = "C:\\Windows\\system32\\WindowsPowerShell\\v1.0\\powershell.exe";
        }
        return object;
    }

    @NotNull
    public static final String getDriverInstallationLogsPath() {
        Object object;
        block3: {
            block2: {
                object = System.getenv("SystemRoot");
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = it + "\\DPINST.LOG";
                object = string;
                if (string != null) break block3;
            }
            object = "C:\\Windows\\DPINST.LOG";
        }
        return object;
    }

    private static final String processName_delegate$lambda$0() {
        String string;
        Optional<String> path = ProcessHandle.current().info().command();
        if (path.isPresent()) {
            String string2 = path.get();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"get(...)");
            Path path2 = Paths.get(string2, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            Path path3 = path2.getFileName();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getFileName(...)");
            string = PathsKt.getName((Path)path3);
        } else {
            string = "";
        }
        return string;
    }

    static {
        SystemOs systemOs;
        osName = System.getProperty("os.name");
        String string = osName;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"osName");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Mac", (boolean)false, (int)2, null)) {
            systemOs = SystemOs.MACOS;
        } else {
            String string2 = osName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"osName");
            if (StringsKt.startsWith$default((String)string2, (String)"Win", (boolean)false, (int)2, null)) {
                systemOs = SystemOs.WINDOWS;
            } else {
                String string3 = osName;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"osName");
                if (StringsKt.startsWith$default((String)string3, (String)"Linux", (boolean)false, (int)2, null)) {
                    systemOs = SystemOs.LINUX;
                } else {
                    throw new IllegalStateException(("Unsupported OS: " + osName).toString());
                }
            }
        }
        targetOs = systemOs;
        processName$delegate = LazyKt.lazy(SystemUtilsKt::processName_delegate$lambda$0);
    }
}

