/*
 * Decompiled with CFR 0.152.
 */
package org.rococoa.internal;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.rococoa.cocoa.foundation.NSAutoreleasePool;
import org.rococoa.internal.OperationBatcher;

public class AutoreleaseBatcher
extends OperationBatcher {
    private static final Logger logging = Logger.getLogger("org.rococoa");
    private static final ThreadLocal<AutoreleaseBatcher> threadLocal = new ThreadLocal();
    private NSAutoreleasePool pool;

    public static AutoreleaseBatcher forThread(int batchSize) {
        if (threadLocal.get() == null) {
            threadLocal.set(new AutoreleaseBatcher(batchSize));
        }
        return threadLocal.get();
    }

    public AutoreleaseBatcher(int batchSize) {
        super(batchSize);
    }

    @Override
    protected void operation() {
        if (logging.isLoggable(Level.FINE)) {
            logging.fine("Draining autorelease pool");
        }
        this.pool.drain();
    }

    @Override
    protected void reset() {
        this.pool = NSAutoreleasePool.new_();
    }
}

