/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.codecrete.usb.UsbAlternateInterface;
import net.codecrete.usb.UsbDirection;
import net.codecrete.usb.UsbEndpoint;
import net.codecrete.usb.UsbException;
import org.jetbrains.annotations.NotNull;

public class UsbAlternateInterfaceImpl
implements UsbAlternateInterface {
    private final int alternateInterfaceNumber;
    private final int alternateInterfaceClass;
    private final int alternateInterfaceSubclass;
    private final int alternateInterfaceProtocol;
    private final List<UsbEndpoint> endpointList;

    public UsbAlternateInterfaceImpl(int number, int classCode, int subclassCode, int protocolCode, List<UsbEndpoint> endpoints) {
        this.alternateInterfaceNumber = number;
        this.alternateInterfaceClass = classCode;
        this.alternateInterfaceSubclass = subclassCode;
        this.alternateInterfaceProtocol = protocolCode;
        this.endpointList = endpoints;
        this.endpointList.sort(Comparator.comparingInt(UsbEndpoint::getNumber));
    }

    @Override
    public int getNumber() {
        return this.alternateInterfaceNumber;
    }

    @Override
    public int getClassCode() {
        return this.alternateInterfaceClass;
    }

    @Override
    public int getSubclassCode() {
        return this.alternateInterfaceSubclass;
    }

    @Override
    public int getProtocolCode() {
        return this.alternateInterfaceProtocol;
    }

    @Override
    @NotNull
    public List<UsbEndpoint> getEndpoints() {
        return Collections.unmodifiableList(this.endpointList);
    }

    void addEndpoint(UsbEndpoint endpoint) {
        this.endpointList.add(endpoint);
    }

    @Override
    @NotNull
    public UsbEndpoint getEndpoint(int endpointNumber, UsbDirection direction) {
        return this.endpointList.stream().filter(ep -> ep.getNumber() == endpointNumber && ep.getDirection() == direction).findFirst().orElseThrow(() -> new UsbException(String.format("Endpoint %d (%s) does not exist", new Object[]{endpointNumber, direction})));
    }
}

