/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import net.codecrete.usb.UsbDevice;
import net.codecrete.usb.UsbException;
import net.codecrete.usb.common.UsbDeviceImpl;

public abstract class UsbDeviceRegistry {
    private static final System.Logger LOG = System.getLogger(UsbDeviceRegistry.class.getName());
    private List<UsbDevice> devices;
    private Throwable failureCause;
    protected Consumer<UsbDevice> onDeviceConnectedHandler;
    protected Consumer<UsbDevice> onDeviceDisconnectedHandler;
    private final Lock lock = new ReentrantLock();
    private final Condition enumerationComplete = this.lock.newCondition();

    public void start() {
        this.startDeviceMonitor(this::monitorDevices);
    }

    protected abstract void monitorDevices();

    public synchronized List<UsbDevice> getAllDevices() {
        return this.devices;
    }

    public void setOnDeviceConnected(Consumer<UsbDevice> handler) {
        this.onDeviceConnectedHandler = handler;
    }

    public void setOnDeviceDisconnected(Consumer<UsbDevice> handler) {
        this.onDeviceDisconnectedHandler = handler;
    }

    protected void emitOnDeviceConnected(UsbDevice device) {
        if (this.onDeviceConnectedHandler == null) {
            return;
        }
        try {
            this.onDeviceConnectedHandler.accept(device);
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.WARNING, "unhandled exception in 'onDeviceConnected' handler - ignoring", (Throwable)e);
        }
    }

    protected void emitOnDeviceDisconnected(UsbDevice device) {
        if (this.onDeviceDisconnectedHandler == null) {
            return;
        }
        try {
            this.onDeviceDisconnectedHandler.accept(device);
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.WARNING, "unhandled exception in 'onDeviceDisconnected' handler - ignoring", (Throwable)e);
        }
    }

    protected void startDeviceMonitor(Runnable monitorTask) {
        Thread t = new Thread(monitorTask, "USB device monitor");
        t.setDaemon(true);
        t.start();
        this.lock.lock();
        try {
            while (this.devices == null && this.failureCause == null) {
                this.enumerationComplete.awaitUninterruptibly();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (this.failureCause != null) {
            throw new UsbException("initial device enumeration has failed", this.failureCause);
        }
    }

    private void signalEnumerationComplete() {
        this.lock.lock();
        try {
            this.enumerationComplete.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void enumerationFailed(Throwable e) {
        this.failureCause = e;
        this.signalEnumerationComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInitialDeviceList(List<UsbDevice> deviceList) {
        UsbDeviceRegistry usbDeviceRegistry = this;
        synchronized (usbDeviceRegistry) {
            this.devices = deviceList;
        }
        this.signalEnumerationComplete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addDevice(UsbDevice device) {
        UsbDeviceRegistry usbDeviceRegistry = this;
        synchronized (usbDeviceRegistry) {
            if (this.findDeviceIndex(this.devices, ((UsbDeviceImpl)device).getUniqueId()) >= 0) {
                return;
            }
            ArrayList<UsbDevice> newDeviceList = new ArrayList<UsbDevice>(this.devices.size() + 1);
            newDeviceList.addAll(this.devices);
            newDeviceList.add(device);
            this.devices = newDeviceList;
        }
        this.emitOnDeviceConnected(device);
    }

    protected void closeAndRemoveDevice(Object deviceId) {
        UsbDevice device = this.findDevice(deviceId);
        if (device == null) {
            return;
        }
        try {
            device.close();
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.INFO, "failed to close USB device - ignoring exception", (Throwable)e);
        }
        this.removeDevice(deviceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDevice(Object deviceId) {
        UsbDevice device;
        UsbDeviceRegistry usbDeviceRegistry = this;
        synchronized (usbDeviceRegistry) {
            int index = this.findDeviceIndex(this.devices, deviceId);
            if (index < 0) {
                return;
            }
            device = this.devices.get(index);
            ArrayList<UsbDevice> newDeviceList = new ArrayList<UsbDevice>(this.devices);
            newDeviceList.remove(index);
            this.devices = newDeviceList;
        }
        this.emitOnDeviceDisconnected(device);
    }

    protected int findDeviceIndex(List<UsbDevice> deviceList, Object deviceId) {
        for (int i = 0; i < deviceList.size(); ++i) {
            UsbDeviceImpl dev = (UsbDeviceImpl)deviceList.get(i);
            if (!deviceId.equals(dev.getUniqueId())) continue;
            return i;
        }
        return -1;
    }

    protected UsbDevice findDevice(Object deviceId) {
        int index = this.findDeviceIndex(this.devices, deviceId);
        if (index < 0) {
            return null;
        }
        return this.devices.get(index);
    }
}

