/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cloudwatchlogs.emf.model;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import software.amazon.cloudwatchlogs.emf.exception.DimensionSetExceededException;
import software.amazon.cloudwatchlogs.emf.exception.InvalidDimensionException;
import software.amazon.cloudwatchlogs.emf.exception.InvalidMetricException;
import software.amazon.cloudwatchlogs.emf.exception.InvalidNamespaceException;
import software.amazon.cloudwatchlogs.emf.exception.InvalidTimestampException;
import software.amazon.cloudwatchlogs.emf.model.DimensionSet;
import software.amazon.cloudwatchlogs.emf.model.Metadata;
import software.amazon.cloudwatchlogs.emf.model.MetricDefinition;
import software.amazon.cloudwatchlogs.emf.model.MetricDirective;
import software.amazon.cloudwatchlogs.emf.model.RootNode;
import software.amazon.cloudwatchlogs.emf.model.StorageResolution;
import software.amazon.cloudwatchlogs.emf.model.Unit;
import software.amazon.cloudwatchlogs.emf.util.Validator;

public class MetricsContext {
    private final RootNode rootNode;
    private MetricDirective metricDirective;
    private final Map<String, StorageResolution> metricNameAndResolutionMap = new HashMap<String, StorageResolution>();

    public MetricsContext() {
        this(new RootNode());
    }

    public MetricsContext(RootNode rootNode) {
        this.rootNode = rootNode;
        this.metricDirective = rootNode.getAws().createMetricDirective();
    }

    public MetricsContext(MetricDirective metricDirective) {
        this();
        this.rootNode.getAws().setMetricDirective(metricDirective);
        this.metricDirective = metricDirective;
    }

    public MetricsContext(String namespace, Map<String, Object> properties, List<DimensionSet> dimensionSets, DimensionSet defaultDimensionSet) throws InvalidNamespaceException {
        this();
        this.setNamespace(namespace);
        this.setDefaultDimensions(defaultDimensionSet);
        for (DimensionSet dimensionSet : dimensionSets) {
            this.putDimension(dimensionSet);
        }
        for (Map.Entry entry : properties.entrySet()) {
            this.putProperty((String)entry.getKey(), entry.getValue());
        }
    }

    public String getNamespace() {
        return this.metricDirective.getNamespace();
    }

    public void setNamespace(String namespace) throws InvalidNamespaceException {
        Validator.validateNamespace(namespace);
        this.metricDirective.setNamespace(namespace);
    }

    public DimensionSet getDefaultDimensions() {
        return this.metricDirective.getDefaultDimensions();
    }

    public void setDefaultDimensions(DimensionSet dimensionSet) {
        this.metricDirective.setDefaultDimensions(dimensionSet);
    }

    public boolean hasDefaultDimensions() {
        return !this.getDefaultDimensions().getDimensionKeys().isEmpty();
    }

    public void putMetric(String key, double value, Unit unit, StorageResolution storageResolution) throws InvalidMetricException {
        Validator.validateMetric(key, value, unit, storageResolution, this.metricNameAndResolutionMap);
        this.metricDirective.putMetric(key, value, unit, storageResolution);
        this.metricNameAndResolutionMap.put(key, storageResolution);
    }

    public void putMetric(String key, double value, StorageResolution storageResolution) throws InvalidMetricException {
        this.putMetric(key, value, Unit.NONE, storageResolution);
    }

    public void putMetric(String key, double value, Unit unit) throws InvalidMetricException {
        this.putMetric(key, value, unit, StorageResolution.STANDARD);
    }

    public void putMetric(String key, double value) throws InvalidMetricException {
        this.putMetric(key, value, Unit.NONE, StorageResolution.STANDARD);
    }

    public void putProperty(String name, Object value) {
        this.rootNode.putProperty(name, value);
    }

    public Object getProperty(String name) {
        return this.rootNode.getProperties().get(name);
    }

    public void putDimension(DimensionSet dimensionSet) {
        this.metricDirective.putDimensionSet(dimensionSet);
    }

    public void putDimension(String dimension, String value) throws InvalidDimensionException, DimensionSetExceededException {
        this.metricDirective.putDimensionSet(DimensionSet.of(dimension, value));
    }

    public List<DimensionSet> getDimensions() throws DimensionSetExceededException {
        return this.metricDirective.getAllDimensions();
    }

    public void setDimensions(DimensionSet ... dimensionSets) {
        this.metricDirective.setDimensions(Arrays.asList(dimensionSets));
    }

    public void setDimensions(boolean useDefault, DimensionSet ... dimensionSets) {
        this.metricDirective.setDimensions(useDefault, Arrays.asList(dimensionSets));
    }

    public void resetDimensions(boolean useDefault) {
        this.metricDirective.resetDimensions(useDefault);
    }

    public void putMetadata(String key, Object value) {
        this.rootNode.getAws().putCustomMetadata(key, value);
    }

    public Instant getTimestamp() {
        return this.rootNode.getAws().getTimestamp();
    }

    public void setTimestamp(Instant timestamp) throws InvalidTimestampException {
        Validator.validateTimestamp(timestamp);
        this.rootNode.getAws().setTimestamp(timestamp);
    }

    public MetricsContext createCopyWithContext(boolean preserveDimensions) {
        return new MetricsContext(this.metricDirective.copyWithoutMetrics(preserveDimensions));
    }

    public List<String> serialize() throws JsonProcessingException {
        if (this.rootNode.metrics().size() <= 100 && !this.anyMetricWithTooManyDataPoints(this.rootNode)) {
            return Arrays.asList(this.rootNode.serialize());
        }
        ArrayList<RootNode> nodes = new ArrayList<RootNode>();
        HashMap<String, MetricDefinition> metrics = new HashMap<String, MetricDefinition>();
        LinkedList<MetricDefinition> metricDefinitions = new LinkedList<MetricDefinition>(this.rootNode.metrics().values());
        while (!metricDefinitions.isEmpty()) {
            MetricDefinition metric = (MetricDefinition)metricDefinitions.poll();
            if (metrics.size() == 100 || metrics.containsKey(metric.getName())) {
                nodes.add(this.buildRootNode(metrics));
                metrics = new HashMap();
            }
            if (metric.getValues().size() <= 100) {
                metrics.put(metric.getName(), metric);
                continue;
            }
            metrics.put(metric.getName(), new MetricDefinition(metric.getName(), metric.getUnit(), metric.getStorageResolution(), metric.getValues().subList(0, 100)));
            metricDefinitions.offer(new MetricDefinition(metric.getName(), metric.getUnit(), metric.getStorageResolution(), metric.getValues().subList(100, metric.getValues().size())));
        }
        if (!metrics.isEmpty()) {
            nodes.add(this.buildRootNode(metrics));
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (RootNode node : nodes) {
            strings.add(node.serialize());
        }
        return strings;
    }

    private RootNode buildRootNode(Map<String, MetricDefinition> metrics) {
        Metadata metadata = this.rootNode.getAws();
        MetricDirective md = metadata.getCloudWatchMetrics().get(0);
        Metadata clonedMetadata = metadata.withCloudWatchMetrics(Arrays.asList(md.withMetrics(metrics)));
        return this.rootNode.withAws(clonedMetadata);
    }

    private boolean anyMetricWithTooManyDataPoints(RootNode node) {
        return node.metrics().values().stream().anyMatch(metric -> metric.getValues().size() > 100);
    }

    public RootNode getRootNode() {
        return this.rootNode;
    }
}

