/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.message.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.immutables.value.Generated;
import org.merlyn.message.model.MARData;
import org.merlyn.message.model.MARParsedRequest;

@Generated(from="MARParsedRequest", generator="Immutables")
public final class ImmutableMARParsedRequest
extends MARParsedRequest {
    private final MARData source;
    private final MARData destination;
    private final byte[] data;

    private ImmutableMARParsedRequest(MARData source, MARData destination, byte[] data) {
        this.source = source;
        this.destination = destination;
        this.data = data;
    }

    @Override
    @JsonProperty(value="source")
    public MARData source() {
        return this.source;
    }

    @Override
    @JsonProperty(value="destination")
    public MARData destination() {
        return this.destination;
    }

    @Override
    @JsonProperty(value="data")
    public byte[] data() {
        return (byte[])this.data.clone();
    }

    public final ImmutableMARParsedRequest withSource(MARData value) {
        if (this.source == value) {
            return this;
        }
        MARData newValue = Objects.requireNonNull(value, "source");
        return new ImmutableMARParsedRequest(newValue, this.destination, this.data);
    }

    public final ImmutableMARParsedRequest withDestination(MARData value) {
        if (this.destination == value) {
            return this;
        }
        MARData newValue = Objects.requireNonNull(value, "destination");
        return new ImmutableMARParsedRequest(this.source, newValue, this.data);
    }

    public final ImmutableMARParsedRequest withData(byte ... elements) {
        byte[] newValue = (byte[])elements.clone();
        return new ImmutableMARParsedRequest(this.source, this.destination, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMARParsedRequest && this.equalTo(0, (ImmutableMARParsedRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableMARParsedRequest another) {
        return this.source.equals(another.source) && this.destination.equals(another.destination) && Arrays.equals(this.data, another.data);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.destination.hashCode();
        h += (h << 5) + Arrays.hashCode(this.data);
        return h;
    }

    public String toString() {
        return "MARParsedRequest{source=" + this.source + ", destination=" + this.destination + ", data=" + Arrays.toString(this.data) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMARParsedRequest fromJson(Json json) {
        Builder builder = ImmutableMARParsedRequest.builder();
        if (json.source != null) {
            builder.source(json.source);
        }
        if (json.destination != null) {
            builder.destination(json.destination);
        }
        if (json.data != null) {
            builder.data(json.data);
        }
        return builder.build();
    }

    public static ImmutableMARParsedRequest copyOf(MARParsedRequest instance) {
        if (instance instanceof ImmutableMARParsedRequest) {
            return (ImmutableMARParsedRequest)instance;
        }
        return ImmutableMARParsedRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MARParsedRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SOURCE = 1L;
        private static final long INIT_BIT_DESTINATION = 2L;
        private static final long INIT_BIT_DATA = 4L;
        private long initBits = 7L;
        private MARData source;
        private MARData destination;
        private byte[] data;

        private Builder() {
        }

        public final Builder from(MARParsedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.source(instance.source());
            this.destination(instance.destination());
            this.data(instance.data());
            return this;
        }

        @JsonProperty(value="source")
        public final Builder source(MARData source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="destination")
        public final Builder destination(MARData destination) {
            this.destination = Objects.requireNonNull(destination, "destination");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="data")
        public final Builder data(byte ... data) {
            this.data = (byte[])data.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableMARParsedRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMARParsedRequest(this.source, this.destination, this.data);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("source");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("destination");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("data");
            }
            return "Cannot build MARParsedRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MARParsedRequest", generator="Immutables")
    static final class Json
    extends MARParsedRequest {
        MARData source;
        MARData destination;
        byte[] data;

        Json() {
        }

        @JsonProperty(value="source")
        public void setSource(MARData source) {
            this.source = source;
        }

        @JsonProperty(value="destination")
        public void setDestination(MARData destination) {
            this.destination = destination;
        }

        @JsonProperty(value="data")
        public void setData(byte[] data) {
            this.data = data;
        }

        @Override
        public MARData source() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MARData destination() {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte[] data() {
            throw new UnsupportedOperationException();
        }
    }
}

