/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.message.model;

import org.merlyn.message.model.ImmutableMARData;
import org.merlyn.message.model.MARData;
import org.merlyn.message.model.MARParserException;

public class MARParser {
    private MARParser() {
    }

    public static MARData parse(String value) {
        String[] parts = value.split(":");
        if (parts.length < 2) {
            throw new MARParserException("MAR length should be at least 2");
        }
        MARData.Version version = MARData.Version.fromString(parts[0]);
        MARData.Type type = MARData.Type.fromString(parts[1]);
        ImmutableMARData.Builder builder = ImmutableMARData.builder().marVersion(version).type(type);
        switch (type) {
            case CLIENT: {
                if (parts.length < 3) {
                    throw new MARParserException("No client ID was sent");
                }
                builder.clientId(parts[2]);
                if (parts.length <= 3) break;
                if (parts.length != 5) {
                    throw new MARParserException("Unknown values sent after client ID");
                }
                builder.agentName(parts[3]).agentVersion(parts[4]);
                break;
            }
            case CLOUD: {
                if (parts.length != 4) {
                    throw new MARParserException("Unknown values sent after client ID");
                }
                builder.agentName(parts[2]).agentVersion(parts[3]);
                break;
            }
            case WEB: {
                if (parts.length < 5) {
                    throw new MARParserException("Not enough data sent for the web mar");
                }
                builder.clientId(parts[2]).agentName(parts[3]).agentVersion(parts[4]);
                if (parts.length != 6) break;
                builder.tabId(parts[5]);
                break;
            }
            case SUB: {
                if (parts.length != 3) {
                    throw new MARParserException("Invalid format for sub mar");
                }
                builder.subject(parts[2]);
            }
        }
        return builder.build();
    }

    public static String toString(MARData data) {
        StringBuilder builder = new StringBuilder();
        builder.append("mar1");
        if (data.type().equals((Object)MARData.Type.CLIENT)) {
            builder.append(":client:").append(data.clientId());
            if (data.agentName() != null) {
                builder.append(":").append(data.agentName());
                if (data.agentVersion() != null) {
                    builder.append(":").append(data.agentVersion());
                }
            }
        } else if (data.type().equals((Object)MARData.Type.WEB)) {
            builder.append(":web:").append(data.clientId()).append(":").append(data.agentName()).append(":").append(data.agentVersion());
            if (data.tabId() != null) {
                builder.append(":").append(data.tabId());
            }
        } else if (data.type().equals((Object)MARData.Type.SUB)) {
            builder.append(":sub:").append(data.subject());
        } else {
            builder.append(":cloud:");
            builder.append(data.agentName()).append(":").append(data.agentVersion());
        }
        return builder.toString();
    }
}

