/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.helpers;

import com.microsoft.alm.helpers.StringHelper;
import java.io.File;

public class Path {
    public static String changeExtension(String path, String extension) {
        if (StringHelper.isNullOrEmpty(path)) {
            return path;
        }
        StringBuilder sb = new StringBuilder(path.length());
        String minusLastExtension = Path.getFileNameWithoutExtension(path);
        sb.append(minusLastExtension);
        if (extension != null) {
            if (!extension.startsWith(".") && !path.endsWith(".")) {
                sb.append('.');
            }
            sb.append(extension);
        }
        return sb.toString();
    }

    public static String combine(String path1, String path2) {
        File file = new File(path1, path2);
        return file.getPath();
    }

    public static boolean directoryExists(String path) {
        File file = new File(path);
        return file.exists() && file.isDirectory();
    }

    public static boolean fileExists(String path) {
        File file = new File(path);
        return file.exists() && file.isFile();
    }

    public static String getDirectoryName(String path) {
        File file = new File(path);
        return file.getParent();
    }

    public static String getFileNameWithoutExtension(String path) {
        String result = path.replaceAll("^(.*[/\\\\]?[^/\\\\]*)(\\.[^./\\\\]+)$", "$1");
        return result;
    }

    public static boolean isAbsolute(String path) {
        File file = new File(path);
        return file.isAbsolute();
    }

    public static String construct(String ... segments) {
        StringBuilder builder = new StringBuilder();
        for (String segment : segments) {
            builder.append(segment).append(File.separator);
        }
        int idx = builder.lastIndexOf(File.separator);
        if (idx > -1) {
            builder.deleteCharAt(builder.lastIndexOf(File.separator));
        }
        return builder.toString();
    }
}

