/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.secret;

import com.microsoft.alm.helpers.ObjectExtensions;
import com.microsoft.alm.helpers.XmlHelper;
import com.microsoft.alm.secret.Secret;
import java.nio.charset.Charset;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class Credential
extends Secret {
    public static final int USERNAME_MAX_LENGTH = 511;
    public static final int PASSWORD_MAX_LENGTH = 2047;
    private static final Charset ASCII = Charset.forName("ASCII");
    public static final Credential Empty = new Credential("", "");
    public final String Password;
    public final String Username;

    public Credential(String username, String password) {
        this.Username = ObjectExtensions.coalesce(username, "");
        this.Password = ObjectExtensions.coalesce(password, "");
    }

    public Credential(String username) {
        this(username, "");
    }

    public static Credential fromXml(Node credentialNode) {
        String password = null;
        String username = null;
        NodeList propertyNodes = credentialNode.getChildNodes();
        for (int v = 0; v < propertyNodes.getLength(); ++v) {
            Node propertyNode = propertyNodes.item(v);
            if (propertyNode.getNodeType() != 1) continue;
            String propertyName = propertyNode.getNodeName();
            if ("Password".equals(propertyName)) {
                password = XmlHelper.getText(propertyNode);
                continue;
            }
            if (!"Username".equals(propertyName)) continue;
            username = XmlHelper.getText(propertyNode);
        }
        Credential value = new Credential(username, password);
        return value;
    }

    public Element toXml(Document document) {
        Element valueNode = document.createElement("value");
        Element passwordNode = document.createElement("Password");
        Text passwordValue = document.createTextNode(this.Password);
        passwordNode.appendChild(passwordValue);
        valueNode.appendChild(passwordNode);
        Element usernameNode = document.createElement("Username");
        Text usernameValue = document.createTextNode(this.Username);
        usernameNode.appendChild(usernameValue);
        valueNode.appendChild(usernameNode);
        return valueNode;
    }

    public boolean equals(Object obj) {
        return Credential.operatorEquals(this, obj instanceof Credential ? (Credential)obj : null);
    }

    public int hashCode() {
        return this.Username.hashCode() + 7 * this.Password.hashCode();
    }

    public void contributeHeader(Map<String, String> headers) {
        String credPair = this.Username + ":" + this.Password;
        byte[] credBytes = credPair.getBytes(ASCII);
        String base64enc = DatatypeConverter.printBase64Binary((byte[])credBytes);
        headers.put("Authorization", "Basic " + base64enc);
    }

    public static void validate(Credential credentials) {
        if (credentials == null) {
            throw new IllegalArgumentException("The credentials parameter cannot be null");
        }
        if (credentials.Password.length() > 2047) {
            throw new IllegalArgumentException(String.format("The Password field of the credentials parameter cannot be longer than %1$d characters.", 2047));
        }
        if (credentials.Username.length() > 511) {
            throw new IllegalArgumentException(String.format("The Username field of the credentials parameter cannot be longer than %1$d characters.", 511));
        }
    }

    public static boolean operatorEquals(Credential credential1, Credential credential2) {
        if (credential1 == credential2) {
            return true;
        }
        if (credential1 == null || null == credential2) {
            return false;
        }
        return credential1.Username.equals(credential2.Username) && credential1.Password.equals(credential2.Password);
    }

    public static boolean operatorNotEquals(Credential credential1, Credential credential2) {
        return !Credential.operatorEquals(credential1, credential2);
    }
}

