/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.os;

import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.merlyn.desktopapp.os.DialogType;
import org.merlyn.desktopapp.os.ExitStatus;
import org.merlyn.sharedui.res.Strings;
import org.merlyn.sharedui.splash.SplashScreen;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u000bJ4\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0014\b\u0002\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u000bJ4\u0010\u000e\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J4\u0010\u000f\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00050\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u0011"}, d2={"Lorg/merlyn/desktopapp/os/AppErrorExit;", "", "<init>", "()V", "exitWithDialog", "", "status", "Lorg/merlyn/desktopapp/os/ExitStatus;", "message", "", "exitBlock", "Lkotlin/Function1;", "dialogType", "Lorg/merlyn/desktopapp/os/DialogType;", "showDialogAndExit", "showUglyDialogAndExit", "exit", "app"})
@SourceDebugExtension(value={"SMAP\nAppErrorExit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppErrorExit.kt\norg/merlyn/desktopapp/os/AppErrorExit\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
public final class AppErrorExit {
    @NotNull
    public static final AppErrorExit INSTANCE = new AppErrorExit();

    private AppErrorExit() {
    }

    public final void exitWithDialog(@NotNull ExitStatus status, @NotNull String message, @NotNull Function1<? super ExitStatus, Unit> exitBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(exitBlock, (String)"exitBlock");
        this.exitWithDialog(status, DialogType.Fatal, message, exitBlock);
    }

    public static /* synthetic */ void exitWithDialog$default(AppErrorExit appErrorExit, ExitStatus exitStatus, String string, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = (Function1)new Function1<ExitStatus, Unit>((Object)appErrorExit){

                public final void invoke(ExitStatus p0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                    ((AppErrorExit)this.receiver).exit(p0);
                }
            };
        }
        appErrorExit.exitWithDialog(exitStatus, string, (Function1<? super ExitStatus, Unit>)function1);
    }

    public final void exitWithDialog(@NotNull ExitStatus status, @NotNull DialogType dialogType, @NotNull String message, @NotNull Function1<? super ExitStatus, Unit> exitBlock) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        Intrinsics.checkNotNullParameter((Object)((Object)dialogType), (String)"dialogType");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter(exitBlock, (String)"exitBlock");
        if (SplashScreen.Companion.isSplashVisible()) {
            Platform.runLater(() -> AppErrorExit.exitWithDialog$lambda$0(dialogType, message, exitBlock, status));
        } else {
            Object object;
            Object object2 = this;
            try {
                AppErrorExit $this$exitWithDialog_u24lambda_u242 = object2;
                boolean bl = false;
                if (Platform.isFxApplicationThread()) {
                    $this$exitWithDialog_u24lambda_u242.showDialogAndExit(dialogType, message, exitBlock, status);
                } else {
                    Platform.runLater(() -> AppErrorExit.exitWithDialog$lambda$2$lambda$1($this$exitWithDialog_u24lambda_u242, dialogType, message, exitBlock, status));
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it = object = throwable;
                boolean bl = false;
                INSTANCE.showUglyDialogAndExit(dialogType, message, exitBlock, status);
            }
            Result.box-impl((Object)object2);
        }
    }

    public static /* synthetic */ void exitWithDialog$default(AppErrorExit appErrorExit, ExitStatus exitStatus, DialogType dialogType, String string, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = (Function1)new Function1<ExitStatus, Unit>((Object)appErrorExit){

                public final void invoke(ExitStatus p0) {
                    Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                    ((AppErrorExit)this.receiver).exit(p0);
                }
            };
        }
        appErrorExit.exitWithDialog(exitStatus, dialogType, string, (Function1<? super ExitStatus, Unit>)function1);
    }

    private final void showDialogAndExit(DialogType dialogType, String message, Function1<? super ExitStatus, Unit> exitBlock, ExitStatus status) {
        String title = switch (WhenMappings.$EnumSwitchMapping$0[dialogType.ordinal()]) {
            case 1 -> Strings.INSTANCE.getDIALOG_FATAL_ERROR_TITLE();
            case 2 -> Strings.INSTANCE.getDIALOG_INFORMATION_TITLE();
            default -> throw new NoWhenBranchMatchedException();
        };
        String buttonTitle = switch (WhenMappings.$EnumSwitchMapping$0[dialogType.ordinal()]) {
            case 1 -> Strings.INSTANCE.getDIALOG_FATAL_ERROR_BUTTON();
            case 2 -> Strings.INSTANCE.getDIALOG_INFORMATION_BUTTON();
            default -> throw new NoWhenBranchMatchedException();
        };
        Alert.AlertType alertType = switch (WhenMappings.$EnumSwitchMapping$0[dialogType.ordinal()]) {
            case 1 -> Alert.AlertType.ERROR;
            case 2 -> Alert.AlertType.INFORMATION;
            default -> throw new NoWhenBranchMatchedException();
        };
        Object object = new ButtonType[]{new ButtonType(buttonTitle)};
        Alert alert = new Alert(alertType, message, object);
        alert.setTitle(title);
        alert.setHeaderText(null);
        object = this;
        try {
            AppErrorExit $this$showDialogAndExit_u24lambda_u244 = (AppErrorExit)object;
            boolean bl = false;
            Object object2 = Result.constructor-impl((Object)alert.showAndWait());
        }
        catch (Throwable throwable) {
            Object object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        exitBlock.invoke((Object)status);
    }

    private final void showUglyDialogAndExit(DialogType dialogType, String message, Function1<? super ExitStatus, Unit> exitBlock, ExitStatus status) {
        String title = switch (WhenMappings.$EnumSwitchMapping$0[dialogType.ordinal()]) {
            case 1 -> Strings.INSTANCE.getDIALOG_FATAL_ERROR_TITLE();
            case 2 -> Strings.INSTANCE.getDIALOG_INFORMATION_TITLE();
            default -> throw new NoWhenBranchMatchedException();
        };
        int iconType = switch (WhenMappings.$EnumSwitchMapping$0[dialogType.ordinal()]) {
            case 1 -> 0;
            case 2 -> 1;
            default -> throw new NoWhenBranchMatchedException();
        };
        Icon icon = switch (WhenMappings.$EnumSwitchMapping$0[dialogType.ordinal()]) {
            case 1 -> UIManager.getIcon("OptionPane.errorIcon");
            case 2 -> UIManager.getIcon("OptionPane.informationIcon");
            default -> throw new NoWhenBranchMatchedException();
        };
        String buttonTitle = switch (WhenMappings.$EnumSwitchMapping$0[dialogType.ordinal()]) {
            case 1 -> Strings.INSTANCE.getDIALOG_FATAL_ERROR_BUTTON();
            case 2 -> Strings.INSTANCE.getDIALOG_INFORMATION_BUTTON();
            default -> throw new NoWhenBranchMatchedException();
        };
        Object[] objectArray = new Object[]{buttonTitle};
        JOptionPane.showOptionDialog(null, message, title, -1, iconType, icon, objectArray, null);
        exitBlock.invoke((Object)status);
    }

    public final void exit(@NotNull ExitStatus status) {
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        System.exit(status.getStatus());
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private static final void exitWithDialog$lambda$0(DialogType $dialogType, String $message, Function1 $exitBlock, ExitStatus $status) {
        SplashScreen.Companion.hide();
        INSTANCE.showDialogAndExit($dialogType, $message, (Function1<? super ExitStatus, Unit>)$exitBlock, $status);
    }

    private static final void exitWithDialog$lambda$2$lambda$1(AppErrorExit $this_runCatching, DialogType $dialogType, String $message, Function1 $exitBlock, ExitStatus $status) {
        $this_runCatching.showDialogAndExit($dialogType, $message, (Function1<? super ExitStatus, Unit>)$exitBlock, $status);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DialogType.values().length];
            try {
                nArray[DialogType.Fatal.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DialogType.Informational.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

