/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.service.impl;

import dev.hydraulic.conveyor.control.SoftwareUpdateController;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.service.UpdateServiceCompanion;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/merlyn/desktopapp/service/impl/UpdateServiceCompanionConveyorNativeImpl;", "Lorg/merlyn/desktopapp/service/UpdateServiceCompanion;", "updatable", "", "forceUpdate", "Lkotlin/Lazy;", "<init>", "(ZLkotlin/Lazy;)V", "logger", "Lmu/KLogger;", "controller", "Ldev/hydraulic/conveyor/control/SoftwareUpdateController;", "isServiceAvailable", "isAppUpdateEnabled", "isForcedUpdate", "getCurrentVersion", "", "getLatestVersion", "performUpdate", "app"})
@SourceDebugExtension(value={"SMAP\nUpdateServiceCompanionConveyorNativeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateServiceCompanionConveyorNativeImpl.kt\norg/merlyn/desktopapp/service/impl/UpdateServiceCompanionConveyorNativeImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,59:1\n1#2:60\n*E\n"})
public final class UpdateServiceCompanionConveyorNativeImpl
implements UpdateServiceCompanion {
    private final boolean updatable;
    @NotNull
    private final Lazy<Boolean> forceUpdate;
    @NotNull
    private final KLogger logger;
    @Nullable
    private final SoftwareUpdateController controller;

    public UpdateServiceCompanionConveyorNativeImpl(boolean updatable, @NotNull Lazy<Boolean> forceUpdate) {
        Intrinsics.checkNotNullParameter(forceUpdate, (String)"forceUpdate");
        this.updatable = updatable;
        this.forceUpdate = forceUpdate;
        this.logger = KotlinLogging.INSTANCE.logger(UpdateServiceCompanionConveyorNativeImpl::logger$lambda$1);
        this.controller = SoftwareUpdateController.getInstance();
    }

    public /* synthetic */ UpdateServiceCompanionConveyorNativeImpl(boolean bl, Lazy lazy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            lazy = LazyKt.lazy(UpdateServiceCompanionConveyorNativeImpl::_init_$lambda$0);
        }
        this(bl, (Lazy<Boolean>)lazy);
    }

    @Override
    public boolean isServiceAvailable() {
        SoftwareUpdateController softwareUpdateController = this.controller;
        if (softwareUpdateController == null || (softwareUpdateController = softwareUpdateController.canTriggerUpdateCheckUI()) == null) {
            return false;
        }
        SoftwareUpdateController availability = softwareUpdateController;
        return switch (WhenMappings.$EnumSwitchMapping$0[availability.ordinal()]) {
            case 1 -> true;
            case 2, 3, 4, 5 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    public boolean isAppUpdateEnabled() {
        return this.updatable;
    }

    @Override
    public boolean isForcedUpdate() {
        return (Boolean)this.forceUpdate.getValue();
    }

    @Override
    @Nullable
    public String getCurrentVersion() {
        if (!this.isServiceAvailable()) {
            return null;
        }
        SoftwareUpdateController softwareUpdateController = this.controller;
        return softwareUpdateController != null && (softwareUpdateController = softwareUpdateController.getCurrentVersion()) != null ? softwareUpdateController.getVersion() : null;
    }

    @Override
    @Nullable
    public String getLatestVersion() {
        Object object;
        block3: {
            Object object2;
            if (!this.isServiceAvailable()) {
                return null;
            }
            object = this;
            try {
                UpdateServiceCompanionConveyorNativeImpl $this$getLatestVersion_u24lambda_u242 = object;
                boolean bl = false;
                SoftwareUpdateController softwareUpdateController = $this$getLatestVersion_u24lambda_u242.controller;
                object2 = Result.constructor-impl(softwareUpdateController != null && (softwareUpdateController = softwareUpdateController.getCurrentVersionFromRepository()) != null ? softwareUpdateController.getVersion() : null);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block3;
            Object it = object2 = throwable;
            boolean bl = false;
            this.logger.error((Throwable)it, UpdateServiceCompanionConveyorNativeImpl::getLatestVersion$lambda$4$lambda$3);
        }
        return (String)(Result.isFailure-impl((Object)object) ? null : object);
    }

    @Override
    public boolean performUpdate() {
        if (!this.isServiceAvailable()) {
            return false;
        }
        SoftwareUpdateController softwareUpdateController = this.controller;
        if ((softwareUpdateController != null ? softwareUpdateController.canTriggerUpdateCheckUI() : null) == SoftwareUpdateController.Availability.AVAILABLE) {
            this.controller.triggerUpdateCheckUI();
            return true;
        }
        return false;
    }

    private static final boolean _init_$lambda$0() {
        return false;
    }

    private static final Unit logger$lambda$1() {
        return Unit.INSTANCE;
    }

    private static final Object getLatestVersion$lambda$4$lambda$3() {
        return "Error retrieving latest app version";
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SoftwareUpdateController.Availability.values().length];
            try {
                nArray[SoftwareUpdateController.Availability.AVAILABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SoftwareUpdateController.Availability.UNIMPLEMENTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SoftwareUpdateController.Availability.UNSUPPORTED_PACKAGE_TYPE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SoftwareUpdateController.Availability.NON_GUI_APP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SoftwareUpdateController.Availability.OTHER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

