/*
 * Decompiled with CFR 0.152.
 */
package com.lordcodes.turtle;

import com.lordcodes.turtle.ShellScript;
import java.io.File;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u001a\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\u0014\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006J\u0006\u0010\u0015\u001a\u00020\u0006J\u0006\u0010\u0016\u001a\u00020\u0006J\u0006\u0010\u0017\u001a\u00020\u0006J\u0006\u0010\u0018\u001a\u00020\u0006J\u0014\u0010\u0019\u001a\u00020\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00060\u001bJ\u0006\u0010\u001c\u001a\u00020\u0006J\u001e\u0010\u001d\u001a\u00020\u00062\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0006J\u001e\u0010\u001f\u001a\u00020\u00062\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0006J\u000e\u0010 \u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006J\u0006\u0010!\u001a\u00020\u0006J\u0006\u0010\"\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/lordcodes/turtle/GitCommands;", "", "shell", "Lcom/lordcodes/turtle/ShellScript;", "(Lcom/lordcodes/turtle/ShellScript;)V", "addAll", "", "addTag", "tagName", "message", "checkout", "branch", "createIfNecessary", "", "clone", "repositoryUrl", "Ljava/net/URL;", "destination", "Ljava/io/File;", "commit", "commitAllChanges", "currentBranch", "currentCommit", "currentCommitAuthorEmail", "currentCommitAuthorName", "gitCommand", "arguments", "", "gitInit", "pull", "remote", "push", "pushTag", "pushToOrigin", "status", "turtle"})
@SourceDebugExtension(value={"SMAP\nGitCommands.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitCommands.kt\ncom/lordcodes/turtle/GitCommands\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1#2:251\n*E\n"})
public final class GitCommands {
    @NotNull
    private final ShellScript shell;

    public GitCommands(@NotNull ShellScript shell) {
        Intrinsics.checkNotNullParameter((Object)shell, (String)"shell");
        this.shell = shell;
    }

    @NotNull
    public final String gitInit() {
        return this.gitCommand(CollectionsKt.listOf((Object)"init"));
    }

    @NotNull
    public final String status() {
        Object[] objectArray = new String[]{"status", "--porcelain"};
        return this.gitCommand(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final String addAll() {
        Object[] objectArray = new String[]{"add", "--all"};
        return this.gitCommand(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final String commit(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object[] objectArray = new String[]{"commit", "-a", "-m", message, "--quiet"};
        return this.gitCommand(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final String commitAllChanges(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.addAll();
        return this.commit(message);
    }

    @NotNull
    public final String push(@Nullable String remote, @Nullable String branch) {
        String it;
        Object[] objectArray = new String[]{"push"};
        List arguments = CollectionsKt.mutableListOf((Object[])objectArray);
        String string = remote;
        if (string != null) {
            it = string;
            boolean bl = false;
            arguments.add(it);
        }
        String string2 = branch;
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            arguments.add(it);
        }
        arguments.add("--quiet");
        return this.gitCommand(arguments);
    }

    public static /* synthetic */ String push$default(GitCommands gitCommands, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return gitCommands.push(string, string2);
    }

    @NotNull
    public final String pushToOrigin() {
        return this.push("origin", "HEAD");
    }

    @NotNull
    public final String pull(@Nullable String remote, @Nullable String branch) {
        String it;
        Object[] objectArray = new String[]{"pull"};
        List arguments = CollectionsKt.mutableListOf((Object[])objectArray);
        String string = remote;
        if (string != null) {
            it = string;
            boolean bl = false;
            arguments.add(it);
        }
        String string2 = branch;
        if (string2 != null) {
            it = string2;
            boolean bl = false;
            arguments.add(it);
        }
        arguments.add("--quiet");
        return this.gitCommand(arguments);
    }

    public static /* synthetic */ String pull$default(GitCommands gitCommands, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return gitCommands.pull(string, string2);
    }

    @NotNull
    public final String checkout(@NotNull String branch, boolean createIfNecessary) {
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        Object[] objectArray = new String[]{"checkout"};
        List arguments = CollectionsKt.mutableListOf((Object[])objectArray);
        if (createIfNecessary) {
            arguments.add("-B");
        }
        arguments.add(branch);
        arguments.add("--quiet");
        return this.gitCommand(arguments);
    }

    public static /* synthetic */ String checkout$default(GitCommands gitCommands, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return gitCommands.checkout(string, bl);
    }

    @NotNull
    public final String clone(@NotNull URL repositoryUrl, @Nullable File destination) {
        Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
        String string = repositoryUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        File file = destination;
        return this.clone(string, file != null ? file.toString() : null);
    }

    public static /* synthetic */ String clone$default(GitCommands gitCommands, URL uRL, File file, int n, Object object) {
        if ((n & 2) != 0) {
            file = null;
        }
        return gitCommands.clone(uRL, file);
    }

    @NotNull
    public final String clone(@NotNull String repositoryUrl, @Nullable String destination) {
        Intrinsics.checkNotNullParameter((Object)repositoryUrl, (String)"repositoryUrl");
        Object[] objectArray = new String[]{"clone", repositoryUrl};
        List arguments = CollectionsKt.mutableListOf((Object[])objectArray);
        String string = destination;
        if (string != null) {
            String it = string;
            boolean bl = false;
            arguments.add(it);
        }
        arguments.add("--quiet");
        return this.gitCommand(arguments);
    }

    public static /* synthetic */ String clone$default(GitCommands gitCommands, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return gitCommands.clone(string, string2);
    }

    @NotNull
    public final String addTag(@NotNull String tagName, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object[] objectArray = new String[]{"tag", "-a", tagName, "-m", message};
        return this.gitCommand(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final String pushTag(@NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        Object[] objectArray = new String[]{"push", "origin", tagName};
        return this.gitCommand(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final String currentBranch() {
        Object[] objectArray = new String[]{"rev-parse", "--abbrev-ref", "HEAD"};
        return this.gitCommand(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final String currentCommit() {
        Object[] objectArray = new String[]{"rev-parse", "--verify", "HEAD"};
        return this.gitCommand(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final String currentCommitAuthorEmail() {
        Object[] objectArray = new String[]{"--no-pager", "show", "-s", "--format=%ae"};
        return this.gitCommand(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final String currentCommitAuthorName() {
        Object[] objectArray = new String[]{"--no-pager", "show", "-s", "--format=%an"};
        return this.gitCommand(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public final String gitCommand(@NotNull List<String> arguments) {
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        return ShellScript.command$default(this.shell, "git", arguments, null, 4, null);
    }
}

