/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import net.codecrete.usb.UsbControlTransfer;
import net.codecrete.usb.UsbDirection;
import net.codecrete.usb.UsbEndpoint;
import net.codecrete.usb.UsbInterface;
import net.codecrete.usb.Version;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public interface UsbDevice {
    public int getProductId();

    public int getVendorId();

    public String getProduct();

    public String getManufacturer();

    public String getSerialNumber();

    public int getClassCode();

    public int getSubclassCode();

    public int getProtocolCode();

    @NotNull
    public Version getUsbVersion();

    @NotNull
    public Version getDeviceVersion();

    public void detachStandardDrivers();

    public void attachStandardDrivers();

    public void open();

    public boolean isOpened();

    public void close();

    @NotNull
    public @Unmodifiable List<UsbInterface> getInterfaces();

    @NotNull
    public UsbInterface getInterface(int var1);

    @NotNull
    public UsbEndpoint getEndpoint(UsbDirection var1, int var2);

    public void claimInterface(int var1);

    public void selectAlternateSetting(int var1, int var2);

    public void releaseInterface(int var1);

    public byte @NotNull [] controlTransferIn(@NotNull UsbControlTransfer var1, int var2);

    public void controlTransferOut(@NotNull UsbControlTransfer var1, byte[] var2);

    public void transferOut(int var1, byte @NotNull [] var2);

    public void transferOut(int var1, byte @NotNull [] var2, int var3);

    public void transferOut(int var1, byte @NotNull [] var2, int var3, int var4, int var5);

    public byte @NotNull [] transferIn(int var1);

    public byte @NotNull [] transferIn(int var1, int var2);

    @NotNull
    public OutputStream openOutputStream(int var1, int var2);

    @NotNull
    default public OutputStream openOutputStream(int endpointNumber) {
        return this.openOutputStream(endpointNumber, 1);
    }

    @NotNull
    public InputStream openInputStream(int var1, int var2);

    @NotNull
    default public InputStream openInputStream(int endpointNumber) {
        return this.openInputStream(endpointNumber, 1);
    }

    public void abortTransfers(UsbDirection var1, int var2);

    public void clearHalt(UsbDirection var1, int var2);

    public byte @NotNull [] getDeviceDescriptor();

    public byte @NotNull [] getConfigurationDescriptor();
}

