/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.windows.winsdk;

import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import net.codecrete.usb.windows.Win;

public class Kernel32B {
    private static final Linker LINKER;
    private static final SymbolLookup LOOKUP;
    private static final FunctionDescriptor CreateFileW$FUNC;
    private static final MethodHandle CreateFileW$MH;
    private static final FunctionDescriptor DeviceIoControl$FUNC;
    private static final MethodHandle DeviceIoControl$MH;
    private static final FunctionDescriptor GetQueuedCompletionStatus$FUNC;
    private static final MethodHandle GetQueuedCompletionStatus$MH;
    private static final FunctionDescriptor CreateIoCompletionPort$FUNC;
    private static final MethodHandle CreateIoCompletionPort$MH;

    private Kernel32B() {
    }

    public static MemorySegment CreateFileW(MemorySegment lpFileName, int dwDesiredAccess, int dwShareMode, MemorySegment lpSecurityAttributes, int dwCreationDisposition, int dwFlagsAndAttributes, MemorySegment hTemplateFile, MemorySegment lastErrorState) {
        try {
            return CreateFileW$MH.invokeExact(lastErrorState, lpFileName, dwDesiredAccess, dwShareMode, lpSecurityAttributes, dwCreationDisposition, dwFlagsAndAttributes, hTemplateFile);
        }
        catch (Throwable ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static int DeviceIoControl(MemorySegment hDevice, int dwIoControlCode, MemorySegment lpInBuffer, int nInBufferSize, MemorySegment lpOutBuffer, int nOutBufferSize, MemorySegment lpBytesReturned, MemorySegment lpOverlapped, MemorySegment lastErrorState) {
        try {
            return DeviceIoControl$MH.invokeExact(lastErrorState, hDevice, dwIoControlCode, lpInBuffer, nInBufferSize, lpOutBuffer, nOutBufferSize, lpBytesReturned, lpOverlapped);
        }
        catch (Throwable ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static int GetQueuedCompletionStatus(MemorySegment CompletionPort, MemorySegment lpNumberOfBytesTransferred, MemorySegment lpCompletionKey, MemorySegment lpOverlapped, int dwMilliseconds, MemorySegment lastErrorState) {
        try {
            return GetQueuedCompletionStatus$MH.invokeExact(lastErrorState, CompletionPort, lpNumberOfBytesTransferred, lpCompletionKey, lpOverlapped, dwMilliseconds);
        }
        catch (Throwable ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static MemorySegment CreateIoCompletionPort(MemorySegment FileHandle, MemorySegment ExistingCompletionPort, long CompletionKey, int NumberOfConcurrentThreads, MemorySegment lastErrorState) {
        try {
            return CreateIoCompletionPort$MH.invokeExact(lastErrorState, FileHandle, ExistingCompletionPort, CompletionKey, NumberOfConcurrentThreads);
        }
        catch (Throwable ex) {
            throw new AssertionError((Object)ex);
        }
    }

    static {
        System.loadLibrary("Kernel32");
        LINKER = Linker.nativeLinker();
        LOOKUP = SymbolLookup.loaderLookup();
        CreateFileW$FUNC = FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS);
        CreateFileW$MH = LINKER.downcallHandle(LOOKUP.find("CreateFileW").get(), CreateFileW$FUNC, Win.LAST_ERROR_STATE);
        DeviceIoControl$FUNC = FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS);
        DeviceIoControl$MH = LINKER.downcallHandle(LOOKUP.find("DeviceIoControl").get(), DeviceIoControl$FUNC, Win.LAST_ERROR_STATE);
        GetQueuedCompletionStatus$FUNC = FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT);
        GetQueuedCompletionStatus$MH = LINKER.downcallHandle(LOOKUP.find("GetQueuedCompletionStatus").get(), GetQueuedCompletionStatus$FUNC, Win.LAST_ERROR_STATE);
        CreateIoCompletionPort$FUNC = FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT);
        CreateIoCompletionPort$MH = LINKER.downcallHandle(LOOKUP.find("CreateIoCompletionPort").get(), CreateIoCompletionPort$FUNC, Win.LAST_ERROR_STATE);
    }
}

