/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.core.analytics;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.merlyn.agent.KeyEventImplKt;
import org.merlyn.agent.model.Action;
import org.merlyn.agent.model.Intent;
import org.merlyn.agent.model.KeyEvent;
import org.merlyn.agent.model.Locator;
import org.merlyn.agent.model.Message;
import org.merlyn.agent.model.MessageExtKt;
import org.merlyn.agent.model.Operation;
import org.merlyn.core.analytics.AnalyticsLogger;
import org.merlyn.core.analytics.AnalyticsRcuButtonActivityLogger;
import org.merlyn.core.analytics.BaseAnalyticsLogger;
import org.merlyn.dataplatform.EventBuilder;
import org.merlyn.dataplatform.OutcomeType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lorg/merlyn/core/analytics/AnalyticsInvokeAgentLogger;", "Lorg/merlyn/core/analytics/BaseAnalyticsLogger;", "analyticsLogger", "Lorg/merlyn/core/analytics/AnalyticsLogger;", "<init>", "(Lorg/merlyn/core/analytics/AnalyticsLogger;)V", "getAnalyticsLogger", "()Lorg/merlyn/core/analytics/AnalyticsLogger;", "eventTypeId", "", "getEventTypeId", "()Ljava/lang/String;", "logOperation", "", "message", "Lorg/merlyn/agent/model/Message;", "consumed", "", "MetricsOperationName", "sdkCore"})
@SourceDebugExtension(value={"SMAP\nAnalyticsInvokeAgentLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnalyticsInvokeAgentLogger.kt\norg/merlyn/core/analytics/AnalyticsInvokeAgentLogger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,57:1\n1#2:58\n216#3,2:59\n*S KotlinDebug\n*F\n+ 1 AnalyticsInvokeAgentLogger.kt\norg/merlyn/core/analytics/AnalyticsInvokeAgentLogger\n*L\n42#1:59,2\n*E\n"})
public final class AnalyticsInvokeAgentLogger
implements BaseAnalyticsLogger {
    @NotNull
    private final AnalyticsLogger analyticsLogger;
    @NotNull
    private final String eventTypeId;

    public AnalyticsInvokeAgentLogger(@NotNull AnalyticsLogger analyticsLogger) {
        Intrinsics.checkNotNullParameter((Object)analyticsLogger, (String)"analyticsLogger");
        this.analyticsLogger = analyticsLogger;
        this.eventTypeId = "InvokeDeviceAgent";
    }

    @Override
    @NotNull
    public AnalyticsLogger getAnalyticsLogger() {
        return this.analyticsLogger;
    }

    @Override
    @NotNull
    public String getEventTypeId() {
        return this.eventTypeId;
    }

    /*
     * WARNING - void declaration
     */
    public final void logOperation(@NotNull Message message, boolean consumed) {
        String string;
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Operation operation = MessageExtKt.getOperation(message);
        Locator locator = new Locator(message.getDestination());
        EventBuilder eventBuilder = EventBuilder.Companion.create(this.getEventTypeId(), MessageExtKt.getRequestId(message)).setOutcomeType(consumed ? OutcomeType.CONSUMED : OutcomeType.FAILED);
        String string2 = locator.getAgentName();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = locator.getAgentVersion()) == null) {
            string = "";
        }
        EventBuilder eventBuilder2 = eventBuilder.setAgent(string2, string);
        Operation operation2 = operation;
        if (operation2 instanceof Action) {
            eventBuilder2.setOperation(MetricsOperationName.HANDLE_ACTION.getDisplayName()).setAction(((Action)operation).getAction());
            JsonObject jsonObject = ((Action)operation).getParams();
            if (jsonObject != null) {
                JsonObject it = jsonObject;
                boolean bl = false;
                eventBuilder2.set("actionParams", it.toString());
            }
        } else if (operation2 instanceof Intent) {
            eventBuilder2.setOperation(MetricsOperationName.HANDLE_INTENT.getDisplayName()).setIntent(((Intent)operation).getIntent());
            JsonObject jsonObject = ((Intent)operation).getParams();
            if (jsonObject != null) {
                JsonObject it = jsonObject;
                boolean bl = false;
                eventBuilder2.set("intentParams", it.toString());
            }
        } else if (operation2 instanceof KeyEvent) {
            void $this$forEach$iv;
            eventBuilder2.setOperation(MetricsOperationName.HANDLE_RCU_BUTTON.getDisplayName());
            Map<String, String> map2 = AnalyticsRcuButtonActivityLogger.Companion.getButtonMetadata(KeyEventImplKt.toKeyEvent((KeyEvent)operation));
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                eventBuilder2.set(key, value);
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.log(eventBuilder2);
    }

    @Override
    public void log(@NotNull EventBuilder eventBuilder) {
        BaseAnalyticsLogger.DefaultImpls.log(this, eventBuilder);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/merlyn/core/analytics/AnalyticsInvokeAgentLogger$MetricsOperationName;", "", "displayName", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getDisplayName", "()Ljava/lang/String;", "HANDLE_INTENT", "HANDLE_ACTION", "HANDLE_RCU_BUTTON", "sdkCore"})
    private static final class MetricsOperationName
    extends Enum<MetricsOperationName> {
        @NotNull
        private final String displayName;
        public static final /* enum */ MetricsOperationName HANDLE_INTENT = new MetricsOperationName("handleIntent");
        public static final /* enum */ MetricsOperationName HANDLE_ACTION = new MetricsOperationName("handleAction");
        public static final /* enum */ MetricsOperationName HANDLE_RCU_BUTTON = new MetricsOperationName("handleRcuButton");
        private static final /* synthetic */ MetricsOperationName[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MetricsOperationName(String displayName) {
            this.displayName = displayName;
        }

        @NotNull
        public final String getDisplayName() {
            return this.displayName;
        }

        public static MetricsOperationName[] values() {
            return (MetricsOperationName[])$VALUES.clone();
        }

        public static MetricsOperationName valueOf(String value) {
            return Enum.valueOf(MetricsOperationName.class, value);
        }

        @NotNull
        public static EnumEntries<MetricsOperationName> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = metricsOperationNameArray = new MetricsOperationName[]{MetricsOperationName.HANDLE_INTENT, MetricsOperationName.HANDLE_ACTION, MetricsOperationName.HANDLE_RCU_BUTTON};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

