/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.core.audio;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.merlyn.core.analytics.AnalyticsSpeechSessionResultLogger;
import org.merlyn.core.audio.AudioFormat;
import org.merlyn.core.audio.SpeechSession;
import org.merlyn.core.audio.SpeechSessionFactory;
import org.merlyn.core.audio.SpeechSessionImpl;
import org.merlyn.core.encryption.Encryptor;
import org.merlyn.core.spacecontextservice.SpaceContextService;
import org.merlyn.core.usecase.EncryptorLifecycleUseCase;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/merlyn/core/audio/SpeechSessionFactoryImpl;", "Lorg/merlyn/core/audio/SpeechSessionFactory;", "spaceContextService", "Lorg/merlyn/core/spacecontextservice/SpaceContextService;", "encryptorLifecycleUseCase", "Lorg/merlyn/core/usecase/EncryptorLifecycleUseCase;", "resultLogger", "Lorg/merlyn/core/analytics/AnalyticsSpeechSessionResultLogger;", "<init>", "(Lorg/merlyn/core/spacecontextservice/SpaceContextService;Lorg/merlyn/core/usecase/EncryptorLifecycleUseCase;Lorg/merlyn/core/analytics/AnalyticsSpeechSessionResultLogger;)V", "lastSession", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Ljava/lang/ref/WeakReference;", "Lorg/merlyn/core/audio/SpeechSession;", "sessionsCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "create", "audioConfig", "Lorg/merlyn/core/audio/AudioFormat;", "sdkCore"})
@SourceDebugExtension(value={"SMAP\nSpeechSessionFactoryImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpeechSessionFactoryImpl.kt\norg/merlyn/core/audio/SpeechSessionFactoryImpl\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,42:1\n226#2,5:43\n*S KotlinDebug\n*F\n+ 1 SpeechSessionFactoryImpl.kt\norg/merlyn/core/audio/SpeechSessionFactoryImpl\n*L\n33#1:43,5\n*E\n"})
public final class SpeechSessionFactoryImpl
implements SpeechSessionFactory {
    @NotNull
    private final SpaceContextService spaceContextService;
    @NotNull
    private final EncryptorLifecycleUseCase encryptorLifecycleUseCase;
    @NotNull
    private final AnalyticsSpeechSessionResultLogger resultLogger;
    @NotNull
    private final MutableStateFlow<WeakReference<SpeechSession>> lastSession;
    @NotNull
    private final AtomicInteger sessionsCount;

    public SpeechSessionFactoryImpl(@NotNull SpaceContextService spaceContextService, @NotNull EncryptorLifecycleUseCase encryptorLifecycleUseCase, @NotNull AnalyticsSpeechSessionResultLogger resultLogger) {
        Intrinsics.checkNotNullParameter((Object)spaceContextService, (String)"spaceContextService");
        Intrinsics.checkNotNullParameter((Object)encryptorLifecycleUseCase, (String)"encryptorLifecycleUseCase");
        Intrinsics.checkNotNullParameter((Object)resultLogger, (String)"resultLogger");
        this.spaceContextService = spaceContextService;
        this.encryptorLifecycleUseCase = encryptorLifecycleUseCase;
        this.resultLogger = resultLogger;
        this.lastSession = StateFlowKt.MutableStateFlow(null);
        this.sessionsCount = new AtomicInteger(0);
    }

    @Override
    @NotNull
    public SpeechSession create(@NotNull AudioFormat audioConfig) {
        WeakReference weakReference;
        WeakReference nextValue$iv;
        Object prevValue$iv;
        SpeechSessionImpl speechSessionImpl;
        Intrinsics.checkNotNullParameter((Object)audioConfig, (String)"audioConfig");
        SpeechSessionImpl speechSessionImpl2 = speechSessionImpl = new SpeechSessionImpl(this.spaceContextService, audioConfig, null, null, this.sessionsCount.getAndIncrement(), LazyKt.lazy(() -> SpeechSessionFactoryImpl.create$lambda$0(this)), 0L, null, this.resultLogger, 204, null);
        boolean bl = false;
        MutableStateFlow<WeakReference<SpeechSession>> $this$update$iv = this.lastSession;
        boolean $i$f$update = false;
        do {
            Object object;
            prevValue$iv = $this$update$iv.getValue();
            WeakReference it = (WeakReference)prevValue$iv;
            boolean bl2 = false;
            if (speechSessionImpl2.getOrdinal() > ((object = it) != null && (object = (SpeechSession)((Reference)object).get()) != null ? object.getOrdinal() : -1)) {
                weakReference = new WeakReference<SpeechSessionImpl>(speechSessionImpl2);
                continue;
            }
            weakReference = it;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = weakReference)));
        return speechSessionImpl;
    }

    private static final Encryptor create$lambda$0(SpeechSessionFactoryImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.encryptorLifecycleUseCase.getEncryptor();
    }
}

