/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls.cipher;

import io.ktor.network.tls.cipher.CipherKt;
import io.ktor.network.tls.cipher.CipherUtilsKt;
import io.ktor.network.util.PoolsKt;
import io.ktor.utils.io.core.ByteBuffersKt;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputArraysJVMKt;
import io.ktor.utils.io.core.OutputKt;
import io.ktor.utils.io.pool.ByteBufferPool;
import io.ktor.utils.io.pool.ObjectPool;
import java.nio.ByteBuffer;
import javax.crypto.Cipher;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u001a/\u0010\u0005\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0019\b\u0002\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\b\rH\u0000\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u000e"}, d2={"CryptoBufferPool", "Lio/ktor/utils/io/pool/ObjectPool;", "Ljava/nio/ByteBuffer;", "getCryptoBufferPool", "()Lio/ktor/utils/io/pool/ObjectPool;", "cipherLoop", "Lio/ktor/utils/io/core/ByteReadPacket;", "cipher", "Ljavax/crypto/Cipher;", "header", "Lkotlin/Function1;", "Lio/ktor/utils/io/core/BytePacketBuilder;", "", "Lkotlin/ExtensionFunctionType;", "ktor-network-tls"})
@SourceDebugExtension(value={"SMAP\nCipherUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CipherUtils.kt\nio/ktor/network/tls/cipher/CipherUtilsKt\n+ 2 Builder.kt\nio/ktor/utils/io/core/BuilderKt\n+ 3 Packet.kt\nio/ktor/utils/io/core/PacketKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n12#2,7:76\n19#2,4:85\n39#3:83\n1#4:84\n*S KotlinDebug\n*F\n+ 1 CipherUtils.kt\nio/ktor/network/tls/cipher/CipherUtilsKt\n*L\n21#1:76,7\n21#1:85,4\n29#1:83\n*E\n"})
public final class CipherUtilsKt {
    @NotNull
    private static final ObjectPool<ByteBuffer> CryptoBufferPool = (ObjectPool)new ByteBufferPool(128, 65536);

    @NotNull
    public static final ObjectPool<ByteBuffer> getCryptoBufferPool() {
        return CryptoBufferPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ByteReadPacket cipherLoop(@NotNull ByteReadPacket $this$cipherLoop, @NotNull Cipher cipher2, @NotNull Function1<? super BytePacketBuilder, Unit> header) {
        Intrinsics.checkNotNullParameter((Object)$this$cipherLoop, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cipher2, (String)"cipher");
        Intrinsics.checkNotNullParameter(header, (String)"header");
        ByteBuffer srcBuffer = (ByteBuffer)PoolsKt.getDefaultByteBufferPool().borrow();
        Object dstBuffer = null;
        dstBuffer = CryptoBufferPool.borrow();
        boolean dstBufferFromPool = false;
        dstBufferFromPool = true;
        try {
            ByteReadPacket byteReadPacket;
            boolean $i$f$buildPacket = false;
            BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
            try {
                int rc;
                BytePacketBuilder $this$cipherLoop_u24lambda_u242 = builder$iv;
                boolean bl = false;
                srcBuffer.clear();
                header.invoke((Object)$this$cipherLoop_u24lambda_u242);
                while (true) {
                    rc = srcBuffer.hasRemaining() ? ByteBuffersKt.readAvailable((ByteReadPacket)$this$cipherLoop, (ByteBuffer)srcBuffer) : 0;
                    srcBuffer.flip();
                    if (!srcBuffer.hasRemaining()) {
                        if (rc == -1) break;
                        ByteReadPacket $this$isEmpty$iv = $this$cipherLoop;
                        boolean $i$f$isEmpty = false;
                        if ($this$isEmpty$iv.getEndOfInput()) break;
                    }
                    ((ByteBuffer)dstBuffer).clear();
                    if (cipher2.getOutputSize(srcBuffer.remaining()) > ((ByteBuffer)dstBuffer).remaining()) {
                        if (dstBufferFromPool) {
                            CryptoBufferPool.recycle(dstBuffer);
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)ByteBuffer.allocate(cipher2.getOutputSize(srcBuffer.remaining())), (String)"allocate(cipher.getOutpu\u2026e(srcBuffer.remaining()))");
                        dstBufferFromPool = false;
                    }
                    cipher2.update(srcBuffer, (ByteBuffer)dstBuffer);
                    ((ByteBuffer)dstBuffer).flip();
                    OutputArraysJVMKt.writeFully((Output)((Output)$this$cipherLoop_u24lambda_u242), (ByteBuffer)((ByteBuffer)dstBuffer));
                    srcBuffer.compact();
                }
                int n = rc = !srcBuffer.hasRemaining() ? 1 : 0;
                if (_Assertions.ENABLED && rc == 0) {
                    boolean $i$a$-assert-CipherUtilsKt$cipherLoop$2$32 = false;
                    String $i$a$-assert-CipherUtilsKt$cipherLoop$2$32 = "Cipher loop completed too early: there are unprocessed bytes";
                    throw new AssertionError((Object)$i$a$-assert-CipherUtilsKt$cipherLoop$2$32);
                }
                int n2 = rc = !((ByteBuffer)dstBuffer).hasRemaining() ? 1 : 0;
                if (_Assertions.ENABLED && rc == 0) {
                    boolean bl2 = false;
                    String string = "Not all bytes were appended to the packet";
                    throw new AssertionError((Object)string);
                }
                int requiredBufferSize = cipher2.getOutputSize(0);
                if (requiredBufferSize != 0) {
                    if (requiredBufferSize > ((ByteBuffer)dstBuffer).capacity()) {
                        Output output2 = (Output)$this$cipherLoop_u24lambda_u242;
                        byte[] byArray = cipher2.doFinal();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal()");
                        OutputKt.writeFully$default((Output)output2, (byte[])byArray, (int)0, (int)0, (int)6, null);
                    } else {
                        ((ByteBuffer)dstBuffer).clear();
                        cipher2.doFinal(CipherKt.getEmptyByteBuffer(), (ByteBuffer)dstBuffer);
                        ((ByteBuffer)dstBuffer).flip();
                        if (!((ByteBuffer)dstBuffer).hasRemaining()) {
                            Output output3 = (Output)$this$cipherLoop_u24lambda_u242;
                            byte[] byArray = cipher2.doFinal();
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"cipher.doFinal()");
                            OutputKt.writeFully$default((Output)output3, (byte[])byArray, (int)0, (int)0, (int)6, null);
                        } else {
                            OutputArraysJVMKt.writeFully((Output)((Output)$this$cipherLoop_u24lambda_u242), (ByteBuffer)((ByteBuffer)dstBuffer));
                        }
                    }
                }
                byteReadPacket = builder$iv.build();
            }
            catch (Throwable t$iv) {
                builder$iv.release();
                throw t$iv;
            }
            ByteReadPacket byteReadPacket2 = byteReadPacket;
            return byteReadPacket2;
        }
        finally {
            PoolsKt.getDefaultByteBufferPool().recycle((Object)srcBuffer);
            if (dstBufferFromPool) {
                CryptoBufferPool.recycle(dstBuffer);
            }
        }
    }

    public static /* synthetic */ ByteReadPacket cipherLoop$default(ByteReadPacket byteReadPacket, Cipher cipher2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = cipherLoop.1.INSTANCE;
        }
        return CipherUtilsKt.cipherLoop(byteReadPacket, cipher2, (Function1<? super BytePacketBuilder, Unit>)function1);
    }
}

