/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.sharedui.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeLineJoin;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.WindowEvent;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowCollector;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.sharedui.annotations.DrawableOverlayListener;
import org.merlyn.sharedui.annotations.DrawableOverlayScreenKt;
import org.merlyn.sharedui.annotations.DrawingControlsPane;
import org.merlyn.sharedui.annotations.DrawingTool;
import org.merlyn.sharedui.annotations.PaintStrategy;
import org.merlyn.sharedui.utils.DrawableOverlayEvents;
import org.merlyn.sharedui.viewmodels.usecases.AnnotationPenColor;
import org.merlyn.sharedui.viewmodels.usecases.CurrentScreenState;
import org.merlyn.sharedui.viewmodels.usecases.ScreenState;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u00002\u00020\u0001:\u0004OPQRBi\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u001e\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\n0\t\u0012\u000e\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0016\u0010\u0017J\b\u00105\u001a\u000206H\u0002J\b\u00107\u001a\u000206H\u0002J\u001a\u00108\u001a\u0002062\b\u00109\u001a\u0004\u0018\u00010$2\u0006\u0010:\u001a\u00020$H\u0002J\b\u0010;\u001a\u000206H\u0016J\b\u0010<\u001a\u000206H\u0016J\u0018\u0010=\u001a\u00020$2\u0006\u0010>\u001a\u00020\u00122\u0006\u0010?\u001a\u00020\u0012H\u0002J \u0010@\u001a\u0002062\u0006\u0010A\u001a\u00020$2\u0006\u0010>\u001a\u00020\u00122\u0006\u0010?\u001a\u00020\u0012H\u0002J\u0010\u0010B\u001a\u0002062\b\b\u0002\u0010C\u001a\u00020\u0007J\u000e\u0010D\u001a\u0002062\u0006\u0010E\u001a\u00020\u0010J\u000e\u0010F\u001a\u0002062\u0006\u0010G\u001a\u00020\u000bJ\u001c\u0010B\u001a\u000206*\u00020H2\u0006\u0010>\u001a\u00020\u00122\u0006\u0010?\u001a\u00020\u0012H\u0002J,\u0010B\u001a\u000206*\u00020H2\u0006\u0010I\u001a\u00020\u00122\u0006\u0010J\u001a\u00020\u00122\u0006\u0010>\u001a\u00020\u00122\u0006\u0010?\u001a\u00020\u0012H\u0002J$\u0010K\u001a\u0002062\f\u0010L\u001a\b\u0012\u0004\u0012\u000203022\f\u0010M\u001a\b\u0012\u0004\u0012\u00020302H\u0002J\b\u0010N\u001a\u000206H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0018R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\b\u0012\u0004\u0012\u00020302X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\b\u0012\u0004\u0012\u00020302X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lorg/merlyn/sharedui/annotations/DrawableOverlayScreen;", "Ljavafx/stage/Stage;", "currentScreenState", "Lorg/merlyn/sharedui/viewmodels/usecases/CurrentScreenState;", "drawableOverlayEvents", "Lorg/merlyn/sharedui/utils/DrawableOverlayEvents;", "isWindows", "", "drawingTools", "", "Lkotlin/Triple;", "Lorg/merlyn/sharedui/annotations/DrawingTool;", "", "Lorg/merlyn/sharedui/annotations/PaintStrategy;", "colors", "", "Lorg/merlyn/sharedui/viewmodels/usecases/AnnotationPenColor;", "strokeWidth", "", "isPersistent", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lorg/merlyn/sharedui/viewmodels/usecases/CurrentScreenState;Lorg/merlyn/sharedui/utils/DrawableOverlayEvents;ZLjava/util/List;[Lorg/merlyn/sharedui/viewmodels/usecases/AnnotationPenColor;DZLkotlinx/coroutines/CoroutineScope;)V", "[Lorg/merlyn/sharedui/viewmodels/usecases/AnnotationPenColor;", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "listener", "Lorg/merlyn/sharedui/annotations/DrawableOverlayListener;", "getListener", "()Lorg/merlyn/sharedui/annotations/DrawableOverlayListener;", "setListener", "(Lorg/merlyn/sharedui/annotations/DrawableOverlayListener;)V", "mainCanvas", "Ljavafx/scene/canvas/Canvas;", "currentCanvas", "root", "Ljavafx/scene/layout/StackPane;", "controlsContainer", "Lorg/merlyn/sharedui/annotations/DrawingControlsPane;", "clearColor", "Ljavafx/scene/paint/Color;", "clearColorWindowsHack", "initialPaintColor", "paintColor", "paintStrategy", "selectedDrawingTool", "undoStack", "Ljava/util/Stack;", "Lorg/merlyn/sharedui/annotations/DrawableOverlayScreen$StackItem;", "redoStack", "setCanvasDrawingListeners", "", "setCursorChangeListeners", "finishDrawOperation", "dst", "src", "undo", "redo", "createFullscreenCanvas", "width", "height", "resizeFullscreenCanvas", "canvas", "clear", "explicit", "setPaintColor", "color", "setDrawingTool", "drawingTool", "Ljavafx/scene/canvas/GraphicsContext;", "x", "y", "moveFromStack", "from", "to", "repaint", "HandDrawPaintStrategy", "EllipsePaintStrategy", "RectanglePaintStrategy", "StackItem", "sharedui"})
@SourceDebugExtension(value={"SMAP\nDrawableOverlayScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DrawableOverlayScreen.kt\norg/merlyn/sharedui/annotations/DrawableOverlayScreen\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,485:1\n1563#2:486\n1634#2,3:487\n1869#2,2:491\n1#3:490\n*S KotlinDebug\n*F\n+ 1 DrawableOverlayScreen.kt\norg/merlyn/sharedui/annotations/DrawableOverlayScreen\n*L\n215#1:486\n215#1:487,3\n437#1:491,2\n*E\n"})
public abstract class DrawableOverlayScreen
extends Stage {
    @NotNull
    private final CurrentScreenState currentScreenState;
    @NotNull
    private final DrawableOverlayEvents drawableOverlayEvents;
    private final boolean isWindows;
    @NotNull
    private final List<Triple<DrawingTool, String, PaintStrategy>> drawingTools;
    @Nullable
    private final AnnotationPenColor[] colors;
    private final double strokeWidth;
    private final boolean isPersistent;
    @NotNull
    private final KLogger logger;
    @Nullable
    private DrawableOverlayListener listener;
    @Nullable
    private final Canvas mainCanvas;
    @NotNull
    private final Canvas currentCanvas;
    @NotNull
    private final StackPane root;
    @NotNull
    private final DrawingControlsPane controlsContainer;
    @NotNull
    private final Color clearColor;
    @NotNull
    private final Color clearColorWindowsHack;
    @NotNull
    private final AnnotationPenColor initialPaintColor;
    @NotNull
    private AnnotationPenColor paintColor;
    @NotNull
    private PaintStrategy paintStrategy;
    @NotNull
    private DrawingTool selectedDrawingTool;
    @NotNull
    private final Stack<StackItem> undoStack;
    @NotNull
    private final Stack<StackItem> redoStack;

    /*
     * WARNING - void declaration
     */
    public DrawableOverlayScreen(@NotNull CurrentScreenState currentScreenState, @NotNull DrawableOverlayEvents drawableOverlayEvents, boolean isWindows, @NotNull List<? extends Triple<? extends DrawingTool, String, ? extends PaintStrategy>> drawingTools, @Nullable AnnotationPenColor[] colors, double strokeWidth, boolean isPersistent, @NotNull CoroutineScope scope) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)currentScreenState, (String)"currentScreenState");
        Intrinsics.checkNotNullParameter((Object)drawableOverlayEvents, (String)"drawableOverlayEvents");
        Intrinsics.checkNotNullParameter(drawingTools, (String)"drawingTools");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super(StageStyle.TRANSPARENT);
        this.currentScreenState = currentScreenState;
        this.drawableOverlayEvents = drawableOverlayEvents;
        this.isWindows = isWindows;
        this.drawingTools = drawingTools;
        this.colors = colors;
        this.strokeWidth = strokeWidth;
        this.isPersistent = isPersistent;
        this.logger = KotlinLogging.INSTANCE.logger(DrawableOverlayScreen::logger$lambda$0);
        Color color = Color.TRANSPARENT;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"TRANSPARENT");
        this.clearColor = color;
        this.clearColorWindowsHack = new Color(0.1, 0.1, 0.1, 0.01);
        Object object = this.colors;
        if (this.colors == null || (object = (AnnotationPenColor)((Object)ArraysKt.first((Object[])object))) == null) {
            object = AnnotationPenColor.RED;
        }
        this.initialPaintColor = object;
        this.paintColor = this.initialPaintColor;
        this.paintStrategy = (PaintStrategy)((Triple)CollectionsKt.first(this.drawingTools)).getThird();
        this.selectedDrawingTool = (DrawingTool)((Object)((Triple)CollectionsKt.first(this.drawingTools)).getFirst());
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.setAlwaysOnTop(true);
        Rectangle2D currentScreenBounds = this.currentScreenState.getCurrentScreenVisualBounds();
        double width = currentScreenBounds.getWidth();
        double height = currentScreenBounds.getHeight();
        double x = currentScreenBounds.getMinX();
        double y = currentScreenBounds.getMinY();
        this.root = new StackPane();
        this.root.setBackground(Background.EMPTY);
        this.mainCanvas = this.isPersistent ? this.createFullscreenCanvas(width, height) : null;
        this.currentCanvas = this.createFullscreenCanvas(width, height);
        this.setCanvasDrawingListeners();
        Object[] $this$map$iv = (Object[])this.drawingTools;
        boolean $i$f$map = false;
        Object[] objectArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Triple triple = (Triple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Pair(it.getFirst(), it.getSecond()));
        }
        List drawingToolsControls = (List)destination$iv$iv;
        this.controlsContainer = this.isPersistent ? new DrawingControlsPane(drawingToolsControls, this.colors, (Function1<? super AnnotationPenColor, Unit>)((Function1)new Function1<AnnotationPenColor, Unit>((Object)this){

            public final void invoke(AnnotationPenColor p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                ((DrawableOverlayScreen)((Object)this.receiver)).setPaintColor(p0);
            }
        }), (Function1<? super DrawingTool, Unit>)((Function1)new Function1<DrawingTool, Unit>((Object)this){

            public final void invoke(DrawingTool p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                ((DrawableOverlayScreen)((Object)this.receiver)).setDrawingTool(p0);
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((DrawableOverlayScreen)((Object)this.receiver)).undo();
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                ((DrawableOverlayScreen)((Object)this.receiver)).redo();
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                DrawableOverlayScreen.clear$default((DrawableOverlayScreen)((Object)this.receiver), false, 1, null);
            }
        }), (Function0<Unit>)((Function0)() -> DrawableOverlayScreen._init_$lambda$2(this))) : new DrawingControlsPane(drawingToolsControls, this.colors, (Function1<? super AnnotationPenColor, Unit>)((Function1)new Function1<AnnotationPenColor, Unit>((Object)this){

            public final void invoke(AnnotationPenColor p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                ((DrawableOverlayScreen)((Object)this.receiver)).setPaintColor(p0);
            }
        }), (Function1<? super DrawingTool, Unit>)((Function1)new Function1<DrawingTool, Unit>((Object)this){

            public final void invoke(DrawingTool p0) {
                Intrinsics.checkNotNullParameter((Object)((Object)p0), (String)"p0");
                ((DrawableOverlayScreen)((Object)this.receiver)).setDrawingTool(p0);
            }
        }), null, null, null, (Function0<Unit>)((Function0)() -> DrawableOverlayScreen._init_$lambda$3(this)));
        this.setPaintColor(this.paintColor);
        this.setDrawingTool(this.selectedDrawingTool);
        StackPane.setAlignment((Node)((Node)this.controlsContainer), (Pos)Pos.BOTTOM_CENTER);
        $this$map$iv = new Node[]{this.mainCanvas, this.currentCanvas, this.controlsContainer};
        this.root.getChildren().addAll((Collection)CollectionsKt.listOfNotNull((Object[])$this$map$iv));
        Scene scene = new Scene((Parent)this.root, width, height);
        scene.setFill((Paint)Color.TRANSPARENT);
        this.setWidth(width);
        this.setHeight(height);
        this.setX(x);
        this.setY(y);
        this.setTitle("Merlyn Origin Drawable Overlay");
        this.setScene(scene);
        this.setCursorChangeListeners();
        BuildersKt.launch$default((CoroutineScope)scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DrawableOverlayScreen this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.currentScreenState.getCurrentScreenState().collect(new FlowCollector(){

                            public final Object emit(ScreenState it, Continuation<? super Unit> $completion) {
                                Rectangle2D newScreenBounds = this$0.currentScreenState.getCurrentScreenVisualBounds();
                                double newWidth = newScreenBounds.getWidth();
                                double newHeight = newScreenBounds.getHeight();
                                double newX = newScreenBounds.getMinX();
                                double newY = newScreenBounds.getMinY();
                                this$0.clear(false);
                                if (this$0.mainCanvas != null) {
                                    this$0.resizeFullscreenCanvas(this$0.mainCanvas, newWidth, newHeight);
                                }
                                this$0.resizeFullscreenCanvas(this$0.currentCanvas, newWidth, newHeight);
                                this$0.setCanvasDrawingListeners();
                                this$0.setWidth(newWidth);
                                this$0.setHeight(newHeight);
                                this$0.setX(newX);
                                this$0.setY(newY);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public /* synthetic */ DrawableOverlayScreen(CurrentScreenState currentScreenState, DrawableOverlayEvents drawableOverlayEvents, boolean bl, List list, AnnotationPenColor[] annotationPenColorArray, double d, boolean bl2, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getMain()));
        }
        this(currentScreenState, drawableOverlayEvents, bl, list, annotationPenColorArray, d, bl2, coroutineScope);
    }

    @NotNull
    public final KLogger getLogger() {
        return this.logger;
    }

    @Nullable
    public final DrawableOverlayListener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable DrawableOverlayListener drawableOverlayListener) {
        this.listener = drawableOverlayListener;
    }

    private final void setCanvasDrawingListeners() {
        this.currentCanvas.setOnMousePressed(new EventHandler(this){
            final /* synthetic */ DrawableOverlayScreen this$0;
            {
                this.this$0 = $receiver;
            }

            public final void handle(MouseEvent it) {
                if (it.isPrimaryButtonDown()) {
                    PaintStrategy paintStrategy = DrawableOverlayScreen.access$getPaintStrategy$p(this.this$0);
                    Intrinsics.checkNotNull((Object)it);
                    paintStrategy.onStart(it);
                }
            }
        });
        this.currentCanvas.setOnMouseDragged(new EventHandler(this){
            final /* synthetic */ DrawableOverlayScreen this$0;
            {
                this.this$0 = $receiver;
            }

            public final void handle(MouseEvent event) {
                block0: {
                    Point2D point2D = DrawableOverlayScreen.access$getPaintStrategy$p(this.this$0).getDrawingState().getCurrentPoint();
                    if (point2D == null) break block0;
                    Point2D point2D2 = point2D;
                    DrawableOverlayScreen drawableOverlayScreen = this.this$0;
                    Point2D initial = point2D2;
                    boolean bl = false;
                    PaintStrategy paintStrategy = DrawableOverlayScreen.access$getPaintStrategy$p(drawableOverlayScreen);
                    Intrinsics.checkNotNull((Object)event);
                    paintStrategy.onDrag(event, initial);
                    event.consume();
                }
            }
        });
        this.currentCanvas.setOnMouseReleased(new EventHandler(this){
            final /* synthetic */ DrawableOverlayScreen this$0;
            {
                this.this$0 = $receiver;
            }

            public final void handle(MouseEvent event) {
                if (!event.isPrimaryButtonDown()) {
                    Point2D point2D = DrawableOverlayScreen.access$getPaintStrategy$p(this.this$0).getDrawingState().getCurrentPoint();
                    if (point2D != null) {
                        Point2D point2D2 = point2D;
                        DrawableOverlayScreen drawableOverlayScreen = this.this$0;
                        Point2D initial = point2D2;
                        boolean bl = false;
                        PaintStrategy paintStrategy = DrawableOverlayScreen.access$getPaintStrategy$p(drawableOverlayScreen);
                        Intrinsics.checkNotNull((Object)event);
                        paintStrategy.onEnd(event, initial);
                    }
                    DrawableOverlayScreen.access$finishDrawOperation(this.this$0, DrawableOverlayScreen.access$getMainCanvas$p(this.this$0), DrawableOverlayScreen.access$getCurrentCanvas$p(this.this$0));
                    DrawableOverlayScreen.access$getPaintStrategy$p(this.this$0).getDrawingState().clearPoints();
                    event.consume();
                }
            }
        });
    }

    private final void setCursorChangeListeners() {
        this.setOnShown(arg_0 -> DrawableOverlayScreen.setCursorChangeListeners$lambda$4(this, arg_0));
        this.currentCanvas.setOnMouseEntered(new EventHandler(this){
            final /* synthetic */ DrawableOverlayScreen this$0;
            {
                this.this$0 = $receiver;
            }

            public final void handle(MouseEvent it) {
                DrawableOverlayScreen.access$getCurrentCanvas$p(this.this$0).setCursor(null);
                DrawableOverlayScreen.access$getCurrentCanvas$p(this.this$0).setCursor(Cursor.CROSSHAIR);
            }
        });
        this.currentCanvas.setOnMouseMoved(new EventHandler(this){
            final /* synthetic */ DrawableOverlayScreen this$0;
            {
                this.this$0 = $receiver;
            }

            public final void handle(MouseEvent it) {
                DrawableOverlayScreen.access$getCurrentCanvas$p(this.this$0).setCursor(Cursor.CROSSHAIR);
            }
        });
    }

    private final void finishDrawOperation(Canvas dst, Canvas src) {
        GraphicsContext graphicsContext;
        SnapshotParameters $this$finishDrawOperation_u24lambda_u2452;
        if (this.paintStrategy.getDrawingState().getPaintOperationEmpty() || dst == null) {
            GraphicsContext graphicsContext2;
            GraphicsContext $this$finishDrawOperation_u24lambda_u2452 = graphicsContext2 = src.getGraphicsContext2D();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$finishDrawOperation_u24lambda_u2452);
            this.clear($this$finishDrawOperation_u24lambda_u2452, this.getWidth(), this.getHeight());
            return;
        }
        SnapshotParameters $this$finishDrawOperation_u24lambda_u246 = $this$finishDrawOperation_u24lambda_u2452 = new SnapshotParameters();
        boolean bl = false;
        $this$finishDrawOperation_u24lambda_u246.setFill((Paint)Color.TRANSPARENT);
        SnapshotParameters params = $this$finishDrawOperation_u24lambda_u2452;
        src.setOpacity(1.0);
        WritableImage fullImage = src.snapshot(params, null);
        src.setOpacity(0.5);
        ClosedFloatingPointRange xRange = RangesKt.rangeTo((double)0.0, (double)(fullImage.getWidth() - 1.0));
        ClosedFloatingPointRange yRange = RangesKt.rangeTo((double)0.0, (double)(fullImage.getHeight() - 1.0));
        double x = ((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf(this.paintStrategy.getDrawingState().getMinX() - this.strokeWidth), (ClosedFloatingPointRange)xRange))).doubleValue();
        double y = ((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf(this.paintStrategy.getDrawingState().getMinY() - this.strokeWidth), (ClosedFloatingPointRange)yRange))).doubleValue();
        ClosedFloatingPointRange wRange = RangesKt.rangeTo((double)0.0, (double)(fullImage.getWidth() - x));
        ClosedFloatingPointRange hRange = RangesKt.rangeTo((double)0.0, (double)(fullImage.getHeight() - y));
        double w = ((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf(this.paintStrategy.getDrawingState().getWidth() + this.strokeWidth * (double)2), (ClosedFloatingPointRange)wRange))).doubleValue();
        double h = ((Number)((Object)RangesKt.coerceIn((Comparable)Double.valueOf(this.paintStrategy.getDrawingState().getHeight() + this.strokeWidth * (double)2), (ClosedFloatingPointRange)hRange))).doubleValue();
        PixelReader pixelReader = fullImage.getPixelReader();
        Intrinsics.checkNotNullExpressionValue((Object)pixelReader, (String)"getPixelReader(...)");
        PixelReader reader = pixelReader;
        WritableImage image = new WritableImage(reader, (int)x, (int)y, (int)w, (int)h);
        GraphicsContext $this$finishDrawOperation_u24lambda_u247 = graphicsContext = dst.getGraphicsContext2D();
        boolean bl2 = false;
        $this$finishDrawOperation_u24lambda_u247.drawImage((Image)image, x, y);
        GraphicsContext $this$finishDrawOperation_u24lambda_u248 = graphicsContext = src.getGraphicsContext2D();
        boolean bl3 = false;
        Intrinsics.checkNotNull((Object)$this$finishDrawOperation_u24lambda_u248);
        this.clear($this$finishDrawOperation_u24lambda_u248, x, y, w, h);
        this.undoStack.push(new StackItem(x, y, w, h, image));
        this.redoStack.clear();
    }

    public void undo() {
        DrawableOverlayEvents.DefaultImpls.trackAction$default(this.drawableOverlayEvents, DrawableOverlayEvents.Action.UNDO, null, 2, null);
        this.moveFromStack(this.undoStack, this.redoStack);
        this.repaint();
    }

    public void redo() {
        DrawableOverlayEvents.DefaultImpls.trackAction$default(this.drawableOverlayEvents, DrawableOverlayEvents.Action.REDO, null, 2, null);
        this.moveFromStack(this.redoStack, this.undoStack);
        this.repaint();
    }

    private final Canvas createFullscreenCanvas(double width, double height) {
        GraphicsContext graphicsContext;
        Canvas canvas = new Canvas();
        canvas.setWidth(width);
        canvas.setHeight(height);
        canvas.setOpacity(0.5);
        GraphicsContext $this$createFullscreenCanvas_u24lambda_u249 = graphicsContext = canvas.getGraphicsContext2D();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$createFullscreenCanvas_u24lambda_u249);
        this.clear($this$createFullscreenCanvas_u24lambda_u249, width, height);
        $this$createFullscreenCanvas_u24lambda_u249.setLineWidth(this.strokeWidth);
        $this$createFullscreenCanvas_u24lambda_u249.setStroke((Paint)DrawableOverlayScreenKt.toColor(this.paintColor));
        $this$createFullscreenCanvas_u24lambda_u249.setLineCap(StrokeLineCap.ROUND);
        $this$createFullscreenCanvas_u24lambda_u249.setLineJoin(StrokeLineJoin.ROUND);
        return canvas;
    }

    private final void resizeFullscreenCanvas(Canvas canvas, double width, double height) {
        canvas.setWidth(width);
        canvas.setHeight(height);
    }

    public final void clear(boolean explicit) {
        GraphicsContext graphicsContext;
        this.drawableOverlayEvents.trackAction(DrawableOverlayEvents.Action.CLEAR, explicit);
        Canvas canvas = this.mainCanvas;
        if (canvas != null && (canvas = canvas.getGraphicsContext2D()) != null) {
            Canvas canvas2;
            Canvas $this$clear_u24lambda_u2410 = canvas2 = canvas;
            boolean bl = false;
            this.clear((GraphicsContext)$this$clear_u24lambda_u2410, this.getWidth(), this.getHeight());
        }
        GraphicsContext $this$clear_u24lambda_u2411 = graphicsContext = this.currentCanvas.getGraphicsContext2D();
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$clear_u24lambda_u2411);
        this.clear($this$clear_u24lambda_u2411, this.getWidth(), this.getHeight());
        this.undoStack.clear();
        this.redoStack.clear();
    }

    public static /* synthetic */ void clear$default(DrawableOverlayScreen drawableOverlayScreen, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: clear");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        drawableOverlayScreen.clear(bl);
    }

    public final void setPaintColor(@NotNull AnnotationPenColor color) {
        Intrinsics.checkNotNullParameter((Object)((Object)color), (String)"color");
        this.paintColor = color;
        this.currentCanvas.getGraphicsContext2D().setStroke((Paint)DrawableOverlayScreenKt.toColor(this.paintColor));
        String string = color.name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        this.drawableOverlayEvents.trackColor(string);
        this.controlsContainer.setSelectedColor(DrawableOverlayScreenKt.toColor(color));
    }

    public final void setDrawingTool(@NotNull DrawingTool drawingTool) {
        Object object;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)((Object)drawingTool), (String)"drawingTool");
            this.drawableOverlayEvents.trackTool(drawingTool.name());
            Iterable iterable = this.drawingTools;
            DrawableOverlayScreen drawableOverlayScreen = this;
            Iterable iterable2 = iterable;
            for (Object t : iterable2) {
                Triple it = (Triple)t;
                boolean bl = false;
                if (!(it.getFirst() == drawingTool)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((object = (Triple)v0) == null || (object = (PaintStrategy)object.getThird()) == null) {
            throw new IllegalStateException();
        }
        drawableOverlayScreen.paintStrategy = object;
        this.paintStrategy.setCanvas(this.currentCanvas);
        this.selectedDrawingTool = drawingTool;
        this.controlsContainer.setSelectedDrawingTool(drawingTool);
    }

    private final void clear(GraphicsContext $this$clear, double width, double height) {
        $this$clear.setFill((Paint)this.clearColor);
        $this$clear.clearRect(0.0, 0.0, width, height);
        if (this.isWindows) {
            $this$clear.setFill((Paint)this.clearColorWindowsHack);
            $this$clear.fillRect(0.0, 0.0, width, height);
        }
    }

    private final void clear(GraphicsContext $this$clear, double x, double y, double width, double height) {
        $this$clear.setFill((Paint)this.clearColor);
        $this$clear.clearRect(x, y, width, height);
        if (this.isWindows) {
            $this$clear.setFill((Paint)this.clearColorWindowsHack);
            $this$clear.fillRect(x, y, width, height);
        }
    }

    private final void moveFromStack(Stack<StackItem> from, Stack<StackItem> to) {
        if (from.empty()) {
            return;
        }
        StackItem top = from.pop();
        to.push(top);
    }

    private final void repaint() {
        block1: {
            Canvas canvas;
            Canvas canvas2 = this.mainCanvas;
            if (canvas2 == null || (canvas2 = canvas2.getGraphicsContext2D()) == null) break block1;
            Canvas $this$repaint_u24lambda_u2414 = canvas = canvas2;
            boolean bl = false;
            this.clear((GraphicsContext)$this$repaint_u24lambda_u2414, this.mainCanvas.getWidth(), this.mainCanvas.getHeight());
            Iterable $this$forEach$iv = this.undoStack;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StackItem layer = (StackItem)element$iv;
                boolean bl2 = false;
                $this$repaint_u24lambda_u2414.drawImage((Image)layer.getImage(), layer.getX(), layer.getY());
            }
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(DrawableOverlayScreen this$0) {
        block0: {
            DrawableOverlayListener drawableOverlayListener = this$0.listener;
            if (drawableOverlayListener == null) break block0;
            drawableOverlayListener.onCloseClicked();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(DrawableOverlayScreen this$0) {
        block0: {
            DrawableOverlayListener drawableOverlayListener = this$0.listener;
            if (drawableOverlayListener == null) break block0;
            drawableOverlayListener.onCloseClicked();
        }
        return Unit.INSTANCE;
    }

    private static final void setCursorChangeListeners$lambda$4(DrawableOverlayScreen this$0, WindowEvent it) {
        this$0.currentCanvas.setCursor(null);
        this$0.currentCanvas.setCursor(Cursor.CROSSHAIR);
    }

    public static final /* synthetic */ PaintStrategy access$getPaintStrategy$p(DrawableOverlayScreen $this) {
        return $this.paintStrategy;
    }

    public static final /* synthetic */ void access$finishDrawOperation(DrawableOverlayScreen $this, Canvas dst, Canvas src) {
        $this.finishDrawOperation(dst, src);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J,\u0010\u000e\u001a\u00020\u0005*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0014\u00a8\u0006\u0015"}, d2={"Lorg/merlyn/sharedui/annotations/DrawableOverlayScreen$EllipsePaintStrategy;", "Lorg/merlyn/sharedui/annotations/PaintStrategy;", "<init>", "()V", "onStart", "", "event", "Ljavafx/scene/input/MouseEvent;", "onDrag", "initial", "Ljavafx/geometry/Point2D;", "onEnd", "drawMovement", "current", "drawOval", "Ljavafx/scene/canvas/GraphicsContext;", "startX", "", "startY", "width", "height", "sharedui"})
    public static class EllipsePaintStrategy
    extends PaintStrategy {
        @Override
        public void onStart(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.getDrawingState().setPoints(event.getX(), event.getY());
            this.getDrawingState().setPaintOperationEmpty(true);
            Point2D point2D = DrawableOverlayScreenKt.toPoint2D(event);
            Point2D point2D2 = DrawableOverlayScreenKt.toPoint2D(event).add(1.0, 1.0);
            Intrinsics.checkNotNullExpressionValue((Object)point2D2, (String)"add(...)");
            this.drawMovement(point2D, point2D2);
            event.consume();
        }

        @Override
        public void onDrag(@NotNull MouseEvent event, @NotNull Point2D initial) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
            this.drawMovement(initial, DrawableOverlayScreenKt.toPoint2D(event));
        }

        @Override
        public void onEnd(@NotNull MouseEvent event, @NotNull Point2D initial) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        }

        private final void drawMovement(Point2D initial, Point2D current) {
            block0: {
                GraphicsContext graphicsContext;
                Canvas canvas = this.getCanvas();
                if (canvas == null) break block0;
                Canvas canvas2 = canvas;
                boolean bl = false;
                GraphicsContext $this$drawMovement_u24lambda_u241_u24lambda_u240 = graphicsContext = canvas2.getGraphicsContext2D();
                boolean bl2 = false;
                $this$drawMovement_u24lambda_u241_u24lambda_u240.clearRect(0.0, 0.0, canvas2.getWidth(), canvas2.getHeight());
                double startX = RangesKt.coerceAtMost((double)initial.getX(), (double)current.getX());
                double startY = RangesKt.coerceAtMost((double)initial.getY(), (double)current.getY());
                double endX = RangesKt.coerceAtLeast((double)initial.getX(), (double)current.getX());
                double endY = RangesKt.coerceAtLeast((double)initial.getY(), (double)current.getY());
                double width = endX - startX;
                double height = endY - startY;
                Intrinsics.checkNotNull((Object)$this$drawMovement_u24lambda_u241_u24lambda_u240);
                this.drawOval($this$drawMovement_u24lambda_u241_u24lambda_u240, startX, startY, width, height);
                this.getDrawingState().updateMinAndMax(startX, startY, endX, endY);
                this.getDrawingState().setPaintOperationEmpty(false);
            }
        }

        protected void drawOval(@NotNull GraphicsContext $this$drawOval, double startX, double startY, double width, double height) {
            Intrinsics.checkNotNullParameter((Object)$this$drawOval, (String)"<this>");
            $this$drawOval.strokeOval(startX, startY, width, height);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0006H\u0002J,\u0010\u0012\u001a\u00020\n*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0014R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lorg/merlyn/sharedui/annotations/DrawableOverlayScreen$HandDrawPaintStrategy;", "Lorg/merlyn/sharedui/annotations/PaintStrategy;", "<init>", "()V", "points", "", "Ljavafx/geometry/Point2D;", "getPoints", "()Ljava/util/List;", "onStart", "", "event", "Ljavafx/scene/input/MouseEvent;", "onDrag", "initial", "onEnd", "drawMovement", "current", "draw", "Ljavafx/scene/canvas/GraphicsContext;", "x1", "", "y1", "x2", "y2", "sharedui"})
    public static class HandDrawPaintStrategy
    extends PaintStrategy {
        @NotNull
        private final List<Point2D> points = new ArrayList();

        @NotNull
        protected final List<Point2D> getPoints() {
            return this.points;
        }

        @Override
        public void onStart(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.getDrawingState().setPoints(event.getX(), event.getY());
            this.getDrawingState().setPaintOperationEmpty(true);
            Point2D point = DrawableOverlayScreenKt.toPoint2D(event);
            this.points.clear();
            this.points.add(point);
            this.drawMovement(point, point);
            event.consume();
        }

        @Override
        public void onDrag(@NotNull MouseEvent event, @NotNull Point2D initial) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
            Point2D point = DrawableOverlayScreenKt.toPoint2D(event);
            this.points.add(point);
            this.drawMovement(initial, point);
        }

        @Override
        public void onEnd(@NotNull MouseEvent event, @NotNull Point2D initial) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        }

        private final void drawMovement(Point2D initial, Point2D current) {
            block0: {
                GraphicsContext graphicsContext;
                Canvas canvas = this.getCanvas();
                if (canvas == null) break block0;
                Canvas canvas2 = canvas;
                boolean bl = false;
                GraphicsContext $this$drawMovement_u24lambda_u241_u24lambda_u240 = graphicsContext = canvas2.getGraphicsContext2D();
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)$this$drawMovement_u24lambda_u241_u24lambda_u240);
                this.draw($this$drawMovement_u24lambda_u241_u24lambda_u240, initial.getX(), initial.getY(), current.getX(), current.getY());
                this.getDrawingState().updatePoints(current.getX(), current.getY());
                this.getDrawingState().setPaintOperationEmpty(false);
            }
        }

        protected void draw(@NotNull GraphicsContext $this$draw, double x1, double y1, double x2, double y2) {
            Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
            $this$draw.strokeLine(x1, y1, x2, y2);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J,\u0010\u000e\u001a\u00020\u0005*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0011H\u0014\u00a8\u0006\u0015"}, d2={"Lorg/merlyn/sharedui/annotations/DrawableOverlayScreen$RectanglePaintStrategy;", "Lorg/merlyn/sharedui/annotations/PaintStrategy;", "<init>", "()V", "onStart", "", "event", "Ljavafx/scene/input/MouseEvent;", "onDrag", "initial", "Ljavafx/geometry/Point2D;", "onEnd", "drawMovement", "current", "drawRect", "Ljavafx/scene/canvas/GraphicsContext;", "startX", "", "startY", "width", "height", "sharedui"})
    public static class RectanglePaintStrategy
    extends PaintStrategy {
        @Override
        public void onStart(@NotNull MouseEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.getDrawingState().setPoints(event.getX(), event.getY());
            this.getDrawingState().setPaintOperationEmpty(true);
            Point2D point2D = DrawableOverlayScreenKt.toPoint2D(event);
            Point2D point2D2 = DrawableOverlayScreenKt.toPoint2D(event).add(1.0, 1.0);
            Intrinsics.checkNotNullExpressionValue((Object)point2D2, (String)"add(...)");
            this.drawMovement(point2D, point2D2);
            event.consume();
        }

        @Override
        public void onDrag(@NotNull MouseEvent event, @NotNull Point2D initial) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
            this.drawMovement(initial, DrawableOverlayScreenKt.toPoint2D(event));
        }

        @Override
        public void onEnd(@NotNull MouseEvent event, @NotNull Point2D initial) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        }

        private final void drawMovement(Point2D initial, Point2D current) {
            block0: {
                GraphicsContext graphicsContext;
                Canvas canvas = this.getCanvas();
                if (canvas == null) break block0;
                Canvas canvas2 = canvas;
                boolean bl = false;
                GraphicsContext $this$drawMovement_u24lambda_u241_u24lambda_u240 = graphicsContext = canvas2.getGraphicsContext2D();
                boolean bl2 = false;
                $this$drawMovement_u24lambda_u241_u24lambda_u240.clearRect(0.0, 0.0, canvas2.getWidth(), canvas2.getHeight());
                double startX = RangesKt.coerceAtMost((double)initial.getX(), (double)current.getX());
                double startY = RangesKt.coerceAtMost((double)initial.getY(), (double)current.getY());
                double endX = RangesKt.coerceAtLeast((double)initial.getX(), (double)current.getX());
                double endY = RangesKt.coerceAtLeast((double)initial.getY(), (double)current.getY());
                double width = endX - startX;
                double height = endY - startY;
                Intrinsics.checkNotNull((Object)$this$drawMovement_u24lambda_u241_u24lambda_u240);
                this.drawRect($this$drawMovement_u24lambda_u241_u24lambda_u240, startX, startY, width, height);
                this.getDrawingState().updateMinAndMax(startX, startY, endX, endY);
                this.getDrawingState().setPaintOperationEmpty(false);
            }
        }

        protected void drawRect(@NotNull GraphicsContext $this$drawRect, double startX, double startY, double width, double height) {
            Intrinsics.checkNotNullParameter((Object)$this$drawRect, (String)"<this>");
            $this$drawRect.strokeRoundRect(startX, startY, width, height, 20.0, 20.0);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J;\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lorg/merlyn/sharedui/annotations/DrawableOverlayScreen$StackItem;", "", "x", "", "y", "w", "h", "image", "Ljavafx/scene/image/WritableImage;", "<init>", "(DDDDLjavafx/scene/image/WritableImage;)V", "getX", "()D", "getY", "getW", "getH", "getImage", "()Ljavafx/scene/image/WritableImage;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "", "sharedui"})
    private static final class StackItem {
        private final double x;
        private final double y;
        private final double w;
        private final double h;
        @NotNull
        private final WritableImage image;

        public StackItem(double x, double y, double w, double h, @NotNull WritableImage image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
            this.image = image;
        }

        public final double getX() {
            return this.x;
        }

        public final double getY() {
            return this.y;
        }

        public final double getW() {
            return this.w;
        }

        public final double getH() {
            return this.h;
        }

        @NotNull
        public final WritableImage getImage() {
            return this.image;
        }

        public final double component1() {
            return this.x;
        }

        public final double component2() {
            return this.y;
        }

        public final double component3() {
            return this.w;
        }

        public final double component4() {
            return this.h;
        }

        @NotNull
        public final WritableImage component5() {
            return this.image;
        }

        @NotNull
        public final StackItem copy(double x, double y, double w, double h, @NotNull WritableImage image) {
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            return new StackItem(x, y, w, h, image);
        }

        public static /* synthetic */ StackItem copy$default(StackItem stackItem, double d, double d2, double d3, double d4, WritableImage writableImage, int n, Object object) {
            if ((n & 1) != 0) {
                d = stackItem.x;
            }
            if ((n & 2) != 0) {
                d2 = stackItem.y;
            }
            if ((n & 4) != 0) {
                d3 = stackItem.w;
            }
            if ((n & 8) != 0) {
                d4 = stackItem.h;
            }
            if ((n & 0x10) != 0) {
                writableImage = stackItem.image;
            }
            return stackItem.copy(d, d2, d3, d4, writableImage);
        }

        @NotNull
        public String toString() {
            return "StackItem(x=" + this.x + ", y=" + this.y + ", w=" + this.w + ", h=" + this.h + ", image=" + this.image + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.x);
            result = result * 31 + Double.hashCode(this.y);
            result = result * 31 + Double.hashCode(this.w);
            result = result * 31 + Double.hashCode(this.h);
            result = result * 31 + this.image.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StackItem)) {
                return false;
            }
            StackItem stackItem = (StackItem)other;
            if (Double.compare(this.x, stackItem.x) != 0) {
                return false;
            }
            if (Double.compare(this.y, stackItem.y) != 0) {
                return false;
            }
            if (Double.compare(this.w, stackItem.w) != 0) {
                return false;
            }
            if (Double.compare(this.h, stackItem.h) != 0) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.image, (Object)stackItem.image);
        }
    }
}

