/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.sharedui.dice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.scene.AmbientLight;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.PerspectiveCamera;
import javafx.scene.PointLight;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.merlyn.sharedui.dice.Die6;
import org.merlyn.sharedui.dice.domain.DiceResult;
import org.merlyn.sharedui.viewmodels.usecases.CurrentScreenState;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\b\u0002\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u000eJ$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/merlyn/sharedui/dice/DiceSceneProvider;", "", "currentScreenState", "Lorg/merlyn/sharedui/viewmodels/usecases/CurrentScreenState;", "<init>", "(Lorg/merlyn/sharedui/viewmodels/usecases/CurrentScreenState;)V", "logger", "Lmu/KLogger;", "createDiceScene", "Ljavafx/scene/Scene;", "results", "", "Lorg/merlyn/sharedui/dice/domain/DiceResult;", "width", "", "height", "calculateDiceCoordinates", "Lkotlin/Pair;", "current", "", "total", "Companion", "sharedui"})
@SourceDebugExtension(value={"SMAP\nDiceScene.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiceScene.kt\norg/merlyn/sharedui/dice/DiceSceneProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n1573#2:96\n1604#2,4:97\n37#3:101\n36#3,3:102\n1#4:105\n*S KotlinDebug\n*F\n+ 1 DiceScene.kt\norg/merlyn/sharedui/dice/DiceSceneProvider\n*L\n29#1:96\n29#1:97,4\n63#1:101\n63#1:102,3\n*E\n"})
public final class DiceSceneProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CurrentScreenState currentScreenState;
    @NotNull
    private final KLogger logger;
    public static final double SPACE_BETWEEN_DICE = 25.0;

    public DiceSceneProvider(@NotNull CurrentScreenState currentScreenState) {
        Intrinsics.checkNotNullParameter((Object)currentScreenState, (String)"currentScreenState");
        this.currentScreenState = currentScreenState;
        this.logger = KotlinLogging.INSTANCE.logger(DiceSceneProvider::logger$lambda$0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Scene createDiceScene(@NotNull List<DiceResult> results, double width, double height) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter(results, (String)"results");
        Iterable iterable = results;
        boolean $i$f$mapIndexed = false;
        void var9_7 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            Die6 die6;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            DiceResult diceResult = (DiceResult)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int sides = diceResult.component1();
            int result = diceResult.component2();
            if (sides == 6) {
                void i;
                Die6 die62;
                Die6 $this$createDiceScene_u24lambda_u243_u24lambda_u241 = die62 = new Die6(0.0, 1, null);
                boolean bl2 = false;
                $this$createDiceScene_u24lambda_u243_u24lambda_u241.roll(result);
                Pair<Double, Double> pair = this.calculateDiceCoordinates((int)i, results.size());
                double x = ((Number)pair.component1()).doubleValue();
                double y = ((Number)pair.component2()).doubleValue();
                $this$createDiceScene_u24lambda_u243_u24lambda_u241.move(x, y, 0.0);
                die6 = die62;
            } else {
                this.logger.warn(() -> DiceSceneProvider.createDiceScene$lambda$3$lambda$2(sides));
                die6 = null;
            }
            collection.add(die6);
        }
        List dice = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        PointLight $this$createDiceScene_u24lambda_u244 = $i$f$mapIndexed = new PointLight(Color.WHITE);
        boolean bl = false;
        $this$createDiceScene_u24lambda_u244.setTranslateX(-200.0);
        $this$createDiceScene_u24lambda_u244.setTranslateY(-200.0);
        $this$createDiceScene_u24lambda_u244.setTranslateZ(-400.0);
        PointLight light = $i$f$mapIndexed;
        AmbientLight ambient = new AmbientLight(Color.rgb((int)100, (int)100, (int)100));
        PerspectiveCamera $this$createDiceScene_u24lambda_u245 = bl = new PerspectiveCamera(true);
        boolean bl3 = false;
        $this$createDiceScene_u24lambda_u245.setTranslateZ(-500.0);
        $this$createDiceScene_u24lambda_u245.setNearClip(0.1);
        $this$createDiceScene_u24lambda_u245.setFarClip(1000.0);
        PerspectiveCamera camera = bl;
        Scene scene = new SpreadBuilder(3);
        Collection $this$toTypedArray$iv = dice;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        scene.addSpread((Object)thisCollection$iv.toArray(new Group[0]));
        scene.add((Object)light);
        scene.add((Object)ambient);
        Scene $this$createDiceScene_u24lambda_u246 = scene = new SubScene((Parent)new Group((Node[])scene.toArray((Object[])new Node[scene.size()])), width, height, true, SceneAntialiasing.BALANCED);
        boolean bl4 = false;
        $this$createDiceScene_u24lambda_u246.setCamera((Camera)camera);
        $this$createDiceScene_u24lambda_u246.setFill((Paint)Color.TRANSPARENT);
        Scene subScene = scene;
        scene = new Scene[]{subScene};
        Scene $this$createDiceScene_u24lambda_u247 = scene = new Scene((Parent)new Group((Node[])scene));
        boolean bl5 = false;
        $this$createDiceScene_u24lambda_u247.setFill((Paint)Color.TRANSPARENT);
        return scene;
    }

    public static /* synthetic */ Scene createDiceScene$default(DiceSceneProvider diceSceneProvider, List list, double d, double d2, int n, Object object) {
        if ((n & 2) != 0) {
            d = diceSceneProvider.currentScreenState.getCurrentScreenVisualBounds().getWidth();
        }
        if ((n & 4) != 0) {
            d2 = diceSceneProvider.currentScreenState.getCurrentScreenVisualBounds().getHeight();
        }
        return diceSceneProvider.createDiceScene(list, d, d2);
    }

    @VisibleForTesting
    @NotNull
    public final Pair<Double, Double> calculateDiceCoordinates(int current, int total) {
        if (total == 1) {
            return TuplesKt.to((Object)0.0, (Object)0.0);
        }
        double spacing = 45.0;
        double totalWidth = (double)(total - 1) * spacing;
        double startX = -totalWidth / 2.0;
        double x = startX + (double)current * spacing;
        return TuplesKt.to((Object)x, (Object)0.0);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object createDiceScene$lambda$3$lambda$2(int $sides) {
        return "Unsupported number of sides: " + $sides;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/merlyn/sharedui/dice/DiceSceneProvider$Companion;", "", "<init>", "()V", "SPACE_BETWEEN_DICE", "", "sharedui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

