/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.ExportTransitGatewayRoutesRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ExportTransitGatewayRoutesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ExportTransitGatewayRoutesRequest> {
    private String transitGatewayRouteTableId;
    private SdkInternalList<Filter> filters;
    private String s3Bucket;

    public void setTransitGatewayRouteTableId(String transitGatewayRouteTableId) {
        this.transitGatewayRouteTableId = transitGatewayRouteTableId;
    }

    public String getTransitGatewayRouteTableId() {
        return this.transitGatewayRouteTableId;
    }

    public ExportTransitGatewayRoutesRequest withTransitGatewayRouteTableId(String transitGatewayRouteTableId) {
        this.setTransitGatewayRouteTableId(transitGatewayRouteTableId);
        return this;
    }

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList(filters);
    }

    public ExportTransitGatewayRoutesRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters((Collection<Filter>)new SdkInternalList(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add((Object)ele);
        }
        return this;
    }

    public ExportTransitGatewayRoutesRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public void setS3Bucket(String s3Bucket) {
        this.s3Bucket = s3Bucket;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public ExportTransitGatewayRoutesRequest withS3Bucket(String s3Bucket) {
        this.setS3Bucket(s3Bucket);
        return this;
    }

    @Override
    public Request<ExportTransitGatewayRoutesRequest> getDryRunRequest() {
        Request<ExportTransitGatewayRoutesRequest> request = new ExportTransitGatewayRoutesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTransitGatewayRouteTableId() != null) {
            sb.append("TransitGatewayRouteTableId: ").append(this.getTransitGatewayRouteTableId()).append(",");
        }
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getS3Bucket() != null) {
            sb.append("S3Bucket: ").append(this.getS3Bucket());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportTransitGatewayRoutesRequest)) {
            return false;
        }
        ExportTransitGatewayRoutesRequest other = (ExportTransitGatewayRoutesRequest)obj;
        if (other.getTransitGatewayRouteTableId() == null ^ this.getTransitGatewayRouteTableId() == null) {
            return false;
        }
        if (other.getTransitGatewayRouteTableId() != null && !other.getTransitGatewayRouteTableId().equals(this.getTransitGatewayRouteTableId())) {
            return false;
        }
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getS3Bucket() == null ^ this.getS3Bucket() == null) {
            return false;
        }
        return other.getS3Bucket() == null || other.getS3Bucket().equals(this.getS3Bucket());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTransitGatewayRouteTableId() == null ? 0 : this.getTransitGatewayRouteTableId().hashCode());
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getS3Bucket() == null ? 0 : this.getS3Bucket().hashCode());
        return hashCode;
    }

    public ExportTransitGatewayRoutesRequest clone() {
        return (ExportTransitGatewayRoutesRequest)super.clone();
    }
}

