/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.storage.windows.internal;

import com.microsoft.alm.helpers.Debug;
import com.microsoft.alm.helpers.LoggingHelper;
import com.microsoft.alm.helpers.StringHelper;
import com.microsoft.alm.helpers.SystemHelper;
import com.microsoft.alm.secret.Secret;
import com.microsoft.alm.storage.SecretStore;
import com.microsoft.alm.storage.windows.internal.CredAdvapi32;
import com.sun.jna.LastErrorException;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CredManagerBackedSecureStore<E extends Secret>
implements SecretStore<E> {
    private static final Logger logger = LoggerFactory.getLogger(CredManagerBackedSecureStore.class);
    private final CredAdvapi32 INSTANCE = CredManagerBackedSecureStore.getCredAdvapi32Instance();

    protected abstract E create(String var1, String var2);

    protected abstract String getUsername(E var1);

    protected abstract String getCredentialBlob(E var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(String key) {
        Object cred;
        Debug.Assert((key != null ? 1 : 0) != 0, (String)"key cannot be null");
        logger.info("Getting secret for {}", (Object)key);
        CredAdvapi32.PCREDENTIAL pcredential = new CredAdvapi32.PCREDENTIAL();
        boolean read = false;
        try {
            CredAdvapi32 credAdvapi32 = this.INSTANCE;
            synchronized (credAdvapi32) {
                read = this.INSTANCE.CredRead(key, 1, 0, pcredential);
            }
            if (read) {
                Object credential = new CredAdvapi32.CREDENTIAL(pcredential.credential);
                byte[] secretBytes = credential.CredentialBlob.getByteArray(0L, credential.CredentialBlobSize);
                String secret = StringHelper.UTF8GetString((byte[])secretBytes);
                String username = credential.UserName;
                cred = this.create(username, secret);
            } else {
                cred = null;
            }
        }
        catch (LastErrorException e) {
            LoggingHelper.logError((Logger)logger, (String)"Getting secret failed.", (Throwable)e);
            cred = null;
        }
        finally {
            if (pcredential.credential != null) {
                CredAdvapi32 credAdvapi32 = this.INSTANCE;
                synchronized (credAdvapi32) {
                    this.INSTANCE.CredFree(pcredential.credential);
                }
            }
        }
        return cred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String key) {
        Debug.Assert((key != null ? 1 : 0) != 0, (String)"key cannot be null");
        logger.info("Deleting secret for {}", (Object)key);
        try {
            CredAdvapi32 credAdvapi32 = this.INSTANCE;
            synchronized (credAdvapi32) {
                return this.INSTANCE.CredDelete(key, 1, 0);
            }
        }
        catch (LastErrorException e) {
            LoggingHelper.logError((Logger)logger, (String)"Deleteing secret failed.", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(String key, E secret) {
        Debug.Assert((key != null ? 1 : 0) != 0, (String)"key cannot be null");
        Debug.Assert((secret != null ? 1 : 0) != 0, (String)"Secret cannot be null");
        logger.info("Adding secret for {}", (Object)key);
        String username = this.getUsername(secret);
        String credentialBlob = this.getCredentialBlob(secret);
        byte[] credBlob = StringHelper.UTF8GetBytes((String)credentialBlob);
        CredAdvapi32.CREDENTIAL cred = this.buildCred(key, username, credBlob);
        try {
            CredAdvapi32 credAdvapi32 = this.INSTANCE;
            synchronized (credAdvapi32) {
                this.INSTANCE.CredWrite(cred, 0);
            }
            boolean bl = true;
            return bl;
        }
        catch (LastErrorException e) {
            LoggingHelper.logError((Logger)logger, (String)"Adding secret failed.", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            cred.CredentialBlob.clear((long)credBlob.length);
            Arrays.fill(credBlob, (byte)0);
        }
    }

    public boolean isSecure() {
        return true;
    }

    private CredAdvapi32.CREDENTIAL buildCred(String key, String username, byte[] credentialBlob) {
        CredAdvapi32.CREDENTIAL credential = new CredAdvapi32.CREDENTIAL();
        credential.Flags = 0;
        credential.Type = 1;
        credential.TargetName = key;
        credential.CredentialBlobSize = credentialBlob.length;
        credential.CredentialBlob = this.getPointer(credentialBlob);
        credential.Persist = 2;
        credential.UserName = username;
        return credential;
    }

    private Pointer getPointer(byte[] array) {
        Memory p = new Memory((long)array.length);
        p.write(0L, array, 0, array.length);
        return p;
    }

    private static CredAdvapi32 getCredAdvapi32Instance() {
        if (SystemHelper.isWindows()) {
            return CredAdvapi32.INSTANCE;
        }
        logger.warn("Returning a dummy library on non Windows platform.  This is a bug unless you are testing.");
        return new CredAdvapi32(){

            @Override
            public boolean CredRead(String targetName, int type, int flags, CredAdvapi32.PCREDENTIAL pcredential) throws LastErrorException {
                return false;
            }

            @Override
            public boolean CredWrite(CredAdvapi32.CREDENTIAL credential, int flags) throws LastErrorException {
                return false;
            }

            @Override
            public boolean CredDelete(String targetName, int type, int flags) throws LastErrorException {
                return false;
            }

            @Override
            public void CredFree(Pointer credential) throws LastErrorException {
            }
        };
    }
}

