/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine.internal;

import io.ktor.server.application.Application;
import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.engine.internal.AutoReloadUtilsKt;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.file.WatchEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u001c\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0000\u001a&\u0010\u0017\u001a\n\u0012\u0004\u0012\u0002H\u0019\u0018\u00010\u0018\"\u0004\b\u0000\u0010\u0019*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00190\u00180\u001aH\u0000\u001a\u0010\u0010\u001b\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\u0018H\u0000\u001a\u001a\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0001*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000bH\u0000\u001a\u0016\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010 *\u0006\u0012\u0002\b\u00030\u0001H\u0000\"\u001a\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0004\" \u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006!"}, d2={"ApplicationClassInstance", "Ljava/lang/Class;", "Lio/ktor/server/application/Application;", "getApplicationClassInstance", "()Ljava/lang/Class;", "ApplicationEnvironmentClassInstance", "Lio/ktor/server/application/ApplicationEnvironment;", "getApplicationEnvironmentClassInstance", "currentStartupModules", "Ljava/lang/ThreadLocal;", "", "", "getCurrentStartupModules", "()Ljava/lang/ThreadLocal;", "get_com_sun_nio_file_SensitivityWatchEventModifier_HIGH", "Ljava/nio/file/WatchEvent$Modifier;", "isApplication", "", "parameter", "Lkotlin/reflect/KParameter;", "isApplicationEnvironment", "isParameterOfType", "type", "bestFunction", "Lkotlin/reflect/KFunction;", "R", "", "isApplicableFunction", "loadClassOrNull", "Ljava/lang/ClassLoader;", "name", "takeIfNotFacade", "Lkotlin/reflect/KClass;", "ktor-server-host-common"})
public final class AutoReloadUtilsKt {
    @NotNull
    private static final ThreadLocal<List<String>> currentStartupModules = new ThreadLocal();
    @NotNull
    private static final Class<ApplicationEnvironment> ApplicationEnvironmentClassInstance = ApplicationEnvironment.class;
    @NotNull
    private static final Class<Application> ApplicationClassInstance = Application.class;

    @NotNull
    public static final ThreadLocal<List<String>> getCurrentStartupModules() {
        return currentStartupModules;
    }

    @NotNull
    public static final Class<ApplicationEnvironment> getApplicationEnvironmentClassInstance() {
        return ApplicationEnvironmentClassInstance;
    }

    @NotNull
    public static final Class<Application> getApplicationClassInstance() {
        return ApplicationClassInstance;
    }

    public static final boolean isApplicationEnvironment(@NotNull KParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return AutoReloadUtilsKt.isParameterOfType(parameter, ApplicationEnvironmentClassInstance);
    }

    public static final boolean isApplication(@NotNull KParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        return AutoReloadUtilsKt.isParameterOfType(parameter, ApplicationClassInstance);
    }

    @Nullable
    public static final Class<?> loadClassOrNull(@NotNull ClassLoader $this$loadClassOrNull, @NotNull String name) {
        Class clazz;
        Intrinsics.checkNotNullParameter((Object)$this$loadClassOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            clazz = $this$loadClassOrNull.loadClass(name);
        }
        catch (ClassNotFoundException cause) {
            clazz = null;
        }
        return clazz;
    }

    public static final boolean isParameterOfType(@NotNull KParameter parameter, @NotNull Class<?> type) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Type type2 = ReflectJvmMapping.getJavaType((KType)parameter.getType());
        Class clazz = type2 instanceof Class ? (Class)type2 : null;
        if (clazz != null) {
            Class it = clazz;
            boolean bl2 = false;
            bl = type.isAssignableFrom(it);
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final <R> KFunction<R> bestFunction(@NotNull List<? extends KFunction<? extends R>> $this$bestFunction) {
        Intrinsics.checkNotNullParameter($this$bestFunction, (String)"<this>");
        Function1[] function1Array = new Function1[]{bestFunction.1.INSTANCE, bestFunction.2.INSTANCE, bestFunction.3.INSTANCE};
        return (KFunction)CollectionsKt.lastOrNull((List)CollectionsKt.sortedWith((Iterable)$this$bestFunction, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array)));
    }

    public static final boolean isApplicableFunction(@NotNull KFunction<?> $this$isApplicableFunction) {
        boolean bl;
        block10: {
            Object it;
            Intrinsics.checkNotNullParameter($this$isApplicableFunction, (String)"<this>");
            if ($this$isApplicableFunction.isOperator() || $this$isApplicableFunction.isInfix() || $this$isApplicableFunction.isInline() || $this$isApplicableFunction.isAbstract()) {
                return false;
            }
            if ($this$isApplicableFunction.isSuspend()) {
                return false;
            }
            KParameter kParameter = KCallables.getExtensionReceiverParameter((KCallable)((KCallable)$this$isApplicableFunction));
            if (kParameter != null) {
                it = kParameter;
                boolean bl2 = false;
                if (!AutoReloadUtilsKt.isApplication((KParameter)it) && !AutoReloadUtilsKt.isApplicationEnvironment((KParameter)it)) {
                    return false;
                }
            }
            Method method = ReflectJvmMapping.getJavaMethod($this$isApplicableFunction);
            if (method != null) {
                it = method;
                boolean bl3 = false;
                if (((Method)it).isSynthetic()) {
                    return false;
                }
                if (Modifier.isStatic(((Method)it).getModifiers()) && $this$isApplicableFunction.getParameters().isEmpty()) {
                    return false;
                }
            }
            Iterable $this$all$iv = $this$isApplicableFunction.getParameters();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KParameter it2 = (KParameter)element$iv;
                    boolean bl4 = false;
                    if (AutoReloadUtilsKt.isApplication(it2) || AutoReloadUtilsKt.isApplicationEnvironment(it2) || it2.getKind() == KParameter.Kind.INSTANCE || it2.isOptional()) continue;
                    bl = false;
                    break block10;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Nullable
    public static final KClass<?> takeIfNotFacade(@NotNull Class<?> $this$takeIfNotFacade) {
        Object object;
        Intrinsics.checkNotNullParameter($this$takeIfNotFacade, (String)"<this>");
        Metadata metadata = $this$takeIfNotFacade.getAnnotation(Metadata.class);
        if (metadata != null) {
            Metadata metadata2;
            Metadata it = metadata2 = metadata;
            boolean bl = false;
            object = it.k() == 1 ? metadata2 : null;
        } else {
            object = null;
        }
        return object != null ? JvmClassMappingKt.getKotlinClass($this$takeIfNotFacade) : null;
    }

    @Nullable
    public static final WatchEvent.Modifier get_com_sun_nio_file_SensitivityWatchEventModifier_HIGH() {
        WatchEvent.Modifier modifier;
        if (System.getenv("ANDROID_DATA") != null) {
            return null;
        }
        try {
            Class<?> modifierClass = Class.forName("com.sun.nio.file.SensitivityWatchEventModifier");
            Field field = modifierClass.getField("HIGH");
            Object object = field.get(modifierClass);
            modifier = object instanceof WatchEvent.Modifier ? (WatchEvent.Modifier)object : null;
        }
        catch (Throwable cause) {
            modifier = null;
        }
        return modifier;
    }
}

