/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.hoplite.env;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\f\u001a\u00020\rH\u00d6\u0001J\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lcom/sksamuel/hoplite/env/Environment;", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "hoplite-core"})
public final class Environment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private static final Environment prod = new Environment("prod");
    @NotNull
    private static final Environment production = new Environment("production");
    @NotNull
    private static final Environment dev = new Environment("dev");
    @NotNull
    private static final Environment development = new Environment("development");
    @NotNull
    private static final Environment qa = new Environment("qa");
    @NotNull
    private static final Environment staging = new Environment("staging");
    @NotNull
    private static final Environment local = new Environment("local");
    @NotNull
    private static final Environment live = new Environment("live");
    @NotNull
    private static final Environment test = new Environment("test");

    public Environment(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final Environment copy(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new Environment(name);
    }

    public static /* synthetic */ Environment copy$default(Environment environment, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = environment.name;
        }
        return environment.copy(string);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Environment)) {
            return false;
        }
        Environment environment = (Environment)other;
        return Intrinsics.areEqual((Object)this.name, (Object)environment.name);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/sksamuel/hoplite/env/Environment$Companion;", "", "()V", "dev", "Lcom/sksamuel/hoplite/env/Environment;", "getDev", "()Lcom/sksamuel/hoplite/env/Environment;", "development", "getDevelopment", "live", "getLive", "local", "getLocal", "prod", "getProd", "production", "getProduction", "qa", "getQa", "staging", "getStaging", "test", "getTest", "fromEnvVar", "envVarName", "", "fallback", "hoplite-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Environment getProd() {
            return prod;
        }

        @NotNull
        public final Environment getProduction() {
            return production;
        }

        @NotNull
        public final Environment getDev() {
            return dev;
        }

        @NotNull
        public final Environment getDevelopment() {
            return development;
        }

        @NotNull
        public final Environment getQa() {
            return qa;
        }

        @NotNull
        public final Environment getStaging() {
            return staging;
        }

        @NotNull
        public final Environment getLocal() {
            return local;
        }

        @NotNull
        public final Environment getLive() {
            return live;
        }

        @NotNull
        public final Environment getTest() {
            return test;
        }

        @NotNull
        public final Environment fromEnvVar(@NotNull String envVarName) {
            Intrinsics.checkNotNullParameter((Object)envVarName, (String)"envVarName");
            String env = System.getenv(envVarName);
            CharSequence charSequence = env;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                throw new IllegalStateException(("Environment variable " + envVarName + " must be specified").toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)env, (String)"env");
            return new Environment(env);
        }

        @NotNull
        public final Environment fromEnvVar(@NotNull String envVarName, @NotNull Environment fallback) {
            Environment environment;
            Intrinsics.checkNotNullParameter((Object)envVarName, (String)"envVarName");
            Intrinsics.checkNotNullParameter((Object)fallback, (String)"fallback");
            String env = System.getenv(envVarName);
            CharSequence charSequence = env;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                environment = fallback;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)env, (String)"env");
                environment = new Environment(env);
            }
            return environment;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

