/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.hoplite.secrets;

import com.sksamuel.hoplite.BooleanNode;
import com.sksamuel.hoplite.DoubleNode;
import com.sksamuel.hoplite.LongNode;
import com.sksamuel.hoplite.NullNode;
import com.sksamuel.hoplite.PrimitiveNode;
import com.sksamuel.hoplite.StringNode;
import com.sksamuel.hoplite.secrets.HashObfuscator;
import com.sksamuel.hoplite.secrets.Obfuscator;
import com.sksamuel.hoplite.secrets.ObfuscatorKt;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/sksamuel/hoplite/secrets/HashObfuscator;", "Lcom/sksamuel/hoplite/secrets/Obfuscator;", "hashCharsToShow", "", "(I)V", "obfuscate", "", "node", "Lcom/sksamuel/hoplite/PrimitiveNode;", "hoplite-core"})
public final class HashObfuscator
implements Obfuscator {
    private final int hashCharsToShow;

    public HashObfuscator(int hashCharsToShow) {
        this.hashCharsToShow = hashCharsToShow;
    }

    public /* synthetic */ HashObfuscator(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 8;
        }
        this(n);
    }

    @Override
    @NotNull
    public String obfuscate(@NotNull PrimitiveNode node2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        PrimitiveNode primitiveNode = node2;
        if (primitiveNode instanceof BooleanNode) {
            string = String.valueOf(((BooleanNode)node2).getValue());
        } else if (primitiveNode instanceof NullNode) {
            string = String.valueOf(node2.getValue());
        } else if (primitiveNode instanceof DoubleNode) {
            string = String.valueOf(((DoubleNode)node2).getValue());
        } else if (primitiveNode instanceof LongNode) {
            string = String.valueOf(((LongNode)node2).getValue());
        } else {
            if (primitiveNode instanceof StringNode) {
                if (ObfuscatorKt.access$isNumericOrBoolean(((StringNode)node2).getValue())) {
                    return ((StringNode)node2).getValue();
                }
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                byte[] byArray = digest.digest(StringsKt.encodeToByteArray((String)((StringNode)node2).getValue()));
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest\n          .digest\u2026alue.encodeToByteArray())");
                return CollectionsKt.joinToString$default((Iterable)ArraysKt.take((byte[])byArray, (int)this.hashCharsToShow), (CharSequence)"", (CharSequence)"hash(", (CharSequence)"...)", (int)0, null, (Function1)obfuscate.1.INSTANCE, (int)24, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        return string;
    }

    public HashObfuscator() {
        this(0, 1, null);
    }
}

