/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.BaggageHeader;
import io.sentry.Breadcrumb;
import io.sentry.CheckIn;
import io.sentry.Dsn;
import io.sentry.ExternalOptions;
import io.sentry.Hint;
import io.sentry.Hub;
import io.sentry.HubAdapter;
import io.sentry.IHub;
import io.sentry.ILogger;
import io.sentry.IOptionsObserver;
import io.sentry.ISentryClient;
import io.sentry.ISentryExecutorService;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.Integration;
import io.sentry.JavaMemoryCollector;
import io.sentry.NoOpHub;
import io.sentry.NoOpLogger;
import io.sentry.OptionsContainer;
import io.sentry.PreviousSessionFinalizer;
import io.sentry.SamplingContext;
import io.sentry.ScopeCallback;
import io.sentry.SentryAppStartProfilingOptions;
import io.sentry.SentryEvent;
import io.sentry.SentryExecutorService;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SentryTraceHeader;
import io.sentry.SystemOutLogger;
import io.sentry.TracesSampler;
import io.sentry.TracesSamplingDecision;
import io.sentry.TransactionContext;
import io.sentry.TransactionOptions;
import io.sentry.UserFeedback;
import io.sentry.backpressure.BackpressureMonitor;
import io.sentry.cache.EnvelopeCache;
import io.sentry.cache.IEnvelopeCache;
import io.sentry.config.PropertiesProviderFactory;
import io.sentry.internal.debugmeta.NoOpDebugMetaLoader;
import io.sentry.internal.debugmeta.ResourcesDebugMetaLoader;
import io.sentry.internal.modules.CompositeModulesLoader;
import io.sentry.internal.modules.IModulesLoader;
import io.sentry.internal.modules.ManifestModulesLoader;
import io.sentry.internal.modules.NoOpModulesLoader;
import io.sentry.internal.modules.ResourcesModulesLoader;
import io.sentry.metrics.MetricsApi;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.User;
import io.sentry.transport.NoOpEnvelopeCache;
import io.sentry.util.DebugMetaPropertiesApplier;
import io.sentry.util.FileUtils;
import io.sentry.util.Platform;
import io.sentry.util.thread.IMainThreadChecker;
import io.sentry.util.thread.MainThreadChecker;
import io.sentry.util.thread.NoOpMainThreadChecker;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Sentry {
    @NotNull
    private static final ThreadLocal<IHub> currentHub = new ThreadLocal();
    @NotNull
    private static volatile IHub mainHub = NoOpHub.getInstance();
    private static final boolean GLOBAL_HUB_DEFAULT_MODE = false;
    private static volatile boolean globalHubMode = false;
    @ApiStatus.Internal
    @NotNull
    public static final String APP_START_PROFILING_CONFIG_FILE_NAME = "app_start_profiling_config";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final long classCreationTimestamp = System.currentTimeMillis();

    private Sentry() {
    }

    @ApiStatus.Internal
    @NotNull
    public static IHub getCurrentHub() {
        if (globalHubMode) {
            return mainHub;
        }
        IHub hub = currentHub.get();
        if (hub == null || hub instanceof NoOpHub) {
            hub = mainHub.clone();
            currentHub.set(hub);
        }
        return hub;
    }

    @ApiStatus.Internal
    @ApiStatus.Experimental
    @NotNull
    public static IHub cloneMainHub() {
        if (globalHubMode) {
            return mainHub;
        }
        return mainHub.clone();
    }

    @ApiStatus.Internal
    public static void setCurrentHub(@NotNull IHub hub) {
        currentHub.set(hub);
    }

    public static boolean isEnabled() {
        return Sentry.getCurrentHub().isEnabled();
    }

    public static void init() {
        Sentry.init((SentryOptions options) -> options.setEnableExternalConfiguration(true), false);
    }

    public static void init(@NotNull String dsn) {
        Sentry.init((SentryOptions options) -> options.setDsn(dsn));
    }

    public static <T extends SentryOptions> void init(@NotNull OptionsContainer<T> clazz, @NotNull OptionsConfiguration<T> optionsConfiguration) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Sentry.init(clazz, optionsConfiguration, false);
    }

    public static <T extends SentryOptions> void init(@NotNull OptionsContainer<T> clazz, @NotNull OptionsConfiguration<T> optionsConfiguration, boolean globalHubMode) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        SentryOptions options = (SentryOptions)clazz.createInstance();
        Sentry.applyOptionsConfiguration(optionsConfiguration, options);
        Sentry.init(options, globalHubMode);
    }

    public static void init(@NotNull OptionsConfiguration<SentryOptions> optionsConfiguration) {
        Sentry.init(optionsConfiguration, false);
    }

    public static void init(@NotNull OptionsConfiguration<SentryOptions> optionsConfiguration, boolean globalHubMode) {
        SentryOptions options = new SentryOptions();
        Sentry.applyOptionsConfiguration(optionsConfiguration, options);
        Sentry.init(options, globalHubMode);
    }

    private static <T extends SentryOptions> void applyOptionsConfiguration(OptionsConfiguration<T> optionsConfiguration, T options) {
        try {
            optionsConfiguration.configure(options);
        }
        catch (Throwable t) {
            options.getLogger().log(SentryLevel.ERROR, "Error in the 'OptionsConfiguration.configure' callback.", t);
        }
    }

    @ApiStatus.Internal
    public static void init(@NotNull SentryOptions options) {
        Sentry.init(options, false);
    }

    private static synchronized void init(@NotNull SentryOptions options, boolean globalHubMode) {
        if (Sentry.isEnabled()) {
            options.getLogger().log(SentryLevel.WARNING, "Sentry has been already initialized. Previous configuration will be overwritten.", new Object[0]);
        }
        if (!Sentry.initConfigurations(options)) {
            return;
        }
        options.getLogger().log(SentryLevel.INFO, "GlobalHubMode: '%s'", String.valueOf(globalHubMode));
        Sentry.globalHubMode = globalHubMode;
        IHub hub = Sentry.getCurrentHub();
        mainHub = new Hub(options);
        currentHub.set(mainHub);
        hub.close(true);
        if (options.getExecutorService().isClosed()) {
            options.setExecutorService(new SentryExecutorService());
        }
        for (Integration integration : options.getIntegrations()) {
            integration.register(HubAdapter.getInstance(), options);
        }
        Sentry.notifyOptionsObservers(options);
        Sentry.finalizePreviousSession(options, HubAdapter.getInstance());
        Sentry.handleAppStartProfilingConfig(options, options.getExecutorService());
    }

    private static void handleAppStartProfilingConfig(@NotNull SentryOptions options, @NotNull ISentryExecutorService sentryExecutorService) {
        try {
            sentryExecutorService.submit(() -> {
                block15: {
                    String cacheDirPath = options.getCacheDirPathWithoutDsn();
                    if (cacheDirPath != null) {
                        @NotNull File appStartProfilingConfigFile = new File(cacheDirPath, APP_START_PROFILING_CONFIG_FILE_NAME);
                        try {
                            FileUtils.deleteRecursively(appStartProfilingConfigFile);
                            if (!options.isEnableAppStartProfiling()) {
                                return;
                            }
                            if (!options.isTracingEnabled()) {
                                options.getLogger().log(SentryLevel.INFO, "Tracing is disabled and app start profiling will not start.", new Object[0]);
                                return;
                            }
                            if (!appStartProfilingConfigFile.createNewFile()) break block15;
                            @NotNull TracesSamplingDecision appStartSamplingDecision = Sentry.sampleAppStartProfiling(options);
                            @NotNull SentryAppStartProfilingOptions appStartProfilingOptions = new SentryAppStartProfilingOptions(options, appStartSamplingDecision);
                            try (FileOutputStream outputStream = new FileOutputStream(appStartProfilingConfigFile);
                                 BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, UTF_8));){
                                options.getSerializer().serialize(appStartProfilingOptions, writer);
                            }
                        }
                        catch (Throwable e) {
                            options.getLogger().log(SentryLevel.ERROR, "Unable to create app start profiling config file. ", e);
                        }
                    }
                }
            });
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.ERROR, "Failed to call the executor. App start profiling config will not be changed. Did you call Sentry.close()?", e);
        }
    }

    @NotNull
    private static TracesSamplingDecision sampleAppStartProfiling(@NotNull SentryOptions options) {
        TransactionContext appStartTransactionContext = new TransactionContext("app.launch", "profile");
        appStartTransactionContext.setForNextAppStart(true);
        SamplingContext appStartSamplingContext = new SamplingContext(appStartTransactionContext, null);
        return new TracesSampler(options).sample(appStartSamplingContext);
    }

    private static void finalizePreviousSession(@NotNull SentryOptions options, @NotNull IHub hub) {
        try {
            options.getExecutorService().submit(new PreviousSessionFinalizer(options, hub));
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.DEBUG, "Failed to finalize previous session.", e);
        }
    }

    private static void notifyOptionsObservers(@NotNull SentryOptions options) {
        try {
            options.getExecutorService().submit(() -> {
                for (IOptionsObserver observer : options.getOptionsObservers()) {
                    observer.setRelease(options.getRelease());
                    observer.setProguardUuid(options.getProguardUuid());
                    observer.setSdkVersion(options.getSdkVersion());
                    observer.setDist(options.getDist());
                    observer.setEnvironment(options.getEnvironment());
                    observer.setTags(options.getTags());
                }
            });
        }
        catch (Throwable e) {
            options.getLogger().log(SentryLevel.DEBUG, "Failed to notify options observers.", e);
        }
    }

    private static boolean initConfigurations(@NotNull SentryOptions options) {
        if (options.isEnableExternalConfiguration()) {
            options.merge(ExternalOptions.from(PropertiesProviderFactory.create(), options.getLogger()));
        }
        String dsn = options.getDsn();
        if (!options.isEnabled() || dsn != null && dsn.isEmpty()) {
            Sentry.close();
            return false;
        }
        if (dsn == null) {
            throw new IllegalArgumentException("DSN is required. Use empty string or set enabled to false in SentryOptions to disable SDK.");
        }
        Dsn parsedDsn = new Dsn(dsn);
        ILogger logger = options.getLogger();
        if (options.isDebug() && logger instanceof NoOpLogger) {
            options.setLogger(new SystemOutLogger());
            logger = options.getLogger();
        }
        logger.log(SentryLevel.INFO, "Initializing SDK with DSN: '%s'", options.getDsn());
        String outboxPath = options.getOutboxPath();
        if (outboxPath != null) {
            File outboxDir = new File(outboxPath);
            outboxDir.mkdirs();
        } else {
            logger.log(SentryLevel.INFO, "No outbox dir path is defined in options.", new Object[0]);
        }
        String cacheDirPath = options.getCacheDirPath();
        if (cacheDirPath != null) {
            File cacheDir = new File(cacheDirPath);
            cacheDir.mkdirs();
            IEnvelopeCache envelopeCache = options.getEnvelopeDiskCache();
            if (envelopeCache instanceof NoOpEnvelopeCache) {
                options.setEnvelopeDiskCache(EnvelopeCache.create(options));
            }
        }
        String profilingTracesDirPath = options.getProfilingTracesDirPath();
        if (options.isProfilingEnabled() && profilingTracesDirPath != null) {
            File profilingTracesDir = new File(profilingTracesDirPath);
            profilingTracesDir.mkdirs();
            try {
                options.getExecutorService().submit(() -> {
                    File[] oldTracesDirContent = profilingTracesDir.listFiles();
                    if (oldTracesDirContent == null) {
                        return;
                    }
                    for (File f : oldTracesDirContent) {
                        if (f.lastModified() >= classCreationTimestamp - TimeUnit.MINUTES.toMillis(5L)) continue;
                        FileUtils.deleteRecursively(f);
                    }
                });
            }
            catch (RejectedExecutionException e) {
                options.getLogger().log(SentryLevel.ERROR, "Failed to call the executor. Old profiles will not be deleted. Did you call Sentry.close()?", e);
            }
        }
        @NotNull IModulesLoader modulesLoader = options.getModulesLoader();
        if (!options.isSendModules()) {
            options.setModulesLoader(NoOpModulesLoader.getInstance());
        } else if (modulesLoader instanceof NoOpModulesLoader) {
            options.setModulesLoader(new CompositeModulesLoader(Arrays.asList(new ManifestModulesLoader(options.getLogger()), new ResourcesModulesLoader(options.getLogger())), options.getLogger()));
        }
        if (options.getDebugMetaLoader() instanceof NoOpDebugMetaLoader) {
            options.setDebugMetaLoader(new ResourcesDebugMetaLoader(options.getLogger()));
        }
        @Nullable List<Properties> propertiesList = options.getDebugMetaLoader().loadDebugMeta();
        DebugMetaPropertiesApplier.applyToOptions(options, propertiesList);
        IMainThreadChecker mainThreadChecker = options.getMainThreadChecker();
        if (mainThreadChecker instanceof NoOpMainThreadChecker) {
            options.setMainThreadChecker(MainThreadChecker.getInstance());
        }
        if (options.getPerformanceCollectors().isEmpty()) {
            options.addPerformanceCollector(new JavaMemoryCollector());
        }
        if (options.isEnableBackpressureHandling()) {
            options.setBackpressureMonitor(new BackpressureMonitor(options, HubAdapter.getInstance()));
            options.getBackpressureMonitor().start();
        }
        return true;
    }

    public static synchronized void close() {
        IHub hub = Sentry.getCurrentHub();
        mainHub = NoOpHub.getInstance();
        currentHub.remove();
        hub.close(false);
    }

    @NotNull
    public static SentryId captureEvent(@NotNull SentryEvent event) {
        return Sentry.getCurrentHub().captureEvent(event);
    }

    @NotNull
    public static SentryId captureEvent(@NotNull SentryEvent event, @NotNull ScopeCallback callback) {
        return Sentry.getCurrentHub().captureEvent(event, callback);
    }

    @NotNull
    public static SentryId captureEvent(@NotNull SentryEvent event, @Nullable Hint hint) {
        return Sentry.getCurrentHub().captureEvent(event, hint);
    }

    @NotNull
    public static SentryId captureEvent(@NotNull SentryEvent event, @Nullable Hint hint, @NotNull ScopeCallback callback) {
        return Sentry.getCurrentHub().captureEvent(event, hint, callback);
    }

    @NotNull
    public static SentryId captureMessage(@NotNull String message) {
        return Sentry.getCurrentHub().captureMessage(message);
    }

    @NotNull
    public static SentryId captureMessage(@NotNull String message, @NotNull ScopeCallback callback) {
        return Sentry.getCurrentHub().captureMessage(message, callback);
    }

    @NotNull
    public static SentryId captureMessage(@NotNull String message, @NotNull SentryLevel level) {
        return Sentry.getCurrentHub().captureMessage(message, level);
    }

    @NotNull
    public static SentryId captureMessage(@NotNull String message, @NotNull SentryLevel level, @NotNull ScopeCallback callback) {
        return Sentry.getCurrentHub().captureMessage(message, level, callback);
    }

    @NotNull
    public static SentryId captureException(@NotNull Throwable throwable) {
        return Sentry.getCurrentHub().captureException(throwable);
    }

    @NotNull
    public static SentryId captureException(@NotNull Throwable throwable, @NotNull ScopeCallback callback) {
        return Sentry.getCurrentHub().captureException(throwable, callback);
    }

    @NotNull
    public static SentryId captureException(@NotNull Throwable throwable, @Nullable Hint hint) {
        return Sentry.getCurrentHub().captureException(throwable, hint);
    }

    @NotNull
    public static SentryId captureException(@NotNull Throwable throwable, @Nullable Hint hint, @NotNull ScopeCallback callback) {
        return Sentry.getCurrentHub().captureException(throwable, hint, callback);
    }

    public static void captureUserFeedback(@NotNull UserFeedback userFeedback) {
        Sentry.getCurrentHub().captureUserFeedback(userFeedback);
    }

    public static void addBreadcrumb(@NotNull Breadcrumb breadcrumb, @Nullable Hint hint) {
        Sentry.getCurrentHub().addBreadcrumb(breadcrumb, hint);
    }

    public static void addBreadcrumb(@NotNull Breadcrumb breadcrumb) {
        Sentry.getCurrentHub().addBreadcrumb(breadcrumb);
    }

    public static void addBreadcrumb(@NotNull String message) {
        Sentry.getCurrentHub().addBreadcrumb(message);
    }

    public static void addBreadcrumb(@NotNull String message, @NotNull String category) {
        Sentry.getCurrentHub().addBreadcrumb(message, category);
    }

    public static void setLevel(@Nullable SentryLevel level) {
        Sentry.getCurrentHub().setLevel(level);
    }

    public static void setTransaction(@Nullable String transaction) {
        Sentry.getCurrentHub().setTransaction(transaction);
    }

    public static void setUser(@Nullable User user) {
        Sentry.getCurrentHub().setUser(user);
    }

    public static void setFingerprint(@NotNull List<String> fingerprint) {
        Sentry.getCurrentHub().setFingerprint(fingerprint);
    }

    public static void clearBreadcrumbs() {
        Sentry.getCurrentHub().clearBreadcrumbs();
    }

    public static void setTag(@NotNull String key, @NotNull String value) {
        Sentry.getCurrentHub().setTag(key, value);
    }

    public static void removeTag(@NotNull String key) {
        Sentry.getCurrentHub().removeTag(key);
    }

    public static void setExtra(@NotNull String key, @NotNull String value) {
        Sentry.getCurrentHub().setExtra(key, value);
    }

    public static void removeExtra(@NotNull String key) {
        Sentry.getCurrentHub().removeExtra(key);
    }

    @NotNull
    public static SentryId getLastEventId() {
        return Sentry.getCurrentHub().getLastEventId();
    }

    public static void pushScope() {
        if (!globalHubMode) {
            Sentry.getCurrentHub().pushScope();
        }
    }

    public static void popScope() {
        if (!globalHubMode) {
            Sentry.getCurrentHub().popScope();
        }
    }

    public static void withScope(@NotNull ScopeCallback callback) {
        Sentry.getCurrentHub().withScope(callback);
    }

    public static void configureScope(@NotNull ScopeCallback callback) {
        Sentry.getCurrentHub().configureScope(callback);
    }

    public static void bindClient(@NotNull ISentryClient client) {
        Sentry.getCurrentHub().bindClient(client);
    }

    public static boolean isHealthy() {
        return Sentry.getCurrentHub().isHealthy();
    }

    public static void flush(long timeoutMillis) {
        Sentry.getCurrentHub().flush(timeoutMillis);
    }

    public static void startSession() {
        Sentry.getCurrentHub().startSession();
    }

    public static void endSession() {
        Sentry.getCurrentHub().endSession();
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull String name, @NotNull String operation) {
        return Sentry.getCurrentHub().startTransaction(name, operation);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull String name, @NotNull String operation, @NotNull TransactionOptions transactionOptions) {
        return Sentry.getCurrentHub().startTransaction(name, operation, transactionOptions);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull String name, @NotNull String operation, @Nullable String description, @NotNull TransactionOptions transactionOptions) {
        ITransaction transaction = Sentry.getCurrentHub().startTransaction(name, operation, transactionOptions);
        transaction.setDescription(description);
        return transaction;
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull TransactionContext transactionContexts) {
        return Sentry.getCurrentHub().startTransaction(transactionContexts);
    }

    @NotNull
    public static ITransaction startTransaction(@NotNull TransactionContext transactionContext, @NotNull TransactionOptions transactionOptions) {
        return Sentry.getCurrentHub().startTransaction(transactionContext, transactionOptions);
    }

    @Deprecated
    @Nullable
    public static SentryTraceHeader traceHeaders() {
        return Sentry.getCurrentHub().traceHeaders();
    }

    @Nullable
    public static ISpan getSpan() {
        if (globalHubMode && Platform.isAndroid()) {
            return Sentry.getCurrentHub().getTransaction();
        }
        return Sentry.getCurrentHub().getSpan();
    }

    @Nullable
    public static Boolean isCrashedLastRun() {
        return Sentry.getCurrentHub().isCrashedLastRun();
    }

    public static void reportFullyDisplayed() {
        Sentry.getCurrentHub().reportFullyDisplayed();
    }

    @Deprecated
    public static void reportFullDisplayed() {
        Sentry.reportFullyDisplayed();
    }

    @NotNull
    @ApiStatus.Experimental
    public static MetricsApi metrics() {
        return Sentry.getCurrentHub().metrics();
    }

    @Nullable
    public static TransactionContext continueTrace(@Nullable String sentryTrace, @Nullable List<String> baggageHeaders) {
        return Sentry.getCurrentHub().continueTrace(sentryTrace, baggageHeaders);
    }

    @Nullable
    public static SentryTraceHeader getTraceparent() {
        return Sentry.getCurrentHub().getTraceparent();
    }

    @Nullable
    public static BaggageHeader getBaggage() {
        return Sentry.getCurrentHub().getBaggage();
    }

    @ApiStatus.Experimental
    @NotNull
    public static SentryId captureCheckIn(@NotNull CheckIn checkIn) {
        return Sentry.getCurrentHub().captureCheckIn(checkIn);
    }

    public static interface OptionsConfiguration<T extends SentryOptions> {
        public void configure(@NotNull T var1);
    }
}

