/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.config.remote;

import java.lang.invoke.LambdaMetafactory;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.config.remote.RemoteConfig;
import org.merlyn.desktopapp.config.remote.RemoteConfigFlags;
import org.merlyn.desktopapp.service.FeatureFlagsService;
import org.merlyn.desktopapp.storage.EncryptedFeatureFlags;
import org.merlyn.desktopapp.storage.EncryptedFeatureFlagsDao;
import org.merlyn.desktopapp.storage.encypt.SimpleEncryption;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0014\u001a\u00020\u0015H\u0086@\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0017\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0002J\b\u0010\u001a\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/merlyn/desktopapp/config/remote/RemoteConfig;", "", "featureFlagsService", "Lorg/merlyn/desktopapp/service/FeatureFlagsService;", "encryptedFeatureFlagsDao", "Lorg/merlyn/desktopapp/storage/EncryptedFeatureFlagsDao;", "<init>", "(Lorg/merlyn/desktopapp/service/FeatureFlagsService;Lorg/merlyn/desktopapp/storage/EncryptedFeatureFlagsDao;)V", "logger", "Lmu/KLogger;", "lastFetchedConfig", "Lorg/merlyn/desktopapp/config/remote/RemoteConfigFlags;", "_fetchedConfig", "Lkotlinx/coroutines/flow/MutableStateFlow;", "fetchedConfig", "Lkotlinx/coroutines/flow/StateFlow;", "getFetchedConfig", "()Lkotlinx/coroutines/flow/StateFlow;", "simpleEncryption", "Lorg/merlyn/desktopapp/storage/encypt/SimpleEncryption;", "fetch", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateConfig", "config", "serializeToDisk", "get", "app"})
@SourceDebugExtension(value={"SMAP\nRemoteConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteConfig.kt\norg/merlyn/desktopapp/config/remote/RemoteConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,85:1\n1#2:86\n230#3,5:87\n*S KotlinDebug\n*F\n+ 1 RemoteConfig.kt\norg/merlyn/desktopapp/config/remote/RemoteConfig\n*L\n61#1:87,5\n*E\n"})
public final class RemoteConfig {
    @NotNull
    private final FeatureFlagsService featureFlagsService;
    @NotNull
    private final EncryptedFeatureFlagsDao encryptedFeatureFlagsDao;
    @NotNull
    private final KLogger logger;
    @Nullable
    private RemoteConfigFlags lastFetchedConfig;
    @NotNull
    private final MutableStateFlow<RemoteConfigFlags> _fetchedConfig;
    @NotNull
    private final StateFlow<RemoteConfigFlags> fetchedConfig;
    @NotNull
    private final SimpleEncryption simpleEncryption;

    /*
     * WARNING - void declaration
     */
    public RemoteConfig(@NotNull FeatureFlagsService featureFlagsService, @NotNull EncryptedFeatureFlagsDao encryptedFeatureFlagsDao) {
        Intrinsics.checkNotNullParameter((Object)featureFlagsService, (String)"featureFlagsService");
        Intrinsics.checkNotNullParameter((Object)encryptedFeatureFlagsDao, (String)"encryptedFeatureFlagsDao");
        this.featureFlagsService = featureFlagsService;
        this.encryptedFeatureFlagsDao = encryptedFeatureFlagsDao;
        this.logger = KotlinLogging.INSTANCE.logger(RemoteConfig::logger$lambda$0);
        this._fetchedConfig = StateFlowKt.MutableStateFlow(null);
        this.fetchedConfig = FlowKt.asStateFlow(this._fetchedConfig);
        EncryptedFeatureFlags encryptedFeatureFlags = this.encryptedFeatureFlagsDao.get();
        if (encryptedFeatureFlags != null) {
            Object object;
            Object $this$_init__u24lambda_u241;
            Object object2 = this;
            RemoteConfig remoteConfig = this;
            try {
                $this$_init__u24lambda_u241 = object2;
                boolean bl = false;
                SimpleEncryption simpleEncryption = new SimpleEncryption(encryptedFeatureFlags.getSerializedSecretKey());
                String serializedFeatureFlags = simpleEncryption.decrypt(encryptedFeatureFlags.getEncryptedFeatureFlags());
                super.updateConfig(((RemoteConfig)$this$_init__u24lambda_u241).featureFlagsService.deserialize(serializedFeatureFlags));
                $this$_init__u24lambda_u241 = Result.constructor-impl((Object)simpleEncryption);
            }
            catch (Throwable bl) {
                $this$_init__u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            RemoteConfig remoteConfig2 = remoteConfig;
            object2 = $this$_init__u24lambda_u241;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) {
                object = object2;
            } else {
                void it;
                $this$_init__u24lambda_u241 = throwable;
                remoteConfig = remoteConfig2;
                boolean bl = false;
                this.logger.error((Throwable)it, RemoteConfig::lambda$3$lambda$2);
                object = new SimpleEncryption(null);
                remoteConfig2 = remoteConfig;
            }
            remoteConfig2.simpleEncryption = (SimpleEncryption)object;
        } else {
            this.simpleEncryption = new SimpleEncryption(null);
        }
    }

    @NotNull
    public final StateFlow<RemoteConfigFlags> getFetchedConfig() {
        return this.fetchedConfig;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object fetch(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof fetch.1)) ** GOTO lbl-1000
        var7_2 = $completion;
        if ((var7_2.label & -2147483648) != 0) {
            var7_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ RemoteConfig this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.fetch((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.logger.info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, fetch$lambda$4(), ()Ljava/lang/Object;)());
                var2_5 = this;
                $this$fetch_u24lambda_u245 = var2_5;
                $i$a$-runCatching-RemoteConfig$fetch$3 = false;
                var5_10 = $this$fetch_u24lambda_u245;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$fetch_u24lambda_u245;
                $continuation.L$2 = var5_10;
                $continuation.label = 1;
                v0 = $this$fetch_u24lambda_u245.featureFlagsService.fetch((Continuation<? super RemoteConfigFlags>)$continuation);
                ** if (v0 != var8_4) goto lbl27
lbl26:
                // 1 sources

                return var8_4;
lbl27:
                // 1 sources

                ** GOTO lbl37
            }
            case 1: {
                $i$a$-runCatching-RemoteConfig$fetch$3 = false;
                var5_10 = (RemoteConfig)$continuation.L$2;
                $this$fetch_u24lambda_u245 = (RemoteConfig)$continuation.L$1;
                this = (RemoteConfig)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl37:
                    // 2 sources

                    var5_10.updateConfig((RemoteConfigFlags)v0);
                    $this$fetch_u24lambda_u245.serializeToDisk();
                    var3_6 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable var4_9) {
                    var3_6 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var4_9));
                }
                var2_5 = var3_6;
                v1 = Result.exceptionOrNull-impl((Object)var2_5);
                if (v1 != null) {
                    var3_6 = v1;
                    $i$a$-onFailure-RemoteConfig$fetch$4 = false;
                    this.logger.info("Failed fetching feature flags remotely");
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void updateConfig(RemoteConfigFlags config) {
        RemoteConfigFlags nextValue$iv;
        Object prevValue$iv;
        this.lastFetchedConfig = config;
        MutableStateFlow<RemoteConfigFlags> $this$update$iv = this._fetchedConfig;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            RemoteConfigFlags it = (RemoteConfigFlags)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = config)));
    }

    private final void serializeToDisk() {
        block0: {
            RemoteConfigFlags remoteConfigFlags = this.lastFetchedConfig;
            if (remoteConfigFlags == null) break block0;
            RemoteConfigFlags it = remoteConfigFlags;
            boolean bl = false;
            String encryptedFeatureFlags = this.simpleEncryption.encrypt(this.featureFlagsService.serialize(it));
            this.encryptedFeatureFlagsDao.update(new EncryptedFeatureFlags(encryptedFeatureFlags, this.simpleEncryption.getSerializedSecretKey()));
        }
    }

    @Nullable
    public final RemoteConfigFlags get() {
        return this.lastFetchedConfig;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object lambda$3$lambda$2() {
        return "Unable to deserialize the feature flags from disk (is the data corrupted?)";
    }

    private static final Object fetch$lambda$4() {
        return "Fetching feature flags";
    }
}

