/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.http;

import io.ktor.server.plugins.ratelimit.RateLimiter;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.http.BrowserConnectionState;
import org.merlyn.sharedui.viewmodels.usecases.StatusDiagnosticEvents;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/merlyn/desktopapp/http/BrowserWebSocketRateLimiter;", "Lio/ktor/server/plugins/ratelimit/RateLimiter;", "state", "Lorg/merlyn/desktopapp/http/BrowserConnectionState;", "statusDiagnosticEvents", "Lorg/merlyn/sharedui/viewmodels/usecases/StatusDiagnosticEvents;", "<init>", "(Lorg/merlyn/desktopapp/http/BrowserConnectionState;Lorg/merlyn/sharedui/viewmodels/usecases/StatusDiagnosticEvents;)V", "wasConnected", "Ljava/util/concurrent/atomic/AtomicBoolean;", "tryConsume", "Lio/ktor/server/plugins/ratelimit/RateLimiter$State;", "tokens", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "app"})
public final class BrowserWebSocketRateLimiter
implements RateLimiter {
    @NotNull
    private final BrowserConnectionState state;
    @NotNull
    private final StatusDiagnosticEvents statusDiagnosticEvents;
    @NotNull
    private final AtomicBoolean wasConnected;

    public BrowserWebSocketRateLimiter(@NotNull BrowserConnectionState state, @NotNull StatusDiagnosticEvents statusDiagnosticEvents) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)statusDiagnosticEvents, (String)"statusDiagnosticEvents");
        this.state = state;
        this.statusDiagnosticEvents = statusDiagnosticEvents;
        this.wasConnected = new AtomicBoolean(false);
    }

    @Nullable
    public Object tryConsume(int tokens, @NotNull Continuation<? super RateLimiter.State> $completion) {
        RateLimiter.State state;
        if (((Boolean)this.state.getConnectionState().getValue()).booleanValue()) {
            if (!this.wasConnected.getAndSet(true)) {
                this.statusDiagnosticEvents.browserConnectionRejected();
            }
            state = (RateLimiter.State)new RateLimiter.State.Exhausted(DurationKt.toDuration((int)100, (DurationUnit)DurationUnit.DAYS), null);
        } else {
            this.wasConnected.set(false);
            state = (RateLimiter.State)new RateLimiter.State.Available(0, 1, Duration.getInWholeMilliseconds-impl((long)DurationKt.toDuration((int)100, (DurationUnit)DurationUnit.DAYS)));
        }
        return state;
    }
}

