/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.sound.sound_effect;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.sound.sound_effect.SoundEffect;
import org.merlyn.desktopapp.sound.sound_effect.SoundEffectPlayer;
import org.merlyn.desktopapp.sound.sound_effect.StartChime;
import org.merlyn.xaudio.BaseWavPlayer;
import org.merlyn.xaudio.WavPlayer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\f\u0010\f\u001a\u00020\r*\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/merlyn/desktopapp/sound/sound_effect/WindowsSoundEffectPlayer;", "Lorg/merlyn/desktopapp/sound/sound_effect/SoundEffectPlayer;", "fallbackSoundEffectPlayer", "Lkotlin/Lazy;", "player", "Lorg/merlyn/xaudio/BaseWavPlayer;", "<init>", "(Lkotlin/Lazy;Lkotlin/Lazy;)V", "logger", "Lmu/KLogger;", "thread", "Lorg/merlyn/desktopapp/sound/sound_effect/WindowsSoundEffectPlayer$PlaybackThread;", "getPath", "", "Lorg/merlyn/desktopapp/sound/sound_effect/SoundEffect;", "play", "", "soundEffect", "Companion", "PlaybackThread", "app"})
@SourceDebugExtension(value={"SMAP\nWindowsSoundEffectPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsSoundEffectPlayer.kt\norg/merlyn/desktopapp/sound/sound_effect/WindowsSoundEffectPlayer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,116:1\n1#2:117\n24#3:118\n63#3,3:119\n*S KotlinDebug\n*F\n+ 1 WindowsSoundEffectPlayer.kt\norg/merlyn/desktopapp/sound/sound_effect/WindowsSoundEffectPlayer\n*L\n40#1:118\n40#1:119,3\n*E\n"})
public final class WindowsSoundEffectPlayer
implements SoundEffectPlayer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Lazy<SoundEffectPlayer> fallbackSoundEffectPlayer;
    @NotNull
    private final Lazy<BaseWavPlayer> player;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final PlaybackThread thread;
    @NotNull
    private static final Path dir;

    /*
     * WARNING - void declaration
     */
    public WindowsSoundEffectPlayer(@NotNull Lazy<? extends SoundEffectPlayer> fallbackSoundEffectPlayer, @NotNull Lazy<? extends BaseWavPlayer> player) {
        void it;
        PlaybackThread playbackThread;
        Intrinsics.checkNotNullParameter(fallbackSoundEffectPlayer, (String)"fallbackSoundEffectPlayer");
        Intrinsics.checkNotNullParameter(player, (String)"player");
        this.fallbackSoundEffectPlayer = fallbackSoundEffectPlayer;
        this.player = player;
        this.logger = KotlinLogging.INSTANCE.logger(WindowsSoundEffectPlayer::logger$lambda$1);
        PlaybackThread playbackThread2 = playbackThread = new PlaybackThread();
        WindowsSoundEffectPlayer windowsSoundEffectPlayer = this;
        boolean bl = false;
        it.start();
        windowsSoundEffectPlayer.thread = playbackThread;
    }

    public /* synthetic */ WindowsSoundEffectPlayer(Lazy lazy, Lazy lazy2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            lazy2 = LazyKt.lazy(WindowsSoundEffectPlayer::_init_$lambda$0);
        }
        this((Lazy<? extends SoundEffectPlayer>)lazy, (Lazy<? extends BaseWavPlayer>)lazy2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getPath(SoundEffect $this$getPath) {
        Path path = dir.resolve(Paths.get($this$getPath.getResourceName(), new String[0]).getFileName());
        if (!Files.exists(path, new LinkOption[0])) {
            this.logger.debug(() -> WindowsSoundEffectPlayer.getPath$lambda$3($this$getPath, path));
            boolean $i$f$measureTime = false;
            TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
            boolean bl = false;
            Closeable closeable = $this$getPath.getClass().getResourceAsStream("/" + $this$getPath.getResourceName());
            Throwable throwable = null;
            try {
                InputStream stream = (InputStream)closeable;
                boolean bl2 = false;
                InputStream inputStream = stream;
                if (inputStream == null) {
                    boolean bl3 = false;
                    String string = "Failed to copy resource: " + $this$getPath.getResourceName();
                    throw new IllegalArgumentException(string.toString());
                }
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Files.copy(inputStream, path, copyOptionArray);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            long time = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
            this.logger.info(() -> WindowsSoundEffectPlayer.getPath$lambda$7($this$getPath, path, time));
        } else {
            this.logger.debug(() -> WindowsSoundEffectPlayer.getPath$lambda$8($this$getPath, path));
        }
        return ((Object)path.toAbsolutePath()).toString();
    }

    @Override
    public void play(@NotNull SoundEffect soundEffect) {
        Intrinsics.checkNotNullParameter((Object)soundEffect, (String)"soundEffect");
        this.thread.submit(soundEffect);
    }

    @Override
    @Nullable
    public Object playErrorChime(@NotNull Continuation<? super Unit> $completion) {
        return SoundEffectPlayer.DefaultImpls.playErrorChime(this, $completion);
    }

    @Override
    @Nullable
    public Object playMenuChime(@NotNull Continuation<? super Unit> $completion) {
        return SoundEffectPlayer.DefaultImpls.playMenuChime(this, $completion);
    }

    @Override
    @Nullable
    public Object playListeningStartChime(@NotNull Continuation<? super Unit> $completion) {
        return SoundEffectPlayer.DefaultImpls.playListeningStartChime(this, $completion);
    }

    private static final WavPlayer _init_$lambda$0() {
        return new WavPlayer();
    }

    private static final Unit logger$lambda$1() {
        return Unit.INSTANCE;
    }

    private static final Object getPath$lambda$3(SoundEffect $this_getPath, Path $path) {
        return "Saving " + $this_getPath + " to " + $path;
    }

    private static final Object getPath$lambda$7(SoundEffect $this_getPath, Path $path, long $time) {
        return "Saved " + $this_getPath + " to " + $path + ", in " + Duration.toString-impl((long)$time);
    }

    private static final Object getPath$lambda$8(SoundEffect $this_getPath, Path $path) {
        return "File for " + $this_getPath + " already exits: " + $path;
    }

    static {
        Path path;
        Companion = new Companion(null);
        Path it = path = Files.createTempDirectory("SoundEffects", new FileAttribute[0]);
        boolean bl = false;
        it.toFile().deleteOnExit();
        Path path2 = path;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"also(...)");
        dir = path2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/merlyn/desktopapp/sound/sound_effect/WindowsSoundEffectPlayer$Companion;", "", "<init>", "()V", "dir", "Ljava/nio/file/Path;", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/merlyn/desktopapp/sound/sound_effect/WindowsSoundEffectPlayer$PlaybackThread;", "Ljava/lang/Thread;", "<init>", "(Lorg/merlyn/desktopapp/sound/sound_effect/WindowsSoundEffectPlayer;)V", "queue", "Ljava/util/concurrent/BlockingQueue;", "Lorg/merlyn/desktopapp/sound/sound_effect/SoundEffect;", "useFallback", "", "run", "", "submit", "soundEffect", "app"})
    @SourceDebugExtension(value={"SMAP\nWindowsSoundEffectPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsSoundEffectPlayer.kt\norg/merlyn/desktopapp/sound/sound_effect/WindowsSoundEffectPlayer$PlaybackThread\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,116:1\n24#2:117\n63#2,3:118\n24#2:121\n63#2,3:122\n*S KotlinDebug\n*F\n+ 1 WindowsSoundEffectPlayer.kt\norg/merlyn/desktopapp/sound/sound_effect/WindowsSoundEffectPlayer$PlaybackThread\n*L\n71#1:117\n71#1:118,3\n91#1:121\n91#1:122,3\n*E\n"})
    private final class PlaybackThread
    extends Thread {
        @NotNull
        private final BlockingQueue<SoundEffect> queue;
        private boolean useFallback;

        public PlaybackThread() {
            super("SoundEffectPlayback");
            this.queue = new LinkedBlockingQueue();
        }

        @Override
        public void run() {
            Object object;
            WindowsSoundEffectPlayer.this.logger.debug(PlaybackThread::run$lambda$0);
            WindowsSoundEffectPlayer windowsSoundEffectPlayer = WindowsSoundEffectPlayer.this;
            boolean $i$f$measureTime = false;
            TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
            boolean $i$f$measureTime2 = false;
            long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
            boolean bl = false;
            Object object2 = this;
            try {
                PlaybackThread $this$run_u24lambda_u244_u24lambda_u241 = object2;
                boolean bl2 = false;
                ((BaseWavPlayer)windowsSoundEffectPlayer.player.getValue()).initialize();
                object = Result.constructor-impl((Object)windowsSoundEffectPlayer.getPath(StartChime.INSTANCE));
            }
            catch (Throwable bl2) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it = object = throwable;
                boolean bl3 = false;
                this.useFallback = true;
                windowsSoundEffectPlayer.logger.error((Throwable)it, PlaybackThread::run$lambda$4$lambda$3$lambda$2);
                windowsSoundEffectPlayer.fallbackSoundEffectPlayer.getValue();
            }
            long initTime = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
            WindowsSoundEffectPlayer.this.logger.info(() -> PlaybackThread.run$lambda$5(initTime));
            while (!this.isInterrupted()) {
                try {
                    SoundEffect playing = this.queue.take();
                    WindowsSoundEffectPlayer.this.logger.debug(() -> PlaybackThread.run$lambda$6(playing));
                    WindowsSoundEffectPlayer windowsSoundEffectPlayer2 = WindowsSoundEffectPlayer.this;
                    boolean $i$f$measureTime3 = false;
                    TimeSource.Monotonic $this$measureTime$iv$iv2 = TimeSource.Monotonic.INSTANCE;
                    boolean $i$f$measureTime4 = false;
                    long mark$iv$iv2 = $this$measureTime$iv$iv2.markNow-z9LOYto();
                    boolean bl4 = false;
                    try {
                        if (!this.useFallback) {
                            BaseWavPlayer baseWavPlayer = (BaseWavPlayer)windowsSoundEffectPlayer2.player.getValue();
                            Intrinsics.checkNotNull((Object)playing);
                            baseWavPlayer.play(windowsSoundEffectPlayer2.getPath(playing));
                        } else {
                            SoundEffectPlayer soundEffectPlayer = (SoundEffectPlayer)windowsSoundEffectPlayer2.fallbackSoundEffectPlayer.getValue();
                            Intrinsics.checkNotNull((Object)playing);
                            soundEffectPlayer.play(playing);
                        }
                    }
                    catch (Exception ex) {
                        windowsSoundEffectPlayer2.logger.error((Throwable)ex, () -> PlaybackThread.run$lambda$8$lambda$7(playing));
                        this.useFallback = true;
                        SoundEffectPlayer soundEffectPlayer = (SoundEffectPlayer)windowsSoundEffectPlayer2.fallbackSoundEffectPlayer.getValue();
                        Intrinsics.checkNotNull((Object)playing);
                        soundEffectPlayer.play(playing);
                    }
                    long playTime = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv2);
                    WindowsSoundEffectPlayer.this.logger.info(() -> PlaybackThread.run$lambda$9(playing, playTime));
                }
                catch (InterruptedException t) {
                    WindowsSoundEffectPlayer.this.logger.warn((Throwable)t, PlaybackThread::run$lambda$10);
                }
            }
        }

        public final void submit(@NotNull SoundEffect soundEffect) {
            Intrinsics.checkNotNullParameter((Object)soundEffect, (String)"soundEffect");
            this.queue.clear();
            this.queue.offer(soundEffect);
        }

        private static final Object run$lambda$0() {
            return "Initializing...";
        }

        private static final Object run$lambda$4$lambda$3$lambda$2() {
            return "Error initializing xAudio or extracting sound files, will fallback to Java audio APIs";
        }

        private static final Object run$lambda$5(long $initTime) {
            return "Initialized in " + Duration.toString-impl((long)$initTime);
        }

        private static final Object run$lambda$6(SoundEffect $playing) {
            return "Playing " + $playing + "...";
        }

        private static final Object run$lambda$8$lambda$7(SoundEffect $playing) {
            return "Error playing " + $playing + " using xAudio, will fallback to Java audio APIs";
        }

        private static final Object run$lambda$9(SoundEffect $playing, long $playTime) {
            return "Played " + $playing + " in " + Duration.toString-impl((long)$playTime);
        }

        private static final Object run$lambda$10() {
            return "Interrupted";
        }
    }
}

