/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.startup.early.impl;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.metrics.Metric;
import org.merlyn.desktopapp.metrics.MetricName;
import org.merlyn.desktopapp.os.AppErrorExit;
import org.merlyn.desktopapp.os.Arch;
import org.merlyn.desktopapp.os.ExitStatus;
import org.merlyn.desktopapp.os.HostOS;
import org.merlyn.desktopapp.startup.early.StartUpHook;
import org.merlyn.sharedui.res.Strings;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lorg/merlyn/desktopapp/startup/early/impl/MacOsArchitectureValidator;", "Lorg/merlyn/desktopapp/startup/early/StartUpHook;", "appFatBinary", "", "<init>", "(Z)V", "libraries", "", "", "basePath", "regex", "Lkotlin/text/Regex;", "shouldRun", "getShouldRun", "()Z", "runStartupHookAtT0", "", "isSameArchitecture", "getLibraryArchitecture", "libFilename", "app"})
@SourceDebugExtension(value={"SMAP\nMacOsArchitectureValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacOsArchitectureValidator.kt\norg/merlyn/desktopapp/startup/early/impl/MacOsArchitectureValidator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,90:1\n1#2:91\n*E\n"})
public class MacOsArchitectureValidator
implements StartUpHook {
    private final boolean appFatBinary;
    @NotNull
    private final List<String> libraries;
    @NotNull
    private final String basePath;
    @NotNull
    private final Regex regex;

    public MacOsArchitectureValidator(boolean appFatBinary) {
        this.appFatBinary = appFatBinary;
        Object[] objectArray = new String[]{"libjava.dylib", "libosxapp.dylib", "libosx.dylib", "libosxsecurity.dylib", "libnio.dylib", "libnet.dylib"};
        this.libraries = CollectionsKt.listOf((Object[])objectArray);
        this.basePath = "/Contents/runtime/Contents/Home/lib/";
        this.regex = new Regex("^[^:]+: Mach-O 64-bit dynamically linked shared library (\\w+)$");
    }

    @Override
    public boolean getShouldRun() {
        return HostOS.INSTANCE.getHostOs().isMacOS() && !this.appFatBinary;
    }

    @Override
    public void runStartupHookAtT0() {
        boolean isValidArch = this.isSameArchitecture();
        if (!isValidArch) {
            Metric metric;
            Metric $this$runStartupHookAtT0_u24lambda_u240 = metric = Metric.Companion.instance();
            boolean bl = false;
            Metric.counterIncrement$default($this$runStartupHookAtT0_u24lambda_u240, MetricName.APP_ERROR_START_WRONG_ARCHITECTURE, null, 2, null);
            Metric.counterIncrement$default($this$runStartupHookAtT0_u24lambda_u240, MetricName.APP_ERROR_START, null, 2, null);
            String arch = switch (WhenMappings.$EnumSwitchMapping$0[HostOS.INSTANCE.getHostRealArch().ordinal()]) {
                case 1 -> "(unknown)";
                case 2 -> "Apple Silicon";
                case 3 -> "Intel";
                default -> throw new NoWhenBranchMatchedException();
            };
            String string = Strings.INSTANCE.getDIALOG_WRONG_ARCHITECTURE_MESSAGE();
            Object[] objectArray = new Object[]{arch};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            AppErrorExit.exitWithDialog$default(AppErrorExit.INSTANCE, ExitStatus.WrongArchitecture, string2, null, 4, null);
        }
    }

    private final boolean isSameArchitecture() {
        Arch hostRealArch = HostOS.INSTANCE.getHostRealArch();
        String string = System.getProperty("app.dir");
        if (string == null) {
            return true;
        }
        String appDir = string;
        String libsPath = StringsKt.replace$default((String)appDir, (String)"/Contents/Resources", (String)this.basePath, (boolean)false, (int)4, null);
        for (String lib : this.libraries) {
            Object object;
            String libFilename = libsPath + lib;
            Object object2 = this;
            try {
                MacOsArchitectureValidator $this$isSameArchitecture_u24lambda_u241 = object2;
                boolean bl = false;
                object = Result.constructor-impl((Object)$this$isSameArchitecture_u24lambda_u241.getLibraryArchitecture(libFilename));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            String arch = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
            object2 = arch;
            if (Intrinsics.areEqual((Object)object2, (Object)"x86_64")) {
                return hostRealArch == Arch.X86;
            }
            if (!Intrinsics.areEqual((Object)object2, (Object)"arm64")) continue;
            return hostRealArch == Arch.ARM;
        }
        return true;
    }

    @Nullable
    protected String getLibraryArchitecture(@NotNull String libFilename) {
        MatchResult match;
        Intrinsics.checkNotNullParameter((Object)libFilename, (String)"libFilename");
        String[] stringArray = new String[]{"file", libFilename};
        Process process2 = new ProcessBuilder(stringArray).start();
        InputStream inputStream = process2.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        List lines = TextStreamsKt.readLines((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        int result = process2.waitFor();
        if (result == 0 && !((Collection)lines).isEmpty() && (match = Regex.find$default((Regex)this.regex, (CharSequence)((CharSequence)lines.get(0)), (int)0, (int)2, null)) != null) {
            return (String)match.getGroupValues().get(1);
        }
        return null;
    }

    @Override
    public void runStartupHookAtT1() {
        StartUpHook.DefaultImpls.runStartupHookAtT1(this);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Arch.values().length];
            try {
                nArray[Arch.UNKNOWN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Arch.ARM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Arch.X86.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

