/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.state;

import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.java.KoinJavaComponent;
import org.merlyn.desktopapp.coresdk.state.CoreSDKStateHandlerKt;
import org.merlyn.desktopapp.http.AwsCredentials;
import org.merlyn.desktopapp.http.CognitoHelper;
import org.merlyn.desktopapp.http.GetProxyConfiguration;
import org.merlyn.desktopapp.http.OAuth2Helper;
import org.merlyn.desktopapp.http.TokenData;
import org.merlyn.desktopapp.log.LogbackService;
import org.merlyn.desktopapp.state.InternalStateHandler;
import org.merlyn.desktopapp.state.StateHandler;
import org.merlyn.desktopapp.storage.TokenDataDao;
import software.amazon.awssdk.core.SdkSystemSetting;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0086@\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0086@\u00a2\u0006\u0002\u0010!J\u000e\u0010\"\u001a\u00020\u001aH\u0086@\u00a2\u0006\u0002\u0010#J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020\u001cJ\b\u0010'\u001a\u00020\u001aH\u0002J\u000e\u0010(\u001a\u00020\u001aH\u0086@\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/merlyn/desktopapp/state/StateHandler;", "", "auth", "Lorg/merlyn/desktopapp/http/OAuth2Helper;", "tokenDao", "Lorg/merlyn/desktopapp/storage/TokenDataDao;", "logbackService", "Lorg/merlyn/desktopapp/log/LogbackService;", "cognitoHelper", "Lorg/merlyn/desktopapp/http/CognitoHelper;", "getProxyConfiguration", "Lorg/merlyn/desktopapp/http/GetProxyConfiguration;", "<init>", "(Lorg/merlyn/desktopapp/http/OAuth2Helper;Lorg/merlyn/desktopapp/storage/TokenDataDao;Lorg/merlyn/desktopapp/log/LogbackService;Lorg/merlyn/desktopapp/http/CognitoHelper;Lorg/merlyn/desktopapp/http/GetProxyConfiguration;)V", "logger", "Lmu/KLogger;", "awsLogsCredentialsExpiration", "Ljava/time/Instant;", "kotlin.jvm.PlatformType", "getAwsLogsCredentialsExpiration", "()Ljava/time/Instant;", "_awsLogsCredentialsExpiration", "Ljava/time/Instant;", "internalStateHandler", "Lorg/merlyn/desktopapp/state/InternalStateHandler;", "onAuthCodeReceived", "", "code", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onTokenRefreshed", "data", "Lorg/merlyn/desktopapp/http/TokenData;", "(Lorg/merlyn/desktopapp/http/TokenData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onLoggedOut", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "markAsLoggedInAndStore", "setAWSLogsCredentials", "idToken", "autoConfigureProxy", "switch", "app"})
@SourceDebugExtension(value={"SMAP\nStateHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateHandler.kt\norg/merlyn/desktopapp/state/StateHandler\n+ 2 Koin.kt\norg/koin/core/Koin\n+ 3 Scope.kt\norg/koin/core/scope/Scope\n*L\n1#1,117:1\n105#2,4:118\n105#2,4:123\n136#3:122\n136#3:127\n*S KotlinDebug\n*F\n+ 1 StateHandler.kt\norg/merlyn/desktopapp/state/StateHandler\n*L\n39#1:118,4\n103#1:123,4\n39#1:122\n103#1:127\n*E\n"})
public final class StateHandler {
    @NotNull
    private final OAuth2Helper auth;
    @NotNull
    private final TokenDataDao tokenDao;
    @NotNull
    private final LogbackService logbackService;
    @NotNull
    private final CognitoHelper cognitoHelper;
    @NotNull
    private final GetProxyConfiguration getProxyConfiguration;
    @NotNull
    private final KLogger logger;
    private Instant _awsLogsCredentialsExpiration;
    @NotNull
    private InternalStateHandler internalStateHandler;

    public StateHandler(@NotNull OAuth2Helper auth, @NotNull TokenDataDao tokenDao, @NotNull LogbackService logbackService, @NotNull CognitoHelper cognitoHelper, @NotNull GetProxyConfiguration getProxyConfiguration) {
        Intrinsics.checkNotNullParameter((Object)auth, (String)"auth");
        Intrinsics.checkNotNullParameter((Object)tokenDao, (String)"tokenDao");
        Intrinsics.checkNotNullParameter((Object)logbackService, (String)"logbackService");
        Intrinsics.checkNotNullParameter((Object)cognitoHelper, (String)"cognitoHelper");
        Intrinsics.checkNotNullParameter((Object)getProxyConfiguration, (String)"getProxyConfiguration");
        this.auth = auth;
        this.tokenDao = tokenDao;
        this.logbackService = logbackService;
        this.cognitoHelper = cognitoHelper;
        this.getProxyConfiguration = getProxyConfiguration;
        this.logger = KotlinLogging.INSTANCE.logger(StateHandler::logger$lambda$0);
        this._awsLogsCredentialsExpiration = Instant.MAX;
        Koin $this$iv = KoinJavaComponent.getKoin();
        Qualifier qualifier$iv = null;
        Function0 parameters$iv = null;
        boolean $i$f$get = false;
        Scope this_$iv$iv = $this$iv.getScopeRegistry().getRootScope();
        boolean $i$f$get2 = false;
        this.internalStateHandler = (InternalStateHandler)this_$iv$iv.get(Reflection.getOrCreateKotlinClass(InternalStateHandler.class), qualifier$iv, parameters$iv);
        this.autoConfigureProxy();
    }

    public final Instant getAwsLogsCredentialsExpiration() {
        return this._awsLogsCredentialsExpiration;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object onAuthCodeReceived(@NotNull String var1_1, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof onAuthCodeReceived.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ StateHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.onAuthCodeReceived(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.auth.retrieveDataFromCode((String)code, (Continuation<? super TokenData>)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (StateHandler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                data = (TokenData)v0;
                $continuation.L$0 = this;
                $continuation.label = 2;
                v1 = this.onTokenRefreshed(data, (Continuation<? super Unit>)$continuation);
                if (v1 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl33
            }
            case 2: {
                this = (StateHandler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                this.logger.info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, onAuthCodeReceived$lambda$1(), ()Ljava/lang/Object;)());
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object onTokenRefreshed(@NotNull TokenData data, @NotNull Continuation<? super Unit> $completion) {
        this.markAsLoggedInAndStore(data);
        this.setAWSLogsCredentials(data.getIdToken());
        Object object = this.internalStateHandler.onLoggedIn(data, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object onLoggedOut(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof onLoggedOut.1)) ** GOTO lbl-1000
        var3_2 = $completion;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ StateHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.onLoggedOut((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.tokenDao.clear();
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.internalStateHandler.onLoggedOut((Continuation<? super Unit>)$continuation);
                if (v0 == var4_4) {
                    return var4_4;
                }
                ** GOTO lbl24
            }
            case 1: {
                this = (StateHandler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                this.logger.info((Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, onLoggedOut$lambda$2(), ()Ljava/lang/Object;)());
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void markAsLoggedInAndStore(TokenData data) {
        this.tokenDao.updateTokens(data.getAccessToken(), data.getRefreshToken(), data.getIdToken(), CoreSDKStateHandlerKt.getHasValidLicense(data.getAccessToken()));
    }

    public final void setAWSLogsCredentials(@NotNull String idToken) {
        block2: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)idToken, (String)"idToken");
            this.autoConfigureProxy();
            Object object2 = this;
            try {
                StateHandler $this$setAWSLogsCredentials_u24lambda_u243 = object2;
                boolean bl = false;
                AwsCredentials credentials = $this$setAWSLogsCredentials_u24lambda_u243.cognitoHelper.getSTSCredentials(idToken);
                System.setProperty("aws.accessKeyId", credentials.getAccessKeyId());
                System.setProperty("aws.secretKey", credentials.getSecretAccessKey());
                System.setProperty(SdkSystemSetting.AWS_SECRET_ACCESS_KEY.property(), credentials.getSecretAccessKey());
                System.setProperty("aws.sessionToken", credentials.getSessionToken());
                $this$setAWSLogsCredentials_u24lambda_u243._awsLogsCredentialsExpiration = credentials.getExpiration();
                $this$setAWSLogsCredentials_u24lambda_u243.logbackService.onAWSCredentials();
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Object it = object = throwable;
            boolean bl = false;
            this.logger.error((Throwable)it, () -> StateHandler.setAWSLogsCredentials$lambda$5$lambda$4((Throwable)it));
            this.logbackService.onAWSCredentialsRetrievalFailed();
        }
    }

    private final void autoConfigureProxy() {
        block0: {
            GetProxyConfiguration.HttpProxyConfiguration httpProxyConfiguration = this.getProxyConfiguration.detectProxyForUrl("https://*.amazonaws.com");
            if (httpProxyConfiguration == null) break block0;
            GetProxyConfiguration.HttpProxyConfiguration it = httpProxyConfiguration;
            boolean bl = false;
            this.logger.debug(() -> StateHandler.autoConfigureProxy$lambda$7$lambda$6(it));
            System.setProperty("http.proxyHost", it.getHost());
            System.setProperty("http.proxyPort", String.valueOf(it.getPort()));
            System.setProperty("https.proxyHost", it.getHost());
            System.setProperty("https.proxyPort", String.valueOf(it.getPort()));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object switch(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof switch.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ StateHandler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.switch((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = this.internalStateHandler.beforeSwitch((Continuation<? super Unit>)$continuation);
                if (v0 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                this = (StateHandler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                $this$iv = KoinJavaComponent.getKoin();
                qualifier$iv = null;
                parameters$iv = null;
                $i$f$get = false;
                this_$iv$iv = $this$iv.getScopeRegistry().getRootScope();
                $i$f$get = false;
                this.internalStateHandler = (InternalStateHandler)this_$iv$iv.get(Reflection.getOrCreateKotlinClass(InternalStateHandler.class), qualifier$iv, parameters$iv);
                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = this.internalStateHandler.afterSwitch((Continuation<? super Unit>)$continuation);
                if (v1 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl39
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl39:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object onAuthCodeReceived$lambda$1() {
        return "User logged in";
    }

    private static final Object onLoggedOut$lambda$2() {
        return "User logged out";
    }

    private static final Object setAWSLogsCredentials$lambda$5$lambda$4(Throwable $it) {
        return "Failure setting AWS credentials: " + $it.getMessage();
    }

    private static final Object autoConfigureProxy$lambda$7$lambda$6(GetProxyConfiguration.HttpProxyConfiguration $it) {
        return "Configuring AWS proxy with host: " + $it.getHost() + " port: " + $it.getPort();
    }
}

