/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.storage.encypt;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003J\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003J\b\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/merlyn/desktopapp/storage/encypt/SimpleEncryption;", "", "serializedSecretKey", "", "<init>", "(Ljava/lang/String;)V", "secretKey", "Ljavax/crypto/SecretKey;", "getSerializedSecretKey", "()Ljava/lang/String;", "encrypt", "plainText", "decrypt", "cypherTextBase64", "generateSecretKey", "serializeSecretKey", "deserializeSecretKey", "base64Key", "app"})
@SourceDebugExtension(value={"SMAP\nSimpleEncryption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleEncryption.kt\norg/merlyn/desktopapp/storage/encypt/SimpleEncryption\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class SimpleEncryption {
    @NotNull
    private final SecretKey secretKey;

    /*
     * WARNING - void declaration
     */
    public SimpleEncryption(@Nullable String serializedSecretKey) {
        Object object;
        block3: {
            block2: {
                void it;
                SimpleEncryption simpleEncryption = this;
                object = serializedSecretKey;
                if (object == null) break block2;
                String string = object;
                SimpleEncryption simpleEncryption2 = simpleEncryption;
                boolean bl = false;
                SecretKey secretKey = this.deserializeSecretKey((String)it);
                simpleEncryption = simpleEncryption2;
                object = secretKey;
                if (secretKey != null) break block3;
            }
            object = this.generateSecretKey();
        }
        simpleEncryption.secretKey = object;
    }

    @NotNull
    public final String getSerializedSecretKey() {
        return this.serializeSecretKey(this.secretKey);
    }

    @NotNull
    public final String encrypt(@NotNull String plainText) {
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(1, this.secretKey);
        byte[] byArray = plainText.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] encryptedBytes = cipher.doFinal(byArray);
        Base64 base64 = (Base64)Base64.Default;
        Intrinsics.checkNotNull((Object)encryptedBytes);
        return Base64.encode$default((Base64)base64, (byte[])encryptedBytes, (int)0, (int)0, (int)6, null);
    }

    @NotNull
    public final String decrypt(@NotNull String cypherTextBase64) {
        Intrinsics.checkNotNullParameter((Object)cypherTextBase64, (String)"cypherTextBase64");
        byte[] encryptedBytes = Base64.decode$default((Base64)((Base64)Base64.Default), (CharSequence)cypherTextBase64, (int)0, (int)0, (int)6, null);
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, this.secretKey);
        byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
        Intrinsics.checkNotNull((Object)decryptedBytes);
        return new String(decryptedBytes, Charsets.UTF_8);
    }

    private final SecretKey generateSecretKey() {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        SecretKey secretKey = keyGen.generateKey();
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"generateKey(...)");
        return secretKey;
    }

    private final String serializeSecretKey(SecretKey secretKey) {
        Base64 base64 = (Base64)Base64.Default;
        byte[] byArray = secretKey.getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
        return Base64.encode$default((Base64)base64, (byte[])byArray, (int)0, (int)0, (int)6, null);
    }

    private final SecretKey deserializeSecretKey(String base64Key) {
        byte[] decodedKey = Base64.decode$default((Base64)((Base64)Base64.Default), (CharSequence)base64Key, (int)0, (int)0, (int)6, null);
        return new SecretKeySpec(decodedKey, "AES");
    }
}

