/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.coresdk.agent.impl;

import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.agent.KeyEventAction;
import org.merlyn.desktopapp.config.StageConfig;
import org.merlyn.desktopapp.coresdk.agent.DesktopAppAgent;
import org.merlyn.desktopapp.coresdk.agent.impl.FeedbackAgent;
import org.merlyn.desktopapp.coresdk.rcu.KeyCode;
import org.merlyn.desktopapp.coresdk.rcu.KeyEvent;
import org.merlyn.desktopapp.coresdk.rcu.KeyEventDampener;
import org.merlyn.desktopapp.coresdk.rcu.impl.KeyEventDampenerImpl;
import org.merlyn.desktopapp.http.commands.UnableToHandleException;
import org.merlyn.desktopapp.service.FeedbackInput;
import org.merlyn.desktopapp.service.FeedbackService;
import org.merlyn.desktopapp.service.FeedbackType;
import org.merlyn.sharedui.res.Strings;
import org.merlyn.sharedui.viewmodels.usecases.FeedbackEvent;
import org.merlyn.sharedui.viewmodels.usecases.ObserveFeedbackUseCase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0016J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0096@\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00130 H\u0016J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\f\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/merlyn/desktopapp/coresdk/agent/impl/FeedbackAgent;", "Lorg/merlyn/desktopapp/coresdk/agent/DesktopAppAgent;", "Lorg/merlyn/sharedui/viewmodels/usecases/ObserveFeedbackUseCase;", "feedbackService", "Lorg/merlyn/desktopapp/service/FeedbackService;", "config", "Lorg/merlyn/desktopapp/config/StageConfig;", "<init>", "(Lorg/merlyn/desktopapp/service/FeedbackService;Lorg/merlyn/desktopapp/config/StageConfig;)V", "agentName", "", "getAgentName", "()Ljava/lang/String;", "agentVersion", "getAgentVersion", "setAgentVersion", "(Ljava/lang/String;)V", "feedbackEvents", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lorg/merlyn/sharedui/viewmodels/usecases/FeedbackEvent;", "_feedbackCodes", "", "Lorg/merlyn/desktopapp/coresdk/rcu/KeyCode;", "keyEventDampener", "Lorg/merlyn/desktopapp/coresdk/rcu/KeyEventDampener;", "getManagedShortPressKeyCodes", "handleKeyEvent", "", "event", "Lorg/merlyn/desktopapp/coresdk/rcu/KeyEvent;", "(Lorg/merlyn/desktopapp/coresdk/rcu/KeyEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getFeedbackEvents", "Lkotlinx/coroutines/flow/SharedFlow;", "render", "Companion", "app"})
public final class FeedbackAgent
implements DesktopAppAgent,
ObserveFeedbackUseCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeedbackService feedbackService;
    @NotNull
    private final String agentName;
    @NotNull
    private String agentVersion;
    @NotNull
    private final MutableSharedFlow<FeedbackEvent> feedbackEvents;
    @NotNull
    private final Set<KeyCode> _feedbackCodes;
    @NotNull
    private final KeyEventDampener keyEventDampener;
    @NotNull
    public static final String AGENT_NAME = "Feedback";
    @NotNull
    public static final String AGENT_VERSION = "1.0.0";

    public FeedbackAgent(@NotNull FeedbackService feedbackService, @NotNull StageConfig config) {
        Intrinsics.checkNotNullParameter((Object)feedbackService, (String)"feedbackService");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.feedbackService = feedbackService;
        this.agentName = AGENT_NAME;
        this.agentVersion = AGENT_VERSION;
        this.feedbackEvents = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, null, (int)4, null);
        KeyCode[] keyCodeArray = new KeyCode[]{KeyCode.THUMBS_DOWN, KeyCode.THUMBS_UP};
        this._feedbackCodes = SetsKt.setOf((Object[])keyCodeArray);
        this.keyEventDampener = new KeyEventDampenerImpl(this._feedbackCodes, config);
    }

    @NotNull
    public String getAgentName() {
        return this.agentName;
    }

    @Override
    @NotNull
    public String getAgentVersion() {
        return this.agentVersion;
    }

    @Override
    public void setAgentVersion(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.agentVersion = string;
    }

    @Override
    @NotNull
    public Set<KeyCode> getManagedShortPressKeyCodes() {
        return this._feedbackCodes;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object handleKeyEvent(@NotNull KeyEvent event, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof handleKeyEvent.1)) ** GOTO lbl-1000
        var5_3 = $completion;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ FeedbackAgent this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.handleKeyEvent(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this._feedbackCodes.contains((Object)event.getKeyCode())) {
                    throw new UnableToHandleException("not supported key code: " + event.getKeyCode().name());
                }
                if (event.getKeyAction() != KeyEventAction.Up) ** GOTO lbl43
                $continuation.L$0 = event;
                $continuation.label = 1;
                v0 = this.keyEventDampener.allow(event.getKeyCode(), (Continuation<? super Boolean>)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl25
            }
            case 1: {
                event = (KeyEvent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) ** GOTO lbl43
                feedbackType = event.getKeyCode() == KeyCode.THUMBS_DOWN ? FeedbackType.NEGATIVE : FeedbackType.POSITIVE;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)event);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)feedbackType);
                $continuation.label = 2;
                v1 = this.feedbackService.send(feedbackType, FeedbackInput.RCU, (Continuation<? super String>)$continuation);
                if (v1 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl39
            }
            case 2: {
                feedbackType = (FeedbackType)$continuation.L$1;
                event = (KeyEvent)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl39:
                // 2 sources

                v2 = Strings.INSTANCE.getFEEDBACK_AGENT_FEEDBACK_MESSAGE();
                v3 = UUID.randomUUID().toString();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"toString(...)");
                this.render(new FeedbackEvent(v2, v3));
lbl43:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public SharedFlow<FeedbackEvent> getFeedbackEvents() {
        return FlowKt.asSharedFlow(this.feedbackEvents);
    }

    public void render(@NotNull FeedbackEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!this.feedbackEvents.tryEmit((Object)event)) {
            throw new IllegalStateException("Check failed.");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/merlyn/desktopapp/coresdk/agent/impl/FeedbackAgent$Companion;", "", "<init>", "()V", "AGENT_NAME", "", "AGENT_VERSION", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

