/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.storage.modernimpl;

import java.time.Instant;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.merlyn.desktopapp.storage.FtueData;
import org.merlyn.desktopapp.storage.modernimpl.DefaultEntities;
import org.merlyn.desktopapp.storage.modernimpl.PreferencesFileStorage;
import org.merlyn.sharedui.viewmodels.usecases.Available;
import org.merlyn.sharedui.viewmodels.usecases.Completed;
import org.merlyn.sharedui.viewmodels.usecases.FtueDao;
import org.merlyn.sharedui.viewmodels.usecases.Scheduled;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/merlyn/desktopapp/storage/modernimpl/FtueDaoImpl;", "Lorg/merlyn/sharedui/viewmodels/usecases/FtueDao;", "preferencesFileStorage", "Lorg/merlyn/desktopapp/storage/modernimpl/PreferencesFileStorage;", "<init>", "(Lorg/merlyn/desktopapp/storage/modernimpl/PreferencesFileStorage;)V", "_state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lorg/merlyn/sharedui/viewmodels/usecases/FtueDao$State;", "state", "Lkotlinx/coroutines/flow/StateFlow;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "get", "Lorg/merlyn/desktopapp/storage/FtueData;", "read", "update", "", "app"})
@SourceDebugExtension(value={"SMAP\nFtueDaoImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FtueDaoImpl.kt\norg/merlyn/desktopapp/storage/modernimpl/FtueDaoImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,50:1\n1#2:51\n230#3,5:52\n*S KotlinDebug\n*F\n+ 1 FtueDaoImpl.kt\norg/merlyn/desktopapp/storage/modernimpl/FtueDaoImpl\n*L\n47#1:52,5\n*E\n"})
public final class FtueDaoImpl
implements FtueDao {
    @NotNull
    private final PreferencesFileStorage preferencesFileStorage;
    @NotNull
    private final MutableStateFlow<FtueDao.State> _state;
    @NotNull
    private final StateFlow<FtueDao.State> state;

    public FtueDaoImpl(@NotNull PreferencesFileStorage preferencesFileStorage) {
        Intrinsics.checkNotNullParameter((Object)preferencesFileStorage, (String)"preferencesFileStorage");
        this.preferencesFileStorage = preferencesFileStorage;
        this._state = StateFlowKt.MutableStateFlow((Object)this.read());
        this.state = FlowKt.asStateFlow(this._state);
    }

    @NotNull
    public StateFlow<FtueDao.State> getState() {
        return this.state;
    }

    private final FtueData get() {
        FtueData ftueData = this.preferencesFileStorage.getFtueData();
        if (ftueData == null) {
            FtueData ftueData2;
            FtueDaoImpl $this$get_u24lambda_u240 = this;
            boolean bl = false;
            FtueData it = ftueData2 = DefaultEntities.INSTANCE.getDefaultFtueData();
            boolean bl2 = false;
            $this$get_u24lambda_u240.preferencesFileStorage.setFtueData(it);
            ftueData = ftueData2;
        }
        return ftueData;
    }

    private final FtueDao.State read() {
        FtueDao.State state;
        FtueData it = this.get();
        boolean bl = false;
        Long completedOn = it.getCompletedOn();
        if (completedOn != null) {
            Instant instant = Instant.ofEpochMilli(completedOn);
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
            state = (FtueDao.State)new Completed(instant);
        } else {
            Long remindOn = it.getRemindOn();
            if (remindOn != null) {
                Instant instant = Instant.ofEpochMilli(remindOn);
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
                state = (FtueDao.State)new Scheduled(instant);
            } else {
                state = (FtueDao.State)Available.INSTANCE;
            }
        }
        return state;
    }

    public void update(@NotNull FtueDao.State state) {
        FtueDao.State nextValue$iv;
        Object prevValue$iv;
        FtueData ftueData;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        FtueDao.State state2 = state;
        if (Intrinsics.areEqual((Object)state2, (Object)Available.INSTANCE)) {
            ftueData = new FtueData(null, null);
        } else if (state2 instanceof Completed) {
            ftueData = new FtueData(((Completed)state).getDate().toEpochMilli(), null);
        } else if (state2 instanceof Scheduled) {
            ftueData = new FtueData(null, ((Scheduled)state).getDate().toEpochMilli());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.preferencesFileStorage.setFtueData(ftueData);
        MutableStateFlow<FtueDao.State> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            FtueDao.State it = (FtueDao.State)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = state)));
    }
}

