/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.storage.modernimpl;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEventVO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.merlyn.desktopapp.storage.LoggingEventDao;
import org.merlyn.desktopapp.storage.database.LoggingEventDatabaseDao;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0007H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/merlyn/desktopapp/storage/modernimpl/LoggingEventDaoImpl;", "Lorg/merlyn/desktopapp/storage/LoggingEventDao;", "loggingEventDatabaseDao", "Lorg/merlyn/desktopapp/storage/database/LoggingEventDatabaseDao;", "<init>", "(Lorg/merlyn/desktopapp/storage/database/LoggingEventDatabaseDao;)V", "add", "", "loggingEvent", "Lch/qos/logback/classic/spi/ILoggingEvent;", "getBatch", "", "size", "", "cleanup", "serialize", "", "Lch/qos/logback/classic/spi/LoggingEventVO;", "deserialize", "serialized", "app"})
@SourceDebugExtension(value={"SMAP\nLoggingEventDaoImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoggingEventDaoImpl.kt\norg/merlyn/desktopapp/storage/modernimpl/LoggingEventDaoImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,52:1\n1563#2:53\n1634#2,3:54\n1869#2,2:57\n*S KotlinDebug\n*F\n+ 1 LoggingEventDaoImpl.kt\norg/merlyn/desktopapp/storage/modernimpl/LoggingEventDaoImpl\n*L\n23#1:53\n23#1:54,3\n24#1:57,2\n*E\n"})
public final class LoggingEventDaoImpl
implements LoggingEventDao {
    @NotNull
    private final LoggingEventDatabaseDao loggingEventDatabaseDao;

    public LoggingEventDaoImpl(@NotNull LoggingEventDatabaseDao loggingEventDatabaseDao) {
        Intrinsics.checkNotNullParameter((Object)loggingEventDatabaseDao, (String)"loggingEventDatabaseDao");
        this.loggingEventDatabaseDao = loggingEventDatabaseDao;
    }

    @Override
    public void add(@NotNull ILoggingEvent loggingEvent) {
        Intrinsics.checkNotNullParameter((Object)loggingEvent, (String)"loggingEvent");
        LoggingEventVO eventToSerialize = LoggingEventVO.build((ILoggingEvent)loggingEvent);
        long l = loggingEvent.getTimeStamp();
        Intrinsics.checkNotNull((Object)eventToSerialize);
        this.loggingEventDatabaseDao.insert(l, this.serialize(eventToSerialize));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ILoggingEvent> getBatch(int size) {
        void $this$mapTo$iv$iv;
        List<Triple<Long, Long, byte[]>> events = this.loggingEventDatabaseDao.queryAll(size);
        Iterable $this$map$iv = events;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Triple triple = (Triple)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.deserialize((byte[])it.getThird()));
        }
        List result = (List)destination$iv$iv;
        Iterable $this$forEach$iv = events;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Triple it = (Triple)element$iv;
            boolean bl = false;
            this.loggingEventDatabaseDao.delete(((Number)it.getFirst()).longValue());
        }
        return result;
    }

    @Override
    public void cleanup() {
        this.loggingEventDatabaseDao.vacuumDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final byte[] serialize(LoggingEventVO loggingEvent) {
        ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
        ObjectOutputStream serializer2 = new ObjectOutputStream(byteArrayStream);
        Closeable closeable = serializer2;
        Throwable throwable = null;
        try {
            ObjectOutputStream it = (ObjectOutputStream)closeable;
            boolean bl = false;
            it.writeObject(loggingEvent);
            it.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray = byteArrayStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LoggingEventVO deserialize(byte[] serialized) {
        ObjectInputStream deserializer = new ObjectInputStream(new ByteArrayInputStream(serialized));
        Closeable closeable = deserializer;
        Throwable throwable = null;
        try {
            ObjectInputStream it = (ObjectInputStream)closeable;
            boolean bl = false;
            Object object = it.readObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type ch.qos.logback.classic.spi.LoggingEventVO");
            LoggingEventVO loggingEventVO = (LoggingEventVO)object;
            return loggingEventVO;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

