/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.linux;

import java.lang.foreign.MemorySegment;
import net.codecrete.usb.UsbException;
import net.codecrete.usb.UsbStallException;
import net.codecrete.usb.linux.Linux;
import net.codecrete.usb.linux.gen.errno.errno;

public class LinuxUsbException
extends UsbException {
    public LinuxUsbException(String message, int errorCode) {
        super(String.format("%s: %s", message, Linux.getErrorMessage(errorCode)), errorCode);
    }

    static void throwException(int errorCode, String message, Object ... args) {
        String formattedMessage = String.format(message, args);
        if (errorCode == errno.EPIPE()) {
            throw new UsbStallException(formattedMessage);
        }
        throw new LinuxUsbException(formattedMessage, errorCode);
    }

    static void throwException(String message, Object ... args) {
        throw new UsbException(String.format(message, args));
    }

    static void throwLastError(MemorySegment errorState, String message, Object ... args) {
        LinuxUsbException.throwException(Linux.getErrno(errorState), message, args);
    }
}

