/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.metrics;

import io.sentry.ILogger;
import io.sentry.JsonSerializable;
import io.sentry.MeasurementUnit;
import io.sentry.ObjectWriter;
import io.sentry.metrics.Metric;
import io.sentry.metrics.MetricType;
import io.sentry.metrics.MetricsHelper;
import io.sentry.protocol.SentryId;
import java.io.IOException;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SentryMetric
implements JsonSerializable {
    private final Iterable<?> values;
    @NotNull
    private final MetricType type;
    @NotNull
    private final SentryId eventId = new SentryId();
    @NotNull
    private final String key;
    @Nullable
    private final MeasurementUnit unit;
    @Nullable
    private final Map<String, String> tags;
    private final long timestampMs;

    public SentryMetric(@NotNull Metric metric) {
        this.type = metric.getType();
        this.key = metric.getKey();
        this.unit = metric.getUnit();
        this.tags = metric.getTags();
        this.timestampMs = metric.getTimeStampMs();
        this.values = metric.serialize();
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        writer.name("type").value(MetricsHelper.toStatsdType(this.type));
        writer.name("event_id").value(logger, this.eventId);
        writer.name("name").value(this.key);
        writer.name("timestamp").value((double)this.timestampMs / 1000.0);
        if (this.unit != null) {
            writer.name("unit").value(this.unit.apiName());
        }
        if (this.tags != null) {
            writer.name("tags");
            writer.beginObject();
            for (Map.Entry entry : this.tags.entrySet()) {
                writer.name((String)entry.getKey()).value((String)entry.getValue());
            }
            writer.endObject();
        }
        writer.name("value");
        writer.beginArray();
        for (Object object : this.values) {
            writer.value(logger, object);
        }
        writer.endArray();
        writer.endObject();
    }

    public static final class JsonKeys {
        public static final String TYPE = "type";
        public static final String EVENT_ID = "event_id";
        public static final String NAME = "name";
        public static final String TIMESTAMP = "timestamp";
        public static final String UNIT = "unit";
        public static final String TAGS = "tags";
        public static final String VALUE = "value";
    }
}

