/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.sharedui.viewmodels;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.merlyn.sharedui.dice.domain.DiceResult;
import org.merlyn.sharedui.utils.BaseViewModelImpl;
import org.merlyn.sharedui.viewmodels.DiceState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012J\u0006\u0010\u0014\u001a\u00020\u0010J \u0010\u0015\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u0017H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lorg/merlyn/sharedui/viewmodels/DiceViewModel;", "Lorg/merlyn/sharedui/utils/BaseViewModelImpl;", "viewModelScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "logger", "Lmu/KLogger;", "_diceState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lorg/merlyn/sharedui/viewmodels/DiceState;", "diceState", "Lkotlinx/coroutines/flow/StateFlow;", "getDiceState", "()Lkotlinx/coroutines/flow/StateFlow;", "showDice", "", "diceResults", "", "Lorg/merlyn/sharedui/dice/domain/DiceResult;", "hideDice", "ifCanRepresent", "block", "Lkotlin/Function0;", "sharedui"})
@SourceDebugExtension(value={"SMAP\nDiceViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiceViewModel.kt\norg/merlyn/sharedui/viewmodels/DiceViewModel\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,39:1\n230#2,5:40\n230#2,5:48\n1740#3,3:45\n*S KotlinDebug\n*F\n+ 1 DiceViewModel.kt\norg/merlyn/sharedui/viewmodels/DiceViewModel\n*L\n28#1:40,5\n23#1:48,5\n32#1:45,3\n*E\n"})
public final class DiceViewModel
extends BaseViewModelImpl {
    @NotNull
    private final KLogger logger;
    @NotNull
    private final MutableStateFlow<DiceState> _diceState;
    @NotNull
    private final StateFlow<DiceState> diceState;

    public DiceViewModel(@NotNull CoroutineScope viewModelScope) {
        Intrinsics.checkNotNullParameter((Object)viewModelScope, (String)"viewModelScope");
        super(viewModelScope);
        this.logger = KotlinLogging.INSTANCE.logger(DiceViewModel::logger$lambda$0);
        this._diceState = StateFlowKt.MutableStateFlow((Object)new DiceState(false, CollectionsKt.emptyList()));
        this.diceState = FlowKt.asStateFlow(this._diceState);
    }

    @NotNull
    public final StateFlow<DiceState> getDiceState() {
        return this.diceState;
    }

    public final void showDice(@NotNull List<DiceResult> diceResults) {
        Intrinsics.checkNotNullParameter(diceResults, (String)"diceResults");
        this.ifCanRepresent(diceResults, (Function0<Unit>)((Function0)() -> DiceViewModel.showDice$lambda$0(this, diceResults)));
    }

    public final void hideDice() {
        DiceState it;
        DiceState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<DiceState> $this$update$iv = this._diceState;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (DiceState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = it.copy(false, CollectionsKt.emptyList()))));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void ifCanRepresent(List<DiceResult> $this$ifCanRepresent, Function0<Unit> block) {
        if (!((Collection)$this$ifCanRepresent).isEmpty() && $this$ifCanRepresent.size() <= 10) {
            boolean bl;
            block5: {
                Iterable $this$all$iv = $this$ifCanRepresent;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        DiceResult it = (DiceResult)element$iv;
                        boolean bl2 = false;
                        if (it.getSides() == 6) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (bl) {
                block.invoke();
                return;
            }
        }
        this.logger.warn(() -> DiceViewModel.ifCanRepresent$lambda$1($this$ifCanRepresent));
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit showDice$lambda$0(DiceViewModel this$0, List $diceResults) {
        DiceState it;
        DiceState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<DiceState> $this$update$iv = this$0._diceState;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (DiceState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = it.copy(true, $diceResults))));
        return Unit.INSTANCE;
    }

    private static final Object ifCanRepresent$lambda$1(List $this_ifCanRepresent) {
        return "Ignoring dice results that cannot be represented: " + $this_ifCanRepresent;
    }
}

