/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.server.application.ApplicationEnvironment;
import io.ktor.server.config.ApplicationConfig;
import io.ktor.server.config.MapApplicationConfig;
import io.ktor.server.engine.ApplicationEngineEnvironmentBuilder;
import io.ktor.server.engine.CommandLineKt;
import io.ktor.server.engine.ConfigKeys;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineSSLConnectorBuilder;
import io.ktor.util.CharsetKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\t\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\u001f\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0000\u00a2\u0006\u0002\u0010\b\u001aB\u0010\t\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0007H\u0000\u00a8\u0006\u0010"}, d2={"getConfigFromEnvironment", "Lio/ktor/server/config/ApplicationConfig;", "configurePlatformProperties", "", "Lio/ktor/server/engine/ApplicationEngineEnvironmentBuilder;", "args", "", "", "(Lio/ktor/server/engine/ApplicationEngineEnvironmentBuilder;[Ljava/lang/String;)V", "configureSSLConnectors", "host", "sslPort", "sslKeyStorePath", "sslKeyStorePassword", "sslPrivateKeyPassword", "sslKeyAlias", "ktor-server-host-common"})
public final class EnvironmentUtilsJvmKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void configureSSLConnectors(@NotNull ApplicationEngineEnvironmentBuilder $this$configureSSLConnectors, @NotNull String host, @NotNull String sslPort, @Nullable String sslKeyStorePath, @Nullable String sslKeyStorePassword, @Nullable String sslPrivateKeyPassword, @NotNull String sslKeyAlias) {
        void $this$configureSSLConnectors_u24lambda_u244;
        void $this$sslConnector$iv;
        void keyStorePassword$iv;
        void keyStore$iv;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$configureSSLConnectors, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)sslPort, (String)"sslPort");
        Intrinsics.checkNotNullParameter((Object)sslKeyAlias, (String)"sslKeyAlias");
        if (sslKeyStorePath == null) {
            throw new IllegalArgumentException("SSL requires keystore: use -sslKeyStore=path or " + ConfigKeys.INSTANCE.getHostSslKeyStore() + " config");
        }
        if (sslKeyStorePassword == null) {
            throw new IllegalArgumentException("SSL requires keystore password: use " + ConfigKeys.INSTANCE.getHostSslKeyStorePassword() + " config");
        }
        if (sslPrivateKeyPassword == null) {
            throw new IllegalArgumentException("SSL requires certificate password: use " + ConfigKeys.INSTANCE.getHostSslPrivateKeyPassword() + " config");
        }
        Object file = new File(sslKeyStorePath);
        boolean bl = false;
        File keyStoreFile = ((File)file).exists() || ((File)file).isAbsolute() ? file : new File(".", sslKeyStorePath).getAbsoluteFile();
        Object $this$configureSSLConnectors_u24lambda_u243 = file = KeyStore.getInstance("JKS");
        boolean $i$a$-apply-EnvironmentUtilsJvmKt$configureSSLConnectors$keyStore$22 = false;
        Closeable closeable = new FileInputStream(keyStoreFile);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)closeable;
            boolean bl2 = false;
            ((KeyStore)$this$configureSSLConnectors_u24lambda_u243).load(it, CharsetKt.toCharArray((String)sslKeyStorePassword));
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        if (((KeyStore)$this$configureSSLConnectors_u24lambda_u243).getKey(sslKeyAlias, CharsetKt.toCharArray((String)sslPrivateKeyPassword)) == null) {
            boolean $i$a$-requireNotNull-EnvironmentUtilsJvmKt$configureSSLConnectors$keyStore$1$32 = false;
            String $i$a$-requireNotNull-EnvironmentUtilsJvmKt$configureSSLConnectors$keyStore$1$32 = "The specified key " + sslKeyAlias + " doesn't exist in the key store " + sslKeyStorePath;
            throw new IllegalArgumentException($i$a$-requireNotNull-EnvironmentUtilsJvmKt$configureSSLConnectors$keyStore$1$32.toString());
        }
        Object keyStore = file;
        file = $this$configureSSLConnectors;
        Intrinsics.checkNotNullExpressionValue((Object)keyStore, (String)"keyStore");
        $this$configureSSLConnectors_u24lambda_u243 = keyStore;
        Function0 $i$a$-apply-EnvironmentUtilsJvmKt$configureSSLConnectors$keyStore$22 = (Function0)new Function0<char[]>(sslKeyStorePassword){
            final /* synthetic */ String $sslKeyStorePassword;
            {
                this.$sslKeyStorePassword = $sslKeyStorePassword;
                super(0);
            }

            @NotNull
            public final char[] invoke() {
                return CharsetKt.toCharArray((String)this.$sslKeyStorePassword);
            }
        };
        Function0 privateKeyPassword$iv = (Function0)new Function0<char[]>(sslPrivateKeyPassword){
            final /* synthetic */ String $sslPrivateKeyPassword;
            {
                this.$sslPrivateKeyPassword = $sslPrivateKeyPassword;
                super(0);
            }

            @NotNull
            public final char[] invoke() {
                return CharsetKt.toCharArray((String)this.$sslPrivateKeyPassword);
            }
        };
        boolean $i$f$sslConnector = false;
        Object bl2 = object = new EngineSSLConnectorBuilder((KeyStore)keyStore$iv, sslKeyAlias, (Function0<char[]>)keyStorePassword$iv, (Function0<char[]>)privateKeyPassword$iv);
        List<EngineConnectorConfig> list = $this$sslConnector$iv.getConnectors();
        boolean bl3 = false;
        $this$configureSSLConnectors_u24lambda_u244.setHost(host);
        $this$configureSSLConnectors_u24lambda_u244.setPort(Integer.parseInt(sslPort));
        $this$configureSSLConnectors_u24lambda_u244.setKeyStorePath(keyStoreFile);
        list.add((EngineConnectorConfig)object);
    }

    /*
     * WARNING - void declaration
     */
    public static final void configurePlatformProperties(@NotNull ApplicationEngineEnvironmentBuilder $this$configurePlatformProperties, @NotNull String[] args) {
        ClassLoader classLoader;
        URL uRL;
        String it;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$configurePlatformProperties, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String[] $this$mapNotNull$iv = args;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Pair<String, String> it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it2 = element$iv$iv;
            boolean bl2 = false;
            if (CommandLineKt.splitPair((String)it2, '=') == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map argumentsPairs = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        String string = (String)argumentsPairs.get("-jar");
        if (string != null) {
            it = string;
            boolean bl = false;
            uRL = StringsKt.startsWith$default((String)it, (String)"file:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"jrt:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)it, (String)"jar:", (boolean)false, (int)2, null) ? new URI(it).toURL() : new File(it).toURI().toURL();
        } else {
            uRL = null;
        }
        URL jar = uRL;
        ApplicationEngineEnvironmentBuilder applicationEngineEnvironmentBuilder = $this$configurePlatformProperties;
        URL uRL2 = jar;
        if (uRL2 != null) {
            it = uRL2;
            ApplicationEngineEnvironmentBuilder applicationEngineEnvironmentBuilder2 = applicationEngineEnvironmentBuilder;
            boolean bl = false;
            URL[] uRLArray = new URL[]{jar};
            applicationEngineEnvironmentBuilder = applicationEngineEnvironmentBuilder2;
            classLoader = new URLClassLoader(uRLArray, ApplicationEnvironment.class.getClassLoader());
        } else {
            ClassLoader classLoader2 = ApplicationEnvironment.class.getClassLoader();
            classLoader = classLoader2;
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"ApplicationEnvironment::class.java.classLoader");
        }
        applicationEngineEnvironmentBuilder.setClassLoader(classLoader);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ApplicationConfig getConfigFromEnvironment() {
        void $this$mapTo$iv$iv;
        Properties properties = System.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getProperties()");
        Map $this$filterKeys$iv = MapsKt.toMap((Map)properties);
        boolean $i$f$filterKeys = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterKeys$iv.entrySet()) {
            Object it = entry$iv.getKey();
            boolean bl = false;
            Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type kotlin.String");
            if (!StringsKt.startsWith$default((String)((String)it), (String)"ktor.", (boolean)false, (int)2, null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map env = result$iv;
        boolean bl = false;
        Map $this$map$iv = env;
        boolean $i$f$map = false;
        Map map = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            Object k = it.getKey();
            Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type kotlin.String");
            String string = (String)k;
            Object v = it.getValue();
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type kotlin.String");
            collection.add(TuplesKt.to((Object)string, (Object)((String)v)));
        }
        List list = (List)destination$iv$iv;
        return (ApplicationConfig)new MapApplicationConfig(list);
    }
}

