/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.checker;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.diagnostics.Checker;
import org.merlyn.diagnostics.CheckerKt;
import org.merlyn.diagnostics.models.CheckResult;
import org.merlyn.diagnostics.models.CheckerConfig;
import org.merlyn.diagnostics.models.CheckerMessages;
import org.merlyn.diagnostics.models.Help;
import org.merlyn.sharedui.viewmodels.usecases.ObserveBrowserExtensionConnectionStateUseCase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/merlyn/desktopapp/checker/ChromeExtensionChecker;", "Lorg/merlyn/diagnostics/Checker;", "beUseCase", "Lorg/merlyn/sharedui/viewmodels/usecases/ObserveBrowserExtensionConnectionStateUseCase;", "<init>", "(Lorg/merlyn/sharedui/viewmodels/usecases/ObserveBrowserExtensionConnectionStateUseCase;)V", "check", "Lorg/merlyn/diagnostics/models/CheckResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "configuration", "Lorg/merlyn/diagnostics/models/CheckerConfig;", "app"})
@SourceDebugExtension(value={"SMAP\nChromeExtensionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChromeExtensionChecker.kt\norg/merlyn/desktopapp/checker/ChromeExtensionChecker\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n*L\n1#1,45:1\n28#2,4:46\n*S KotlinDebug\n*F\n+ 1 ChromeExtensionChecker.kt\norg/merlyn/desktopapp/checker/ChromeExtensionChecker\n*L\n37#1:46,4\n*E\n"})
public final class ChromeExtensionChecker
implements Checker {
    @NotNull
    private final ObserveBrowserExtensionConnectionStateUseCase beUseCase;

    public ChromeExtensionChecker(@NotNull ObserveBrowserExtensionConnectionStateUseCase beUseCase) {
        Intrinsics.checkNotNullParameter((Object)beUseCase, (String)"beUseCase");
        this.beUseCase = beUseCase;
    }

    @Nullable
    public Object check(@NotNull Continuation<? super CheckResult> $completion) {
        boolean connected = (Boolean)this.beUseCase.isBrowserExtensionConnected().getValue();
        return new CheckResult(connected, 0, CollectionsKt.listOf((Object)("Chrome extension is installed: " + CheckerKt.yesOrNo((boolean)connected))));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public CheckerConfig configuration() {
        void $this$configuration_u24lambda_u240;
        JsonObjectBuilder builder$iv;
        List list = CollectionsKt.listOf((Object)"You do not have the Chrome Extension installed, or your browser is not running");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        String string = "link";
        CheckerMessages checkerMessages = new CheckerMessages("You have the Chrome Extension installed", list, "Checking whether you have the Chrome Extension installed");
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$configuration_u24lambda_u240, (String)"url", (String)"https://chromewebstore.google.com/detail/merlyn-origin/koiilkfnbjkhlndkjleoakofehahjljb");
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$configuration_u24lambda_u240, (String)"title", (String)"Install the Google Chrome Extension");
        Unit unit = Unit.INSTANCE;
        JsonObject jsonObject = builder$iv.build();
        String string2 = string;
        List list2 = CollectionsKt.listOf((Object)new Help(string2, jsonObject));
        CheckerMessages checkerMessages2 = checkerMessages;
        return new CheckerConfig(checkerMessages2, list2);
    }
}

