/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.log;

import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RolloverFailure;
import ch.qos.logback.core.rolling.helper.FileNamePattern;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.java.KoinJavaComponent;
import org.merlyn.desktopapp.config.StageConfig;
import org.merlyn.desktopapp.device.GetDeviceId;
import org.merlyn.desktopapp.http.CognitoHelper;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/merlyn/desktopapp/log/DesktopAppCrashAppenderRollingPolicy;", "Lch/qos/logback/core/rolling/FixedWindowRollingPolicy;", "<init>", "()V", "suffixForBucket", "", "getSuffixForBucket", "()Ljava/lang/String;", "start", "", "rollover", "getDeviceId", "app"})
@SourceDebugExtension(value={"SMAP\nDesktopAppCrashAppenderRollingPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopAppCrashAppenderRollingPolicy.kt\norg/merlyn/desktopapp/log/DesktopAppCrashAppenderRollingPolicy\n+ 2 Koin.kt\norg/koin/core/Koin\n+ 3 Scope.kt\norg/koin/core/scope/Scope\n*L\n1#1,79:1\n105#2,4:80\n105#2,4:85\n105#2,4:90\n136#3:84\n136#3:89\n136#3:94\n*S KotlinDebug\n*F\n+ 1 DesktopAppCrashAppenderRollingPolicy.kt\norg/merlyn/desktopapp/log/DesktopAppCrashAppenderRollingPolicy\n*L\n38#1:80,4\n39#1:85,4\n77#1:90,4\n38#1:84\n39#1:89\n77#1:94\n*E\n"})
public final class DesktopAppCrashAppenderRollingPolicy
extends FixedWindowRollingPolicy {
    @NotNull
    private final String suffixForBucket;

    public DesktopAppCrashAppenderRollingPolicy() {
        this.suffixForBucket = ".log.zip";
    }

    @NotNull
    public final String getSuffixForBucket() {
        return this.suffixForBucket;
    }

    public void start() {
        super.start();
        super.rollover();
    }

    public void rollover() {
        boolean uploadFileToS3 = new File(this.getActiveFileName()).length() > 0L;
        super.rollover();
        if (uploadFileToS3) {
            Object object;
            Object object2 = this;
            try {
                DesktopAppCrashAppenderRollingPolicy $this$rollover_u24lambda_u240 = object2;
                boolean bl = false;
                Koin $this$iv = KoinJavaComponent.getKoin();
                Qualifier qualifier$iv = null;
                Function0 parameters$iv = null;
                boolean $i$f$get = false;
                Scope this_$iv$iv = $this$iv.getScopeRegistry().getRootScope();
                boolean $i$f$get2 = false;
                CognitoHelper cognitoHelper = (CognitoHelper)this_$iv$iv.get(Reflection.getOrCreateKotlinClass(CognitoHelper.class), qualifier$iv, parameters$iv);
                Koin $this$iv2 = KoinJavaComponent.getKoin();
                Qualifier qualifier$iv2 = null;
                Function0 parameters$iv2 = null;
                boolean $i$f$get3 = false;
                Scope this_$iv$iv2 = $this$iv2.getScopeRegistry().getRootScope();
                boolean $i$f$get4 = false;
                StageConfig config = (StageConfig)this_$iv$iv2.get(Reflection.getOrCreateKotlinClass(StageConfig.class), qualifier$iv2, parameters$iv2);
                String deviceId = $this$rollover_u24lambda_u240.getDeviceId();
                org.merlyn.desktopapp.http.AwsCredentials credentials = cognitoHelper.getSTSCredentialsNotLoggedAccess();
                String fileNameInS3 = "errors-" + deviceId + "-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")) + $this$rollover_u24lambda_u240.suffixForBucket;
                File fileToStore = new File(new FileNamePattern(this.fileNamePatternStr, this.context).convertInt($this$rollover_u24lambda_u240.getMinIndex()));
                S3Client s3 = (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(Region.of((String)config.getEnvironmentConfig().getRegion()))).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)((AwsCredentials)AwsSessionCredentials.create((String)credentials.getAccessKeyId(), (String)credentials.getSecretAccessKey(), (String)credentials.getSessionToken()))))).build();
                PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(config.getEnvironmentConfig().getS3BucketForErrors()).key(fileNameInS3).build();
                object = Result.constructor-impl((Object)s3.putObject(putObjectRequest, RequestBody.fromFile((File)fileToStore)));
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it = object = throwable;
                boolean bl = false;
                throw new RolloverFailure("Error trying to upload error file to AWS: " + ((Throwable)it).getMessage(), (Throwable)it);
            }
        }
    }

    private final String getDeviceId() {
        Koin $this$iv = KoinJavaComponent.getKoin();
        Qualifier qualifier$iv = null;
        Function0 parameters$iv = null;
        boolean $i$f$get = false;
        Scope this_$iv$iv = $this$iv.getScopeRegistry().getRootScope();
        boolean $i$f$get2 = false;
        return ((GetDeviceId)this_$iv$iv.get(Reflection.getOrCreateKotlinClass(GetDeviceId.class), qualifier$iv, parameters$iv)).invoke();
    }
}

