/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.log;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tJ>\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0018H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/merlyn/desktopapp/log/LogsDirectoryPackager;", "", "logsDirectoryPath", "", "crashDirectoryPath", "driverLogsFileNamePath", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "logsDirectory", "Ljava/io/File;", "crashDirectory", "driverLogsFile", "crashFilenameRegex", "Lkotlin/text/Regex;", "zipLogs", "", "zipFile", "compressDirectory", "prefix", "currentFile", "baseFile", "zipOutputStream", "Ljava/util/zip/ZipOutputStream;", "filenameMatcher", "Lkotlin/Function1;", "", "app"})
@SourceDebugExtension(value={"SMAP\nLogsDirectoryPackager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogsDirectoryPackager.kt\norg/merlyn/desktopapp/log/LogsDirectoryPackager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
public final class LogsDirectoryPackager {
    @NotNull
    private final File logsDirectory;
    @Nullable
    private final File crashDirectory;
    @Nullable
    private final File driverLogsFile;
    @NotNull
    private final Regex crashFilenameRegex;

    public LogsDirectoryPackager(@NotNull String logsDirectoryPath, @Nullable String crashDirectoryPath, @Nullable String driverLogsFileNamePath) {
        File file;
        File file2;
        String it;
        LogsDirectoryPackager logsDirectoryPackager;
        Intrinsics.checkNotNullParameter((Object)logsDirectoryPath, (String)"logsDirectoryPath");
        this.logsDirectory = new File(logsDirectoryPath);
        LogsDirectoryPackager logsDirectoryPackager2 = this;
        String string = crashDirectoryPath;
        if (string != null) {
            String string2 = string;
            logsDirectoryPackager = logsDirectoryPackager2;
            boolean bl = false;
            file2 = new File(it);
            logsDirectoryPackager2 = logsDirectoryPackager;
        } else {
            file2 = null;
        }
        logsDirectoryPackager2.crashDirectory = file2;
        LogsDirectoryPackager logsDirectoryPackager3 = this;
        String string3 = driverLogsFileNamePath;
        if (string3 != null) {
            it = string3;
            logsDirectoryPackager = logsDirectoryPackager3;
            boolean bl = false;
            file = new File(it);
            logsDirectoryPackager3 = logsDirectoryPackager;
        } else {
            file = null;
        }
        logsDirectoryPackager3.driverLogsFile = file;
        this.crashFilenameRegex = new Regex("(?:Merlyn Origin|mm[ -]desktop).*.ips", RegexOption.IGNORE_CASE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zipLogs(@NotNull File zipFile) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Closeable closeable = new ZipOutputStream(new FileOutputStream(zipFile));
        Throwable throwable = null;
        try {
            Unit unit;
            ZipOutputStream zipOutputStream = (ZipOutputStream)closeable;
            boolean bl = false;
            LogsDirectoryPackager.compressDirectory$default(this, "logs", this.logsDirectory, this.logsDirectory, zipOutputStream, null, 16, null);
            File file = this.crashDirectory;
            if (file != null) {
                File crashDirectory = file;
                boolean bl2 = false;
                this.compressDirectory("crashes", crashDirectory, crashDirectory, zipOutputStream, (Function1<? super String, Boolean>)((Function1)arg_0 -> LogsDirectoryPackager.zipLogs$lambda$0$0$0(this, arg_0)));
            }
            File file2 = this.driverLogsFile;
            if (file2 != null) {
                File driverLogsFile = file2;
                boolean bl3 = false;
                File file3 = driverLogsFile.getParentFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getParentFile(...)");
                LogsDirectoryPackager.compressDirectory$default(this, "driverlogs", driverLogsFile, file3, zipOutputStream, null, 16, null);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            Unit unit2 = unit;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void compressDirectory(String prefix, File currentFile, File baseFile, ZipOutputStream zipOutputStream, Function1<? super String, Boolean> filenameMatcher) {
        if (!currentFile.exists()) {
            return;
        }
        if (currentFile.isDirectory()) {
            File[] fileArray = currentFile.listFiles();
            if (fileArray == null) {
                fileArray = new File[]{};
            }
            for (File file : fileArray) {
                Intrinsics.checkNotNull((Object)file);
                this.compressDirectory(prefix, file, baseFile, zipOutputStream, filenameMatcher);
            }
        } else {
            String string = currentFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (((Boolean)filenameMatcher.invoke((Object)string)).booleanValue()) {
                FileInputStream fileInputStream = new FileInputStream(currentFile);
                String string2 = FilesKt.relativeTo((File)currentFile, (File)baseFile).getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                String entryName = prefix + "/" + StringsKt.replace$default((String)string2, (String)"\\", (String)"/", (boolean)false, (int)4, null);
                ZipEntry zipEntry = new ZipEntry(entryName);
                zipOutputStream.putNextEntry(zipEntry);
                Closeable closeable = fileInputStream;
                Throwable throwable = null;
                try {
                    FileInputStream it = (FileInputStream)closeable;
                    boolean bl = false;
                    long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)zipOutputStream, (int)0, (int)2, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                zipOutputStream.closeEntry();
            }
        }
    }

    static /* synthetic */ void compressDirectory$default(LogsDirectoryPackager logsDirectoryPackager, String string, File file, File file2, ZipOutputStream zipOutputStream, Function1 function1, int n, Object object) {
        if ((n & 0x10) != 0) {
            function1 = LogsDirectoryPackager::compressDirectory$lambda$0;
        }
        logsDirectoryPackager.compressDirectory(string, file, file2, zipOutputStream, (Function1<? super String, Boolean>)function1);
    }

    private static final boolean zipLogs$lambda$0$0$0(LogsDirectoryPackager this$0, String filename) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        return this$0.crashFilenameRegex.matchEntire((CharSequence)filename) != null;
    }

    private static final boolean compressDirectory$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

