/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.log.layout;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import net.logstash.logback.marker.RawJsonAppendingMarker;
import org.jetbrains.annotations.NotNull;
import org.merlyn.core.ClientCore;
import org.merlyn.core.ClientCoreKt;
import org.merlyn.core.Connected;
import org.merlyn.core.ConnectionState;
import org.merlyn.core.Idle;
import org.merlyn.desktopapp.config.StageConfig;
import org.merlyn.desktopapp.coresdk.JWTToken;
import org.merlyn.desktopapp.log.layout.EventLayout;
import org.merlyn.desktopapp.log.layout.LogDefinitionsKt;
import org.merlyn.desktopapp.os.HostOS;
import org.merlyn.desktopapp.storage.DeviceDataDao;
import org.merlyn.sharedui.viewmodels.usecases.ObserveLoginStateUseCase;
import org.slf4j.Marker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u0016\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/merlyn/desktopapp/log/layout/AppLogLayout;", "Lorg/merlyn/desktopapp/log/layout/EventLayout;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "clientCore", "Lorg/merlyn/core/ClientCore;", "loginState", "Lorg/merlyn/sharedui/viewmodels/usecases/ObserveLoginStateUseCase;", "stageConfig", "Lorg/merlyn/desktopapp/config/StageConfig;", "deviceDataDao", "Lorg/merlyn/desktopapp/storage/DeviceDataDao;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lorg/merlyn/core/ClientCore;Lorg/merlyn/sharedui/viewmodels/usecases/ObserveLoginStateUseCase;Lorg/merlyn/desktopapp/config/StageConfig;Lorg/merlyn/desktopapp/storage/DeviceDataDao;)V", "token", "Lkotlinx/coroutines/flow/StateFlow;", "", "isConnected", "", "connectionState", "Lorg/merlyn/core/ConnectionState;", "appVersion", "Lkotlinx/serialization/json/JsonElement;", "deviceId", "getEventAsJson", "event", "Lch/qos/logback/classic/spi/ILoggingEvent;", "addMarkers", "", "builder", "Lkotlinx/serialization/json/JsonObjectBuilder;", "app"})
@SourceDebugExtension(value={"SMAP\nAppLogLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLogLayout.kt\norg/merlyn/desktopapp/log/layout/AppLogLayout\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 Iterators.kt\nkotlin/collections/CollectionsKt__IteratorsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,109:1\n28#2,3:110\n31#2:117\n11561#3:113\n11896#3,3:114\n32#4:118\n33#4:120\n1#5:119\n216#6,2:121\n*S KotlinDebug\n*F\n+ 1 AppLogLayout.kt\norg/merlyn/desktopapp/log/layout/AppLogLayout\n*L\n37#1:110,3\n37#1:117\n52#1:113\n52#1:114,3\n102#1:118\n102#1:120\n89#1:121,2\n*E\n"})
public final class AppLogLayout
implements EventLayout {
    @NotNull
    private final StateFlow<String> token;
    @NotNull
    private final StateFlow<Boolean> isConnected;
    @NotNull
    private final StateFlow<ConnectionState> connectionState;
    @NotNull
    private final JsonElement appVersion;
    @NotNull
    private final JsonElement deviceId;

    public AppLogLayout(@NotNull CoroutineScope coroutineScope, @NotNull ClientCore clientCore2, @NotNull ObserveLoginStateUseCase loginState, @NotNull StageConfig stageConfig, @NotNull DeviceDataDao deviceDataDao) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)clientCore2, (String)"clientCore");
        Intrinsics.checkNotNullParameter((Object)loginState, (String)"loginState");
        Intrinsics.checkNotNullParameter((Object)stageConfig, (String)"stageConfig");
        Intrinsics.checkNotNullParameter((Object)deviceDataDao, (String)"deviceDataDao");
        this.token = FlowKt.stateIn((Flow)((Flow)loginState.getAccessToken()), (CoroutineScope)coroutineScope, (SharingStarted)SharingStarted.Companion.getEagerly(), null);
        this.isConnected = FlowKt.stateIn((Flow)ClientCoreKt.isConnected((ClientCore)clientCore2), (CoroutineScope)coroutineScope, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)false);
        this.connectionState = FlowKt.stateIn((Flow)((Flow)clientCore2.getConnectionState()), (CoroutineScope)coroutineScope, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)Idle.INSTANCE);
        this.appVersion = LogDefinitionsKt.toJsonElement(stageConfig.getApplicationConfig().getAppVersion());
        this.deviceId = LogDefinitionsKt.toJsonElement(deviceDataDao.get().getDeviceId());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getEventAsJson(@NotNull ILoggingEvent event) {
        JsonObjectBuilder builder$iv;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder $this$getEventAsJson_u24lambda_u240 = builder$iv = new JsonObjectBuilder();
        boolean bl = false;
        $this$getEventAsJson_u24lambda_u240.put("uuid", LogDefinitionsKt.toJsonElement(UUID.randomUUID().toString()));
        $this$getEventAsJson_u24lambda_u240.put("timestamp", LogDefinitionsKt.toJsonElement(event.getTimeStamp()));
        $this$getEventAsJson_u24lambda_u240.put("message", LogDefinitionsKt.toJsonElement(event.getFormattedMessage()));
        $this$getEventAsJson_u24lambda_u240.put("thread", LogDefinitionsKt.toJsonElement(event.getThreadName()));
        $this$getEventAsJson_u24lambda_u240.put("logger", LogDefinitionsKt.toJsonElement(event.getLoggerName()));
        $this$getEventAsJson_u24lambda_u240.put("level", LogDefinitionsKt.toJsonElement(event.getLevel().toString()));
        IThrowableProxy iThrowableProxy = event.getThrowableProxy();
        if (iThrowableProxy != null) {
            Collection<String> collection;
            IThrowableProxy it = iThrowableProxy;
            boolean bl2 = false;
            JsonObjectBuilder jsonObjectBuilder = $this$getEventAsJson_u24lambda_u240;
            String string = "error";
            Pair[] pairArray = new Pair[3];
            pairArray[0] = TuplesKt.to((Object)"cause", (Object)it.getClassName());
            pairArray[1] = TuplesKt.to((Object)"message", (Object)it.getMessage());
            Pair[] pairArray2 = pairArray;
            int n = 2;
            String string2 = "stacktrace";
            StackTraceElementProxy[] stackTraceElementProxyArray = it.getStackTraceElementProxyArray();
            if (stackTraceElementProxyArray != null) {
                Collection<String> collection2;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                StackTraceElementProxy[] stackTraceElementProxyArray2 = stackTraceElementProxyArray;
                String string3 = string2;
                int n2 = n;
                Pair[] pairArray3 = pairArray2;
                String string4 = string;
                JsonObjectBuilder jsonObjectBuilder2 = jsonObjectBuilder;
                boolean $i$f$map = false;
                void var17_16 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                int n3 = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n3; ++i) {
                    void s;
                    void item$iv$iv;
                    void var23_22 = item$iv$iv = $this$mapTo$iv$iv[i];
                    collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    collection2.add(s.toString());
                }
                collection2 = (List)destination$iv$iv;
                jsonObjectBuilder = jsonObjectBuilder2;
                string = string4;
                pairArray2 = pairArray3;
                n = n2;
                string2 = string3;
                collection = collection2;
            } else {
                collection = null;
            }
            pairArray2[n] = TuplesKt.to((Object)string2, collection);
            jsonObjectBuilder.put(string, LogDefinitionsKt.toJsonElement(MapsKt.mapOf((Pair[])pairArray)));
        }
        this.addMarkers($this$getEventAsJson_u24lambda_u240, event);
        JsonElementBuildersKt.putJsonObject((JsonObjectBuilder)$this$getEventAsJson_u24lambda_u240, (String)"context", arg_0 -> AppLogLayout.getEventAsJson$lambda$0$1(this, event, arg_0));
        JsonObject formattedEvent = builder$iv.build();
        return formattedEvent + "\n";
    }

    private final void addMarkers(JsonObjectBuilder builder, ILoggingEvent event) {
        JsonElement markers = LogDefinitionsKt.getMarkers(event);
        if (markers != null) {
            Iterator $this$forEach$iv = event.getMarkerList().iterator();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv;
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                Marker marker = (Marker)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)marker, (String)"null cannot be cast to non-null type net.logstash.logback.marker.RawJsonAppendingMarker");
                String fieldName = ((RawJsonAppendingMarker)marker).getFieldName();
                if ((JsonElement)JsonElementKt.getJsonObject((JsonElement)markers).get((Object)fieldName) != null) {
                    JsonElement it;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)fieldName);
                    builder.put(fieldName, it);
                }
            }
        }
    }

    private static final Unit getEventAsJson$lambda$0$1(AppLogLayout this$0, ILoggingEvent $event, JsonObjectBuilder $this$putJsonObject) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$putJsonObject, (String)"$this$putJsonObject");
            $this$putJsonObject.put("platform", LogDefinitionsKt.toJsonElement(HostOS.INSTANCE.getHostOs().name()));
            $this$putJsonObject.put("appVersion", this$0.appVersion);
            $this$putJsonObject.put("deviceId", this$0.deviceId);
            String userId = null;
            String userSubId = null;
            String string = (String)this$0.token.getValue();
            if (string != null) {
                String it = string;
                boolean bl = false;
                JWTToken jwt = new JWTToken(it);
                userId = LogDefinitionsKt.getUserId(jwt);
                userSubId = jwt.getSubject();
            }
            $this$putJsonObject.put("userId", LogDefinitionsKt.toJsonElement(userId));
            $this$putJsonObject.put("userSubId", LogDefinitionsKt.toJsonElement(userSubId));
            $this$putJsonObject.put("connectionState", (Boolean)this$0.isConnected.getValue() != false ? LogDefinitionsKt.toJsonElement("Connected") : LogDefinitionsKt.toJsonElement("Disconnected"));
            ConnectionState connectionStateValue = (ConnectionState)this$0.connectionState.getValue();
            $this$putJsonObject.put("spaceId", connectionStateValue instanceof Connected ? LogDefinitionsKt.toJsonElement(((Connected)connectionStateValue).getSpaceId()) : LogDefinitionsKt.toJsonElement("null"));
            Map map2 = $event.getMDCPropertyMap();
            if (map2 == null) break block2;
            Map $this$forEach$iv = map2;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                Object k = entry.getKey();
                Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
                $this$putJsonObject.put((String)k, LogDefinitionsKt.toJsonElement(entry.getValue()));
            }
        }
        return Unit.INSTANCE;
    }
}

