/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.ptt;

import java.io.File;
import java.io.FileOutputStream;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.merlyn.desktopapp.ptt.SpeechListener;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007H\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\tH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/merlyn/desktopapp/ptt/AudioStoreSpeechListener;", "Lorg/merlyn/desktopapp/ptt/SpeechListener;", "basePath", "", "<init>", "(Ljava/lang/String;)V", "audio", "", "onAudioReceived", "", "content", "onCancelled", "onError", "onUnPressed", "saveAudioToLocalFile", "app"})
public final class AudioStoreSpeechListener
implements SpeechListener {
    @NotNull
    private final String basePath;
    @NotNull
    private byte[] audio;

    public AudioStoreSpeechListener(@NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        this.basePath = basePath;
        this.audio = new byte[0];
    }

    @Override
    public void onAudioReceived(@NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.audio = ArraysKt.plus((byte[])this.audio, (byte[])content);
    }

    @Override
    public void onCancelled() {
        if (!(this.audio.length == 0)) {
            this.saveAudioToLocalFile();
            this.audio = new byte[0];
        }
    }

    @Override
    public void onError() {
        this.audio = new byte[0];
    }

    @Override
    public void onUnPressed() {
        if (!(this.audio.length == 0)) {
            this.saveAudioToLocalFile();
            this.audio = new byte[0];
        }
    }

    private final void saveAudioToLocalFile() {
        AudioStoreSpeechListener audioStoreSpeechListener = this;
        try {
            AudioStoreSpeechListener $this$saveAudioToLocalFile_u24lambda_u240 = audioStoreSpeechListener;
            boolean bl = false;
            new File($this$saveAudioToLocalFile_u24lambda_u240.basePath).mkdirs();
            FileOutputStream file = new FileOutputStream(new File($this$saveAudioToLocalFile_u24lambda_u240.basePath, Instant.now().getEpochSecond() + ".raw"));
            file.write($this$saveAudioToLocalFile_u24lambda_u240.audio);
            file.close();
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }
}

