/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.service.impl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.merlyn.desktopapp.coresdk.state.CoreSDKStateHandlerKt;
import org.merlyn.desktopapp.http.Diagnostic;
import org.merlyn.desktopapp.service.DiagnosticService;
import org.merlyn.sharedui.viewmodels.usecases.LoginState;
import org.merlyn.sharedui.viewmodels.usecases.ObserveAccessibilityPermissionsUseCase;
import org.merlyn.sharedui.viewmodels.usecases.ObserveBrowserExtensionConnectionStateUseCase;
import org.merlyn.sharedui.viewmodels.usecases.ObserveConnectionStateUseCase;
import org.merlyn.sharedui.viewmodels.usecases.ObserveDongleConnectionStateUseCase;
import org.merlyn.sharedui.viewmodels.usecases.ObserveLoginStateUseCase;
import org.merlyn.sharedui.viewmodels.usecases.ObserveLoginStateUseCaseKt;
import org.merlyn.sharedui.viewmodels.usecases.ObserveMicrophonePermissionsStateUseCase;
import org.merlyn.sharedui.viewmodels.usecases.ObserveWebServerStartedUseCase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/merlyn/desktopapp/service/impl/DiagnosticServiceImpl;", "Lorg/merlyn/desktopapp/service/DiagnosticService;", "observeConnectionStateUseCase", "Lorg/merlyn/sharedui/viewmodels/usecases/ObserveConnectionStateUseCase;", "observeLoginState", "Lorg/merlyn/sharedui/viewmodels/usecases/ObserveLoginStateUseCase;", "observeDongleConnectionStateUseCase", "Lorg/merlyn/sharedui/viewmodels/usecases/ObserveDongleConnectionStateUseCase;", "observeBrowserExtensionConnectionStateUseCase", "Lorg/merlyn/sharedui/viewmodels/usecases/ObserveBrowserExtensionConnectionStateUseCase;", "observeAccessibilityPermissionsUseCase", "Lorg/merlyn/sharedui/viewmodels/usecases/ObserveAccessibilityPermissionsUseCase;", "observeWebServerStartedUseCase", "Lorg/merlyn/sharedui/viewmodels/usecases/ObserveWebServerStartedUseCase;", "observeMicrophonePermissionsStateUseCase", "Lorg/merlyn/sharedui/viewmodels/usecases/ObserveMicrophonePermissionsStateUseCase;", "<init>", "(Lorg/merlyn/sharedui/viewmodels/usecases/ObserveConnectionStateUseCase;Lorg/merlyn/sharedui/viewmodels/usecases/ObserveLoginStateUseCase;Lorg/merlyn/sharedui/viewmodels/usecases/ObserveDongleConnectionStateUseCase;Lorg/merlyn/sharedui/viewmodels/usecases/ObserveBrowserExtensionConnectionStateUseCase;Lorg/merlyn/sharedui/viewmodels/usecases/ObserveAccessibilityPermissionsUseCase;Lorg/merlyn/sharedui/viewmodels/usecases/ObserveWebServerStartedUseCase;Lorg/merlyn/sharedui/viewmodels/usecases/ObserveMicrophonePermissionsStateUseCase;)V", "getDiagnostic", "Lorg/merlyn/desktopapp/http/Diagnostic;", "app"})
public final class DiagnosticServiceImpl
implements DiagnosticService {
    @NotNull
    private final ObserveConnectionStateUseCase observeConnectionStateUseCase;
    @NotNull
    private final ObserveLoginStateUseCase observeLoginState;
    @NotNull
    private final ObserveDongleConnectionStateUseCase observeDongleConnectionStateUseCase;
    @NotNull
    private final ObserveBrowserExtensionConnectionStateUseCase observeBrowserExtensionConnectionStateUseCase;
    @NotNull
    private final ObserveAccessibilityPermissionsUseCase observeAccessibilityPermissionsUseCase;
    @NotNull
    private final ObserveWebServerStartedUseCase observeWebServerStartedUseCase;
    @NotNull
    private final ObserveMicrophonePermissionsStateUseCase observeMicrophonePermissionsStateUseCase;

    public DiagnosticServiceImpl(@NotNull ObserveConnectionStateUseCase observeConnectionStateUseCase, @NotNull ObserveLoginStateUseCase observeLoginState, @NotNull ObserveDongleConnectionStateUseCase observeDongleConnectionStateUseCase, @NotNull ObserveBrowserExtensionConnectionStateUseCase observeBrowserExtensionConnectionStateUseCase, @NotNull ObserveAccessibilityPermissionsUseCase observeAccessibilityPermissionsUseCase, @NotNull ObserveWebServerStartedUseCase observeWebServerStartedUseCase, @NotNull ObserveMicrophonePermissionsStateUseCase observeMicrophonePermissionsStateUseCase) {
        Intrinsics.checkNotNullParameter((Object)observeConnectionStateUseCase, (String)"observeConnectionStateUseCase");
        Intrinsics.checkNotNullParameter((Object)observeLoginState, (String)"observeLoginState");
        Intrinsics.checkNotNullParameter((Object)observeDongleConnectionStateUseCase, (String)"observeDongleConnectionStateUseCase");
        Intrinsics.checkNotNullParameter((Object)observeBrowserExtensionConnectionStateUseCase, (String)"observeBrowserExtensionConnectionStateUseCase");
        Intrinsics.checkNotNullParameter((Object)observeAccessibilityPermissionsUseCase, (String)"observeAccessibilityPermissionsUseCase");
        Intrinsics.checkNotNullParameter((Object)observeWebServerStartedUseCase, (String)"observeWebServerStartedUseCase");
        Intrinsics.checkNotNullParameter((Object)observeMicrophonePermissionsStateUseCase, (String)"observeMicrophonePermissionsStateUseCase");
        this.observeConnectionStateUseCase = observeConnectionStateUseCase;
        this.observeLoginState = observeLoginState;
        this.observeDongleConnectionStateUseCase = observeDongleConnectionStateUseCase;
        this.observeBrowserExtensionConnectionStateUseCase = observeBrowserExtensionConnectionStateUseCase;
        this.observeAccessibilityPermissionsUseCase = observeAccessibilityPermissionsUseCase;
        this.observeWebServerStartedUseCase = observeWebServerStartedUseCase;
        this.observeMicrophonePermissionsStateUseCase = observeMicrophonePermissionsStateUseCase;
    }

    @Override
    @NotNull
    public Diagnostic getDiagnostic() {
        boolean bl = (Boolean)this.observeConnectionStateUseCase.isConnected().getValue();
        boolean bl2 = (Boolean)this.observeBrowserExtensionConnectionStateUseCase.isBrowserExtensionConnected().getValue();
        boolean bl3 = (Boolean)this.observeDongleConnectionStateUseCase.isDongleConnected().getValue();
        boolean bl4 = ObserveLoginStateUseCaseKt.isLoggedIn((LoginState)((LoginState)this.observeLoginState.getLoginState().getValue()));
        boolean bl5 = ObserveLoginStateUseCaseKt.getHasValidLicense((LoginState)((LoginState)this.observeLoginState.getLoginState().getValue()));
        String string = CoreSDKStateHandlerKt.getOrganization((String)this.observeLoginState.getAccessToken().getValue());
        String string2 = ObserveLoginStateUseCaseKt.getEmail((LoginState)((LoginState)this.observeLoginState.getLoginState().getValue()));
        String string3 = (String)this.observeLoginState.getAccessToken().getValue();
        String string4 = string3 != null ? CoreSDKStateHandlerKt.getUserSub(string3) : null;
        boolean bl6 = this.observeWebServerStartedUseCase.getWebServerStatus().getValue() == ObserveWebServerStartedUseCase.Status.Started;
        boolean bl7 = (Boolean)this.observeAccessibilityPermissionsUseCase.getAccessibilityPermissionsAreGranted().getValue();
        boolean bl8 = (Boolean)this.observeMicrophonePermissionsStateUseCase.getHasRecordPermissions().getValue();
        return new Diagnostic(bl, bl2, bl3, bl4, bl5, string4, string2, string, bl7, bl8, bl6);
    }
}

