/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.service.localization.impl;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.service.localization.LocaleFinder;
import org.merlyn.desktopapp.service.localization.LocalizationInitializeService;
import org.merlyn.desktopapp.storage.LocaleDao;
import org.merlyn.desktopapp.storage.RegionDao;
import org.merlyn.sharedui.regionselection.Region;
import org.merlyn.sharedui.res.ImageResources;
import org.merlyn.sharedui.res.Strings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/merlyn/desktopapp/service/localization/impl/LocalizationInitializeServiceImpl;", "Lorg/merlyn/desktopapp/service/localization/LocalizationInitializeService;", "localeDao", "Lorg/merlyn/desktopapp/storage/LocaleDao;", "regionDao", "Lorg/merlyn/desktopapp/storage/RegionDao;", "<init>", "(Lorg/merlyn/desktopapp/storage/LocaleDao;Lorg/merlyn/desktopapp/storage/RegionDao;)V", "getLocaleDao", "()Lorg/merlyn/desktopapp/storage/LocaleDao;", "getRegionDao", "()Lorg/merlyn/desktopapp/storage/RegionDao;", "getRegion", "Lorg/merlyn/sharedui/regionselection/Region;", "setRegionAndLocale", "", "newRegion", "setLocaleForResources", "locale", "Ljava/util/Locale;", "app"})
public class LocalizationInitializeServiceImpl
implements LocalizationInitializeService {
    @NotNull
    private final LocaleDao localeDao;
    @NotNull
    private final RegionDao regionDao;

    public LocalizationInitializeServiceImpl(@NotNull LocaleDao localeDao, @NotNull RegionDao regionDao) {
        Intrinsics.checkNotNullParameter((Object)localeDao, (String)"localeDao");
        Intrinsics.checkNotNullParameter((Object)regionDao, (String)"regionDao");
        this.localeDao = localeDao;
        this.regionDao = regionDao;
    }

    @NotNull
    protected final LocaleDao getLocaleDao() {
        return this.localeDao;
    }

    @NotNull
    protected final RegionDao getRegionDao() {
        return this.regionDao;
    }

    @Override
    @Nullable
    public Region getRegion() {
        return this.regionDao.get();
    }

    @Override
    public void setRegionAndLocale(@NotNull Region newRegion) {
        Intrinsics.checkNotNullParameter((Object)newRegion, (String)"newRegion");
        this.regionDao.update(newRegion);
        String string = this.localeDao.get().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLanguage(...)");
        this.localeDao.update(LocaleFinder.INSTANCE.find(string, newRegion));
    }

    @Override
    public void setLocaleForResources() {
        this.setLocaleForResources(this.localeDao.get());
    }

    protected final void setLocaleForResources(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        ImageResources.INSTANCE.setLocale(locale);
        Strings.INSTANCE.setLocale(locale);
    }
}

