/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.service.localization.impl;

import io.ktor.client.HttpClient;
import io.ktor.client.request.HttpRequestBuilder;
import io.ktor.client.statement.HttpResponse;
import io.ktor.client.statement.HttpStatement;
import io.ktor.http.HttpMethod;
import io.ktor.util.reflect.TypeInfoJvmKt;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.Type;
import java.time.ZoneId;
import java.util.Locale;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.reflect.TypesJVMKt;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.core.spacecontextservice.model.LocalizationContext;
import org.merlyn.desktopapp.http.impl.MerlynRestServicesClient;
import org.merlyn.desktopapp.service.localization.LocaleFinder;
import org.merlyn.desktopapp.service.localization.LocalizationService;
import org.merlyn.desktopapp.service.localization.SettingsData;
import org.merlyn.desktopapp.service.localization.impl.LocalizationInitializeServiceImpl;
import org.merlyn.desktopapp.service.localization.impl.LocalizationServiceImpl;
import org.merlyn.desktopapp.storage.LocaleDao;
import org.merlyn.desktopapp.storage.RegionDao;
import org.merlyn.sharedui.regionselection.Region;
import org.merlyn.sharedui.res.Strings;
import org.merlyn.sharedui.viewmodels.usecases.FeedbackEvent;
import org.merlyn.sharedui.viewmodels.usecases.ObserveFeedbackUseCase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002BI\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010\u001d\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010 2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010)\u001a\u00020#2\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/merlyn/desktopapp/service/localization/impl/LocalizationServiceImpl;", "Lorg/merlyn/desktopapp/service/localization/impl/LocalizationInitializeServiceImpl;", "Lorg/merlyn/desktopapp/service/localization/LocalizationService;", "localeDao", "Lorg/merlyn/desktopapp/storage/LocaleDao;", "regionDao", "Lorg/merlyn/desktopapp/storage/RegionDao;", "merlynRestServicesClient", "Lorg/merlyn/desktopapp/http/impl/MerlynRestServicesClient;", "observeSimpleMessageEvents", "Lkotlin/Lazy;", "Lorg/merlyn/sharedui/viewmodels/usecases/ObserveFeedbackUseCase;", "afterUpdateLocaleFunction", "Lkotlin/Function0;", "", "afterUpdateRegionFunction", "<init>", "(Lorg/merlyn/desktopapp/storage/LocaleDao;Lorg/merlyn/desktopapp/storage/RegionDao;Lorg/merlyn/desktopapp/http/impl/MerlynRestServicesClient;Lkotlin/Lazy;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "logger", "Lmu/KLogger;", "_localizationContextFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lorg/merlyn/core/spacecontextservice/model/LocalizationContext;", "localizationContextFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getLocalizationContextFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "settingsMetadataUri", "", "setLocale", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "newLocale", "Ljava/util/Locale;", "requestId", "notifyIfNotChange", "", "setLocaleInternal", "setRegion", "newRegion", "Lorg/merlyn/sharedui/regionselection/Region;", "getLocaleToStore", "updateLocaleWhenSettingRegion", "app"})
@SourceDebugExtension(value={"SMAP\nLocalizationServiceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalizationServiceImpl.kt\norg/merlyn/desktopapp/service/localization/impl/LocalizationServiceImpl\n+ 2 MerlynRestServicesClient.kt\norg/merlyn/desktopapp/http/impl/MerlynRestServicesClient\n+ 3 builders.kt\nio/ktor/client/request/BuildersKt\n+ 4 HttpClientCall.kt\nio/ktor/client/call/HttpClientCallKt\n+ 5 TypeInfoJvm.kt\nio/ktor/util/reflect/TypeInfoJvmKt\n+ 6 Json.kt\nkotlinx/serialization/json/Json\n+ 7 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,104:1\n25#2,3:105\n99#3,2:108\n22#3:110\n155#4:111\n17#5,3:112\n96#6:115\n230#7,5:116\n*S KotlinDebug\n*F\n+ 1 LocalizationServiceImpl.kt\norg/merlyn/desktopapp/service/localization/impl/LocalizationServiceImpl\n*L\n46#1:105,3\n46#1:108,2\n46#1:110\n46#1:111\n46#1:112,3\n46#1:115\n78#1:116,5\n*E\n"})
public final class LocalizationServiceImpl
extends LocalizationInitializeServiceImpl
implements LocalizationService {
    @NotNull
    private final MerlynRestServicesClient merlynRestServicesClient;
    @NotNull
    private final Lazy<ObserveFeedbackUseCase> observeSimpleMessageEvents;
    @NotNull
    private final Function0<Unit> afterUpdateLocaleFunction;
    @NotNull
    private final Function0<Unit> afterUpdateRegionFunction;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final MutableStateFlow<LocalizationContext> _localizationContextFlow;
    @NotNull
    private final StateFlow<LocalizationContext> localizationContextFlow;
    @NotNull
    private final String settingsMetadataUri;

    public LocalizationServiceImpl(@NotNull LocaleDao localeDao, @NotNull RegionDao regionDao, @NotNull MerlynRestServicesClient merlynRestServicesClient, @NotNull Lazy<? extends ObserveFeedbackUseCase> observeSimpleMessageEvents, @NotNull Function0<Unit> afterUpdateLocaleFunction, @NotNull Function0<Unit> afterUpdateRegionFunction) {
        Intrinsics.checkNotNullParameter((Object)localeDao, (String)"localeDao");
        Intrinsics.checkNotNullParameter((Object)regionDao, (String)"regionDao");
        Intrinsics.checkNotNullParameter((Object)merlynRestServicesClient, (String)"merlynRestServicesClient");
        Intrinsics.checkNotNullParameter(observeSimpleMessageEvents, (String)"observeSimpleMessageEvents");
        Intrinsics.checkNotNullParameter(afterUpdateLocaleFunction, (String)"afterUpdateLocaleFunction");
        Intrinsics.checkNotNullParameter(afterUpdateRegionFunction, (String)"afterUpdateRegionFunction");
        super(localeDao, regionDao);
        this.merlynRestServicesClient = merlynRestServicesClient;
        this.observeSimpleMessageEvents = observeSimpleMessageEvents;
        this.afterUpdateLocaleFunction = afterUpdateLocaleFunction;
        this.afterUpdateRegionFunction = afterUpdateRegionFunction;
        this.logger = KotlinLogging.INSTANCE.logger(LocalizationServiceImpl::logger$lambda$0);
        String string = localeDao.get().toLanguageTag();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLanguageTag(...)");
        String string2 = ZoneId.systemDefault().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
        this._localizationContextFlow = StateFlowKt.MutableStateFlow((Object)new LocalizationContext(string, string2));
        this.localizationContextFlow = FlowKt.asStateFlow(this._localizationContextFlow);
        this.settingsMetadataUri = "settings?component=METADATA";
    }

    @Override
    @NotNull
    public StateFlow<LocalizationContext> getLocalizationContextFlow() {
        return this.localizationContextFlow;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    @Nullable
    public Object setLocale(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof setLocale.1)) ** GOTO lbl-1000
        var19_2 = $completion;
        if ((var19_2.label & -2147483648) != 0) {
            var19_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                /* synthetic */ Object result;
                final /* synthetic */ LocalizationServiceImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.setLocale((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var20_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var2_5 = this;
                $this$setLocale_u24lambda_u240 = var2_5;
                $i$a$-runCatching-LocalizationServiceImpl$setLocale$2 = 0;
                var5_10 = $this$setLocale_u24lambda_u240.merlynRestServicesClient;
                var6_12 = $this$setLocale_u24lambda_u240.settingsMetadataUri;
                var7_14 = $continuation;
                $i$f$makeGetRequestRelaxed = 0;
                httpRequestBuilder$iv = this_$iv.getRequestBuilder(path$iv);
                var11_22 = json$iv = JsonKt.Json$default(null, (Function1)MerlynRestServicesClient.makeGetRequestRelaxed.json.1.INSTANCE, (int)1, null);
                var12_23 = this_$iv.getClient();
                builder$iv$iv = httpRequestBuilder$iv;
                $i$f$get = 0;
                builder$iv$iv.setMethod(HttpMethod.Companion.getGet());
                $this$request$iv$iv$iv = $this$get$iv$iv;
                $i$f$request = 0;
                $continuation.L$0 = $this$setLocale_u24lambda_u240;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)path$iv);
                $continuation.L$3 = $completion$iv;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)httpRequestBuilder$iv);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)json$iv);
                $continuation.L$6 = var11_22;
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)$this$get$iv$iv);
                $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)builder$iv$iv);
                $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)$this$request$iv$iv$iv);
                $continuation.I$0 = $i$a$-runCatching-LocalizationServiceImpl$setLocale$2;
                $continuation.I$1 = $i$f$makeGetRequestRelaxed;
                $continuation.I$2 = $i$f$get;
                $continuation.I$3 = $i$f$request;
                $continuation.label = 1;
                v0 = new HttpStatement(builder$iv$iv, $this$request$iv$iv$iv).execute((Continuation)$completion$iv);
                ** if (v0 != var20_4) goto lbl49
lbl48:
                // 1 sources

                return var20_4;
lbl49:
                // 1 sources

                ** GOTO lbl71
            }
            case 1: {
                $i$f$request = $continuation.I$3;
                $i$f$get = $continuation.I$2;
                $i$f$makeGetRequestRelaxed = $continuation.I$1;
                $i$a$-runCatching-LocalizationServiceImpl$setLocale$2 = $continuation.I$0;
                $this$request$iv$iv$iv = (HttpClient)$continuation.L$9;
                builder$iv$iv = (HttpRequestBuilder)$continuation.L$8;
                $this$get$iv$iv = (HttpClient)$continuation.L$7;
                var11_22 = (Json)$continuation.L$6;
                json$iv = (Json)$continuation.L$5;
                httpRequestBuilder$iv = (HttpRequestBuilder)$continuation.L$4;
                $completion$iv = $continuation.L$3;
                path$iv = (String)$continuation.L$2;
                this_$iv = (MerlynRestServicesClient)$continuation.L$1;
                $this$setLocale_u24lambda_u240 = (LocalizationServiceImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl71:
                // 2 sources

                $this$get$iv$iv = (HttpResponse)v0;
                $i$f$body = 0;
                $i$f$typeInfo = false;
                kType$iv$iv$iv = Reflection.typeOf(String.class);
                reifiedType$iv$iv$iv = TypesJVMKt.getJavaType((KType)kType$iv$iv$iv);
                $continuation.L$0 = $this$setLocale_u24lambda_u240;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)this_$iv);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)path$iv);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)$completion$iv);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)httpRequestBuilder$iv);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)json$iv);
                $continuation.L$6 = var11_22;
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)$this$body$iv$iv /* !! */ );
                $continuation.L$8 = null;
                $continuation.L$9 = null;
                $continuation.I$0 = $i$a$-runCatching-LocalizationServiceImpl$setLocale$2;
                $continuation.I$1 = $i$f$makeGetRequestRelaxed;
                $continuation.I$2 = $i$f$body;
                $continuation.label = 2;
                v1 = $this$body$iv$iv /* !! */ .getCall().bodyNullable(TypeInfoJvmKt.typeInfoImpl((Type)reifiedType$iv$iv$iv, (KClass)Reflection.getOrCreateKotlinClass(String.class), (KType)kType$iv$iv$iv), (Continuation)$completion$iv);
                ** if (v1 != var20_4) goto lbl94
lbl93:
                // 1 sources

                return var20_4;
lbl94:
                // 1 sources

                ** GOTO lbl111
            }
            case 2: {
                $i$f$body = $continuation.I$2;
                $i$f$makeGetRequestRelaxed = $continuation.I$1;
                $i$a$-runCatching-LocalizationServiceImpl$setLocale$2 = $continuation.I$0;
                $this$body$iv$iv /* !! */  = (HttpResponse)$continuation.L$7;
                var11_22 = (Json)$continuation.L$6;
                json$iv = (Json)$continuation.L$5;
                httpRequestBuilder$iv = (HttpRequestBuilder)$continuation.L$4;
                $completion$iv = $continuation.L$3;
                path$iv = (String)$continuation.L$2;
                this_$iv = (MerlynRestServicesClient)$continuation.L$1;
                $this$setLocale_u24lambda_u240 = (LocalizationServiceImpl)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl111:
                    // 2 sources

                    if (v1 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                    }
                    $this$body$iv$iv /* !! */  = (String)v1;
                    $i$f$decodeFromString = false;
                    this_$iv$iv.getSerializersModule();
                    settingsMetadata = (SettingsData)this_$iv$iv.decodeFromString((DeserializationStrategy)SettingsData.Companion.serializer(), (String)string$iv$iv);
                    receivedLocale = Locale.forLanguageTag(settingsMetadata.getMetadata().getLocale());
                    Intrinsics.checkNotNull((Object)receivedLocale);
                    v2 = UUID.randomUUID().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"toString(...)");
                    $this$setLocale_u24lambda_u240.setLocale(receivedLocale, v2, false);
                    var3_6 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable $i$a$-runCatching-LocalizationServiceImpl$setLocale$2) {
                    var3_6 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-LocalizationServiceImpl$setLocale$2));
                }
                var2_5 = var3_6;
                v3 = Result.exceptionOrNull-impl((Object)var2_5);
                if (v3 != null) {
                    it = var3_6 = v3;
                    $i$a$-onFailure-LocalizationServiceImpl$setLocale$3 = false;
                    this.logger.error((Throwable)it, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, setLocale$lambda$1$0(java.lang.Throwable ), ()Ljava/lang/Object;)((Throwable)it));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void setLocale(@NotNull Locale newLocale, @NotNull String requestId) {
        Intrinsics.checkNotNullParameter((Object)newLocale, (String)"newLocale");
        Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
        this.setLocale(newLocale, requestId, true);
    }

    private final void setLocale(Locale newLocale, String requestId, boolean notifyIfNotChange) {
        Locale locale = this.getLocaleToStore(newLocale);
        if (locale != null) {
            Locale it = locale;
            boolean bl = false;
            this.setLocaleInternal(it);
            ((ObserveFeedbackUseCase)this.observeSimpleMessageEvents.getValue()).render(new FeedbackEvent(Strings.INSTANCE.getCHANGE_LANGUAGE_MESSAGE(), requestId));
            this.afterUpdateLocaleFunction.invoke();
        } else {
            LocalizationServiceImpl $this$setLocale_u24lambda_u243 = this;
            boolean bl = false;
            if (notifyIfNotChange) {
                ((ObserveFeedbackUseCase)$this$setLocale_u24lambda_u243.observeSimpleMessageEvents.getValue()).render(new FeedbackEvent(Strings.INSTANCE.getALREADY_SET_LANGUAGE_MESSAGE(), requestId));
            }
        }
    }

    private final void setLocaleInternal(Locale newLocale) {
        String string;
        String string2;
        LocalizationContext nextValue$iv;
        Object prevValue$iv;
        this.getLocaleDao().update(newLocale);
        this.setLocaleForResources(newLocale);
        MutableStateFlow<LocalizationContext> $this$update$iv = this._localizationContextFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            LocalizationContext it = (LocalizationContext)prevValue$iv;
            boolean bl = false;
            string2 = newLocale.toLanguageTag();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLanguageTag(...)");
            string = ZoneId.systemDefault().getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = new LocalizationContext(string2, string))));
    }

    @Override
    public void setRegion(@NotNull Region newRegion) {
        Intrinsics.checkNotNullParameter((Object)newRegion, (String)"newRegion");
        if (this.updateLocaleWhenSettingRegion(newRegion)) {
            String string = this.getLocaleDao().get().getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLanguage(...)");
            this.setLocaleInternal(LocaleFinder.INSTANCE.find(string, newRegion));
        }
        this.getRegionDao().update(newRegion);
        this.afterUpdateRegionFunction.invoke();
    }

    private final Locale getLocaleToStore(Locale newLocale) {
        Locale locale;
        Locale current = this.getLocaleDao().get();
        if (!Intrinsics.areEqual((Object)current.getLanguage(), (Object)newLocale.getLanguage())) {
            String string = newLocale.getLanguage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLanguage(...)");
            locale = LocaleFinder.INSTANCE.find(string, this.getRegionDao().get());
        } else {
            locale = null;
        }
        return locale;
    }

    private final boolean updateLocaleWhenSettingRegion(Region newRegion) {
        Locale currentLocale = this.getLocaleDao().get();
        String string = this.getLocaleDao().get().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLanguage(...)");
        return !Intrinsics.areEqual((Object)LocaleFinder.INSTANCE.find(string, newRegion), (Object)currentLocale);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object setLocale$lambda$1$0(Throwable $it) {
        return "Unexpected error when getting locale settings: " + $it.getMessage();
    }
}

