/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.sound.sound_effect;

import javafx.scene.media.AudioClip;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.TimeSource;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.merlyn.desktopapp.sound.sound_effect.DefaultSoundEffectPlayerKt;
import org.merlyn.desktopapp.sound.sound_effect.ErrorChime;
import org.merlyn.desktopapp.sound.sound_effect.MenuChime;
import org.merlyn.desktopapp.sound.sound_effect.RcuClickChime;
import org.merlyn.desktopapp.sound.sound_effect.SoundEffect;
import org.merlyn.desktopapp.sound.sound_effect.SoundEffectPlayer;
import org.merlyn.desktopapp.sound.sound_effect.StartChime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\f\u0010\u0017\u001a\u00020\u0007*\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\f\u001a\u0004\b\u000e\u0010\nR\u001b\u0010\u0010\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\f\u001a\u0004\b\u0011\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/merlyn/desktopapp/sound/sound_effect/DefaultSoundEffectPlayer;", "Lorg/merlyn/desktopapp/sound/sound_effect/SoundEffectPlayer;", "<init>", "()V", "logger", "Lmu/KLogger;", "startChime", "Ljavafx/scene/media/AudioClip;", "menuChime", "getMenuChime", "()Ljavafx/scene/media/AudioClip;", "menuChime$delegate", "Lkotlin/Lazy;", "rcuClickChime", "getRcuClickChime", "rcuClickChime$delegate", "errorChime", "getErrorChime", "errorChime$delegate", "play", "", "soundEffect", "Lorg/merlyn/desktopapp/sound/sound_effect/SoundEffect;", "loadAudioClip", "app"})
@SourceDebugExtension(value={"SMAP\nDefaultSoundEffectPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultSoundEffectPlayer.kt\norg/merlyn/desktopapp/sound/sound_effect/DefaultSoundEffectPlayer\n+ 2 measureTime.kt\nkotlin/time/MeasureTimeKt\n*L\n1#1,47:1\n24#2:48\n63#2,3:49\n*S KotlinDebug\n*F\n+ 1 DefaultSoundEffectPlayer.kt\norg/merlyn/desktopapp/sound/sound_effect/DefaultSoundEffectPlayer\n*L\n21#1:48\n21#1:49,3\n*E\n"})
public final class DefaultSoundEffectPlayer
implements SoundEffectPlayer {
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(DefaultSoundEffectPlayer::logger$lambda$0);
    @NotNull
    private final AudioClip startChime;
    @NotNull
    private final Lazy menuChime$delegate = LazyKt.lazy(() -> DefaultSoundEffectPlayer.menuChime_delegate$lambda$0(this));
    @NotNull
    private final Lazy rcuClickChime$delegate = LazyKt.lazy(() -> DefaultSoundEffectPlayer.rcuClickChime_delegate$lambda$0(this));
    @NotNull
    private final Lazy errorChime$delegate = LazyKt.lazy(() -> DefaultSoundEffectPlayer.errorChime_delegate$lambda$0(this));

    public DefaultSoundEffectPlayer() {
        boolean $i$f$measureTime = false;
        TimeSource.Monotonic $this$measureTime$iv$iv = TimeSource.Monotonic.INSTANCE;
        boolean $i$f$measureTime2 = false;
        long mark$iv$iv = $this$measureTime$iv$iv.markNow-z9LOYto();
        boolean bl = false;
        this.startChime = this.loadAudioClip(StartChime.INSTANCE);
        long time = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc((long)mark$iv$iv);
        this.logger.info(() -> DefaultSoundEffectPlayer._init_$lambda$1(time));
    }

    private final AudioClip getMenuChime() {
        Lazy lazy = this.menuChime$delegate;
        return (AudioClip)lazy.getValue();
    }

    private final AudioClip getRcuClickChime() {
        Lazy lazy = this.rcuClickChime$delegate;
        return (AudioClip)lazy.getValue();
    }

    private final AudioClip getErrorChime() {
        Lazy lazy = this.errorChime$delegate;
        return (AudioClip)lazy.getValue();
    }

    @Override
    public void play(@NotNull SoundEffect soundEffect) {
        AudioClip audioClip;
        Intrinsics.checkNotNullParameter((Object)soundEffect, (String)"soundEffect");
        SoundEffect soundEffect2 = soundEffect;
        if (Intrinsics.areEqual((Object)soundEffect2, (Object)ErrorChime.INSTANCE)) {
            audioClip = this.getErrorChime();
        } else if (Intrinsics.areEqual((Object)soundEffect2, (Object)MenuChime.INSTANCE)) {
            audioClip = this.getMenuChime();
        } else if (Intrinsics.areEqual((Object)soundEffect2, (Object)RcuClickChime.INSTANCE)) {
            audioClip = this.getRcuClickChime();
        } else if (Intrinsics.areEqual((Object)soundEffect2, (Object)StartChime.INSTANCE)) {
            audioClip = this.startChime;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        AudioClip clip = audioClip;
        clip.play();
        this.logger.info(() -> DefaultSoundEffectPlayer.play$lambda$0(soundEffect));
    }

    private final AudioClip loadAudioClip(SoundEffect $this$loadAudioClip) {
        return new AudioClip(DefaultSoundEffectPlayerKt.getUrl($this$loadAudioClip).toExternalForm());
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final AudioClip menuChime_delegate$lambda$0(DefaultSoundEffectPlayer this$0) {
        return this$0.loadAudioClip(MenuChime.INSTANCE);
    }

    private static final AudioClip rcuClickChime_delegate$lambda$0(DefaultSoundEffectPlayer this$0) {
        return this$0.loadAudioClip(RcuClickChime.INSTANCE);
    }

    private static final AudioClip errorChime_delegate$lambda$0(DefaultSoundEffectPlayer this$0) {
        return this$0.loadAudioClip(ErrorChime.INSTANCE);
    }

    private static final Object _init_$lambda$1(long $time) {
        return "SoundEffectPlayer initialized in " + Duration.toString-impl((long)$time);
    }

    private static final Object play$lambda$0(SoundEffect $soundEffect) {
        return "Played sound effect " + $soundEffect;
    }
}

