/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.startup.impl;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.merlyn.desktopapp.metrics.Metric;
import org.merlyn.desktopapp.metrics.MetricName;
import org.merlyn.sharedui.viewmodels.usecases.StatusDiagnosticEvents;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011J\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\u0015\u001a\u00020\fJ\u001e\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/merlyn/desktopapp/startup/impl/CheckForUpdatesAnalytics;", "", "statusDiagnosticEvents", "Lorg/merlyn/sharedui/viewmodels/usecases/StatusDiagnosticEvents;", "<init>", "(Lorg/merlyn/sharedui/viewmodels/usecases/StatusDiagnosticEvents;)V", "logger", "Lmu/KLogger;", "updateFailedNotified", "", "updateIgnoredNotified", "resetUpdateFailureSent", "", "metric", "Lorg/merlyn/desktopapp/metrics/Metric;", "sendUpdateCapabilities", "os", "", "currentVersion", "capabilities", "sendUpdateNotification", "sendUpdateSuccess", "sendUpdateFailure", "fromVersion", "toVersion", "attempt", "", "sendUpdateIgnored", "app"})
public final class CheckForUpdatesAnalytics {
    @NotNull
    private final StatusDiagnosticEvents statusDiagnosticEvents;
    @NotNull
    private final KLogger logger;
    private boolean updateFailedNotified;
    private boolean updateIgnoredNotified;
    @NotNull
    private final Metric metric;

    public CheckForUpdatesAnalytics(@NotNull StatusDiagnosticEvents statusDiagnosticEvents) {
        Intrinsics.checkNotNullParameter((Object)statusDiagnosticEvents, (String)"statusDiagnosticEvents");
        this.statusDiagnosticEvents = statusDiagnosticEvents;
        this.logger = KotlinLogging.INSTANCE.logger(CheckForUpdatesAnalytics::logger$lambda$0);
        this.metric = Metric.Companion.instance();
    }

    public final void resetUpdateFailureSent() {
        this.updateFailedNotified = false;
    }

    public final void sendUpdateCapabilities(@NotNull String os, @NotNull String currentVersion, @NotNull String capabilities) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Intrinsics.checkNotNullParameter((Object)currentVersion, (String)"currentVersion");
        Intrinsics.checkNotNullParameter((Object)capabilities, (String)"capabilities");
        this.logger.info(() -> CheckForUpdatesAnalytics.sendUpdateCapabilities$lambda$0(os, currentVersion, capabilities));
        this.statusDiagnosticEvents.updateCapabilities(os, currentVersion, capabilities);
        Object[] objectArray = new Pair[]{new Pair((Object)"os", (Object)os), new Pair((Object)"currentVersion", (Object)currentVersion), new Pair((Object)"capabilities", (Object)capabilities)};
        this.metric.counterIncrement(MetricName.UPDATE_CAPABILITIES, CollectionsKt.listOf((Object[])objectArray));
    }

    public final void sendUpdateNotification() {
        this.logger.info(CheckForUpdatesAnalytics::sendUpdateNotification$lambda$0);
        Metric.counterIncrement$default(this.metric, MetricName.UPDATE_NOTIFIED, null, 2, null);
    }

    public final void sendUpdateSuccess() {
        this.logger.info(CheckForUpdatesAnalytics::sendUpdateSuccess$lambda$0);
        Metric.counterIncrement$default(this.metric, MetricName.UPDATE_SUCCEEDED, null, 2, null);
    }

    public final void sendUpdateFailure(@NotNull String fromVersion, @NotNull String toVersion, int attempt) {
        Intrinsics.checkNotNullParameter((Object)fromVersion, (String)"fromVersion");
        Intrinsics.checkNotNullParameter((Object)toVersion, (String)"toVersion");
        if (this.updateFailedNotified) {
            return;
        }
        this.updateFailedNotified = true;
        this.logger.info(() -> CheckForUpdatesAnalytics.sendUpdateFailure$lambda$0(fromVersion, toVersion, attempt));
        this.statusDiagnosticEvents.updateFailed(fromVersion, toVersion, attempt);
        Object[] objectArray = new Pair[]{new Pair((Object)"fromVersion", (Object)fromVersion), new Pair((Object)"toVersion", (Object)toVersion)};
        this.metric.counterIncrement(MetricName.UPDATE_FAILED, CollectionsKt.listOf((Object[])objectArray));
    }

    public final void sendUpdateIgnored(@NotNull String fromVersion, @NotNull String toVersion) {
        Intrinsics.checkNotNullParameter((Object)fromVersion, (String)"fromVersion");
        Intrinsics.checkNotNullParameter((Object)toVersion, (String)"toVersion");
        if (this.updateIgnoredNotified) {
            return;
        }
        this.updateIgnoredNotified = true;
        this.logger.info(() -> CheckForUpdatesAnalytics.sendUpdateIgnored$lambda$0(fromVersion, toVersion));
        this.statusDiagnosticEvents.updateIgnored(fromVersion, toVersion);
        Object[] objectArray = new Pair[]{new Pair((Object)"fromVersion", (Object)fromVersion), new Pair((Object)"toVersion", (Object)toVersion)};
        this.metric.counterIncrement(MetricName.UPDATE_IGNORED, CollectionsKt.listOf((Object[])objectArray));
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object sendUpdateCapabilities$lambda$0(String $os, String $currentVersion, String $capabilities) {
        return "Notifying update capabilities for OS: " + $os + ", version: " + $currentVersion + ", capabilities: " + $capabilities;
    }

    private static final Object sendUpdateNotification$lambda$0() {
        return "Notifying the user about a new update available";
    }

    private static final Object sendUpdateSuccess$lambda$0() {
        return "Notifying that the update succeeded";
    }

    private static final Object sendUpdateFailure$lambda$0(String $fromVersion, String $toVersion, int $attempt) {
        return "Notifying that the update from " + $fromVersion + " to " + $toVersion + " failed on attempt " + $attempt;
    }

    private static final Object sendUpdateIgnored$lambda$0(String $fromVersion, String $toVersion) {
        return "Notifying that the update from " + $fromVersion + " to " + $toVersion + " was ignored (due to system user permissions)";
    }
}

