/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.view.wrapper.impl;

import com.lordcodes.turtle.ShellKt;
import java.awt.Desktop;
import java.awt.desktop.QuitStrategy;
import java.io.Serializable;
import java.net.URI;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.merlyn.desktopapp.os.HostOS;
import org.merlyn.desktopapp.os.OS;
import org.merlyn.desktopapp.view.wrapper.DesktopWrapper;
import org.merlyn.desktopapp.view.wrapper.impl.DesktopWrapperException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J)\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u0013\"\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/merlyn/desktopapp/view/wrapper/impl/DesktopWrapperImpl;", "Lorg/merlyn/desktopapp/view/wrapper/DesktopWrapper;", "hostOS", "Lorg/merlyn/desktopapp/os/OS;", "<init>", "(Lorg/merlyn/desktopapp/os/OS;)V", "logger", "Lmu/KLogger;", "setQuitStrategy", "", "browse", "uri", "Ljava/net/URI;", "isCommandAvailable", "", "command", "", "runCommand", "args", "", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "Companion", "app"})
@SourceDebugExtension(value={"SMAP\nDesktopWrapperImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesktopWrapperImpl.kt\norg/merlyn/desktopapp/view/wrapper/impl/DesktopWrapperImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class DesktopWrapperImpl
implements DesktopWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OS hostOS;
    @NotNull
    private final KLogger logger;
    @NotNull
    public static final String OPEN_BROWSER_COMMAND_LINUX = "xdg-open";

    public DesktopWrapperImpl(@NotNull OS hostOS) {
        Intrinsics.checkNotNullParameter((Object)((Object)hostOS), (String)"hostOS");
        this.hostOS = hostOS;
        this.logger = KotlinLogging.INSTANCE.logger(DesktopWrapperImpl::logger$lambda$0);
    }

    @Override
    public void setQuitStrategy() {
        block1: {
            if (!Desktop.isDesktopSupported() || !HostOS.INSTANCE.getHostOs().isMacOS()) break block1;
            Desktop desktop = Desktop.getDesktop();
            if (desktop != null) {
                Desktop desktop2;
                Desktop $this$setQuitStrategy_u24lambda_u240 = desktop2 = desktop;
                boolean bl = false;
                $this$setQuitStrategy_u24lambda_u240.setQuitStrategy(QuitStrategy.CLOSE_ALL_WINDOWS);
            }
        }
    }

    @Override
    public void browse(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            Object object;
            Object object2 = this;
            try {
                DesktopWrapperImpl $this$browse_u24lambda_u240 = object2;
                boolean bl = false;
                Desktop.getDesktop().browse(uri);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it = object = throwable;
                boolean bl = false;
                this.logger.error((Throwable)it, () -> DesktopWrapperImpl.browse$lambda$1$0(uri));
            }
            v1 = Result.box-impl((Object)object2);
        } else if (this.hostOS.isLinux() && this.isCommandAvailable(OPEN_BROWSER_COMMAND_LINUX)) {
            String[] stringArray = new String[1];
            Intrinsics.checkNotNullExpressionValue((Object)uri.toString(), (String)"toString(...)");
            v1 = (Serializable)((Object)this.runCommand(OPEN_BROWSER_COMMAND_LINUX, stringArray));
        } else {
            throw new DesktopWrapperException("It is not possible to launch a browser on this machine");
        }
    }

    private final boolean isCommandAvailable(String command) {
        Object object;
        block2: {
            Object object2;
            object = this;
            try {
                DesktopWrapperImpl $this$isCommandAvailable_u24lambda_u240 = object;
                boolean bl = false;
                String[] stringArray = new String[]{"command", "-v", command};
                object2 = Result.constructor-impl((Object)$this$isCommandAvailable_u24lambda_u240.runCommand("bash", stringArray));
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block2;
            Object it = object2 = throwable;
            boolean bl = false;
            this.logger.error("Command " + command + " is not available: " + ((Throwable)it).getMessage(), (Throwable)it);
        }
        return Result.isSuccess-impl((Object)object);
    }

    private final String runCommand(String command, String ... args) {
        return ShellKt.shellRun$default((String)command, (List)ArraysKt.toList((Object[])args), null, (boolean)false, (int)12, null);
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object browse$lambda$1$0(URI $uri) {
        return "Unable to open uri " + $uri;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/merlyn/desktopapp/view/wrapper/impl/DesktopWrapperImpl$Companion;", "", "<init>", "()V", "OPEN_BROWSER_COMMAND_LINUX", "", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

