/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.sharedui.splash;

import java.net.URL;
import javafx.animation.Interpolator;
import javafx.animation.RotateTransition;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.sharedui.res.ImageResources;
import org.merlyn.sharedui.res.Strings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/merlyn/sharedui/splash/SplashScreen;", "Ljavafx/stage/Stage;", "<init>", "()V", "Companion", "sharedui"})
public final class SplashScreen
extends Stage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static SplashScreen splash;

    public SplashScreen() {
        super(StageStyle.TRANSPARENT);
        this.setAlwaysOnTop(true);
        URL uRL = ((Object)((Object)this)).getClass().getResource("/fonts/CircularXX-Regular.otf");
        String fontUrl = uRL != null ? uRL.toExternalForm() : null;
        ImageView backgroundImageView = new ImageView(ImageResources.INSTANCE.getSplashBackground());
        backgroundImageView.fitWidthProperty().bind((ObservableValue)this.widthProperty());
        backgroundImageView.fitHeightProperty().bind((ObservableValue)this.heightProperty());
        Text loadingMessage = new Text(Strings.INSTANCE.getSPLASHSCREEN_WELCOME_TEXT());
        loadingMessage.setFont(Font.loadFont((String)fontUrl, (double)32.0));
        loadingMessage.setFill((Paint)Color.WHITE);
        ImageView spinnerImageView = new ImageView(ImageResources.INSTANCE.getSplashSpinner());
        spinnerImageView.setFitWidth(68.0);
        spinnerImageView.setFitHeight(68.0);
        RotateTransition rotateTransition = new RotateTransition(Duration.seconds((double)1.0), (Node)spinnerImageView);
        rotateTransition.setByAngle(360.0);
        rotateTransition.setCycleCount(-1);
        rotateTransition.setInterpolator(Interpolator.LINEAR);
        rotateTransition.play();
        StackPane root = new StackPane();
        Object[] objectArray = new Node[]{backgroundImageView, spinnerImageView, loadingMessage};
        root.getChildren().addAll(objectArray);
        StackPane.setAlignment((Node)((Node)spinnerImageView), (Pos)Pos.TOP_CENTER);
        StackPane.setMargin((Node)((Node)spinnerImageView), (Insets)new Insets(76.0, 0.0, 0.0, 0.0));
        StackPane.setAlignment((Node)((Node)loadingMessage), (Pos)Pos.BOTTOM_CENTER);
        StackPane.setMargin((Node)((Node)loadingMessage), (Insets)new Insets(0.0, 0.0, 58.0, 0.0));
        double w = 452.0;
        double h = 280.0;
        Scene scene = new Scene((Parent)root, w, h);
        scene.setFill((Paint)Color.TRANSPARENT);
        this.setScene(scene);
        this.setTitle("Merlyn Origin Splash");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/merlyn/sharedui/splash/SplashScreen$Companion;", "", "<init>", "()V", "splash", "Lorg/merlyn/sharedui/splash/SplashScreen;", "isSplashVisible", "", "show", "", "hide", "sharedui"})
    @SourceDebugExtension(value={"SMAP\nSplashScreen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SplashScreen.kt\norg/merlyn/sharedui/splash/SplashScreen$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1#2:82\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSplashVisible() {
            return splash != null;
        }

        public final void show() {
            SplashScreen splashScreen;
            if (this.isSplashVisible()) {
                return;
            }
            SplashScreen it = splashScreen = new SplashScreen();
            boolean bl = false;
            it.show();
            splash = splashScreen;
        }

        public final void hide() {
            if (!this.isSplashVisible()) {
                return;
            }
            SplashScreen splashScreen = splash;
            if (splashScreen != null) {
                splashScreen.hide();
            }
            splash = null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

